/*
    Glurp - A GTK+ client for Music Player Daemon
    Copyright (C) 2004, 2005 Andrej Kacian

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    http://musicpd.org/glurp.shtml

*/

#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <glade/glade.h>

#include "structs.h"
#include "support.h"
#include "player.h"

extern GladeXML *guixml, *configxml, *plxml, *addxml, *streamxml;
extern GlurpState *glurp;

/* MAIN WINDOW SHORTCUTS */
gboolean on_main_key_pressed(GtkWidget *widget, GdkEventKey *key, gpointer data) {
  guint k = key->keyval;

  if( GTK_WIDGET_HAS_FOCUS(glade_xml_get_widget(guixml, "entry_qsearch")) )
    return FALSE;

  /* previous */
  if( k == GDK_Z || k == GDK_z ) {
    if( !STOPPED ) g_signal_emit_by_name((gpointer)glade_xml_get_widget(guixml, "button_prev"), "clicked");
    return TRUE;
  }

  /* play */
  if( k == GDK_X || k == GDK_x ) {
    if( !PLAYING ) g_signal_emit_by_name((gpointer)glade_xml_get_widget(guixml, "button_play"), "clicked");
    return TRUE;
  }

  /* pause */
  if( k == GDK_C || k == GDK_c ) {
    if( PLAYING ) g_signal_emit_by_name((gpointer)glade_xml_get_widget(guixml, "button_pause"), "clicked");
    return TRUE;
  }

  /* stop */
  if( k == GDK_V || k == GDK_v ) {
    if( !STOPPED ) g_signal_emit_by_name((gpointer)glade_xml_get_widget(guixml, "button_stop"), "clicked");
    return TRUE;
  }

  /* next */
  if( k == GDK_B || k == GDK_b ) {
    if( !STOPPED ) g_signal_emit_by_name((gpointer)glade_xml_get_widget(guixml, "button_next"), "clicked");
    return TRUE;
  }

  /* playlist show/hide */
  if( k == GDK_p ) {
    if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(glade_xml_get_widget(guixml, "togglebutton_playlist"))) ) 
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(glade_xml_get_widget(guixml, "togglebutton_playlist")), FALSE);
    else
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(glade_xml_get_widget(guixml, "togglebutton_playlist")), TRUE);

    g_signal_emit_by_name((gpointer)glade_xml_get_widget(guixml, "togglebutton_playlist"), "clicked");
    return TRUE;
  }

  if( k == GDK_P ) {
    g_signal_emit_by_name((gpointer)glade_xml_get_widget(guixml, "button_pl_shuffle"), "clicked");
    return TRUE;
  }
    
  /* toggle repeat */
  if( k == GDK_E || k == GDK_e ) {
    if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(glade_xml_get_widget(guixml, "togglebutton_repeat"))) ) 
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(glade_xml_get_widget(guixml, "togglebutton_repeat")), FALSE);
    else
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(glade_xml_get_widget(guixml, "togglebutton_repeat")), TRUE);

    g_signal_emit_by_name((gpointer)glade_xml_get_widget(guixml, "togglebutton_repeat"), "clicked");
    return TRUE;
  }

  /* toggle random */
  if( k == GDK_A || k == GDK_a ) {
    if( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(glade_xml_get_widget(guixml, "togglebutton_random"))) ) 
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(glade_xml_get_widget(guixml, "togglebutton_random")), FALSE);
    else
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(glade_xml_get_widget(guixml, "togglebutton_random")), TRUE);

    g_signal_emit_by_name((gpointer)glade_xml_get_widget(guixml, "togglebutton_random"), "clicked");
    return TRUE;
  }

  /* add file */
  if( (k == GDK_Insert || k == GDK_KP_Insert) && !(key->state & GDK_SHIFT_MASK) ) {
    g_signal_emit_by_name((gpointer)glade_xml_get_widget(guixml, "menu_add_file"), "activate");
    return TRUE;
  }

  /* add url */
  if( (k == GDK_Insert || k == GDK_KP_Insert) && (key->state & GDK_SHIFT_MASK) ) {
    g_signal_emit_by_name((gpointer)glade_xml_get_widget(guixml, "menu_add_url"), "activate");
    return TRUE;
  }

  /* remove selected */
  if( (k == GDK_Delete || k == GDK_KP_Delete) && !(key->state & GDK_SHIFT_MASK) && !(key->state & GDK_CONTROL_MASK) ) {
    g_signal_emit_by_name((gpointer)glade_xml_get_widget(guixml, "menu_remove_selected"), "activate");
    return TRUE;
  }

  /* remove crop */
  if( (k == GDK_Delete || k == GDK_KP_Delete) && (key->state & GDK_SHIFT_MASK) && !(key->state & GDK_CONTROL_MASK) ) {
    g_signal_emit_by_name((gpointer)glade_xml_get_widget(guixml, "menu_remove_crop"), "activate");
    return TRUE;
  }

  /* remove all */
  if( (k == GDK_Delete || k == GDK_KP_Delete) && !(key->state & GDK_SHIFT_MASK) && (key->state & GDK_CONTROL_MASK) ) {
    g_signal_emit_by_name((gpointer)glade_xml_get_widget(guixml, "menu_remove_all"), "activate");
    return TRUE;
  }

/*  debug("MAIN WINDOW KEYPRESS: %d", k); */

  return FALSE;
}

/*****************************************************************************/
/* CONFIG WINDOW */
gboolean on_config_key_pressed(GtkWidget *widget, GdkEventKey *key, gpointer data) {
  guint k = key->keyval;

/*  debug("CONFIG WINDOW KEYPRESS: %d", k); */

  /* escape to close config window */
  if( k == GDK_Escape ) {
    g_signal_emit_by_name((gpointer)glade_xml_get_widget(configxml, "button_config_cancel"), "activate");
    return TRUE;
  }

  return FALSE;
}

/*****************************************************************************/
/* PLAYLISTS WINDOW */
gboolean on_pllist_key_pressed(GtkWidget *widget, GdkEventKey *key, gpointer data) {
  guint k = key->keyval;

/*  debug("PLAYLISTS WINDOW KEYPRESS: %d", k); */

  /* escape to close config window */
  if( k == GDK_Escape ) {
    g_signal_emit_by_name((gpointer)glade_xml_get_widget(plxml, "button_playlist_close"), "clicked");
    return TRUE;
  }

  return FALSE;
}

/*****************************************************************************/
/* ADD FILE WINDOW */
gboolean on_add_key_pressed(GtkWidget *widget, GdkEventKey *key, gpointer data) {
  guint k = key->keyval;
  GtkTreeView *tv = NULL;
  GtkTreeModel *tm = NULL;
  GtkTreeSelection *sel = NULL;
  GtkTreePath *path;
  gint num;
  GList *selected_rows;

/*  debug("ADD FILE WINDOW KEYPRESS: %d", k); */

  /* escape to close add window */
  if( k == GDK_Escape ) {
    g_signal_emit_by_name((gpointer)glade_xml_get_widget(addxml, "button_add_close"), "activate");
    return TRUE;
  }

  /* enter to add selected */
  if( (k == GDK_Return) || (k == GDK_KP_Enter) ) {
    if ( GTK_WIDGET_HAS_FOCUS(glade_xml_get_widget(addxml, "entry_add_find_what") ) ) {
      g_signal_emit_by_name((gpointer)glade_xml_get_widget(addxml, "button_add_find"), "activate");
    } else {
      g_signal_emit_by_name((gpointer)glade_xml_get_widget(addxml, "button_add_add"), "activate");
    }
    return TRUE;
  }

  /* expand/move to first child */
  if( k == GDK_Right || k == GDK_KP_Right ) {
    tv = GTK_TREE_VIEW(glade_xml_get_widget(addxml, "treeview_add"));
    tm = gtk_tree_view_get_model(tv);

    sel = gtk_tree_view_get_selection(tv);

    if( !(num = gtk_tree_selection_count_selected_rows(sel)) ) return TRUE;

    if( !(selected_rows = gtk_tree_selection_get_selected_rows(sel, &tm)) ) {
      debug("Couldn't get selected rows");
      return TRUE;
    }

    path = (GtkTreePath *)g_list_nth_data(selected_rows, 0);

    if( gtk_tree_view_row_expanded(tv, path) ) {
      gtk_tree_path_down(path);
    } else {
      gtk_tree_view_expand_row(tv, path, FALSE);
    }

    gtk_tree_view_set_cursor(tv, path, NULL, FALSE);

    return TRUE;
  }

  /* collapse/move to parent */
  if( k == GDK_Left || k == GDK_KP_Left ) {
    tv = GTK_TREE_VIEW(glade_xml_get_widget(addxml, "treeview_add"));
    tm = gtk_tree_view_get_model(tv);

    sel = gtk_tree_view_get_selection(tv);

    if( !(num = gtk_tree_selection_count_selected_rows(sel)) ) return TRUE;

    if( !(selected_rows = gtk_tree_selection_get_selected_rows(sel, &tm)) ) {
      debug("Couldn't get selected rows");
      return TRUE;
    }

    path = (GtkTreePath *)g_list_nth_data(selected_rows, 0);

    if( gtk_tree_view_row_expanded(tv, path) ) {
      gtk_tree_view_collapse_row(tv, path);
    } else {
      gtk_tree_path_up(path);
    }

    gtk_tree_view_set_cursor(tv, path, NULL, FALSE);

    return TRUE;
  }

  return FALSE;
}

/*****************************************************************************/
/* ADD STREAM WINDOW */
gboolean on_stream_key_pressed(GtkWidget *widget, GdkEventKey *key, gpointer data) {
  guint k = key->keyval;

/*  debug("STREAM WINDOW KEYPRESS: %d", k); */

  /* escape to close config window */
  if( k == GDK_Escape ) {
    g_signal_emit_by_name((gpointer)glade_xml_get_widget(streamxml, "button_stream_close"), "activate");
    return TRUE;
  }

  return FALSE;
}
