
/* This file is part of MetaDOM
 * a generic bind package for the Document Object Model API.
 * Copyright (C) 2001  Luca Padovani <luca.padovani@cs.unibo.it>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more information, please visit the author's home page
 * http://www.cs.unibo.it/~lpadovan
 * or send an email to <luca.padovani@cs.unibo.it>
 *
 * DO NOT EDIT: this file has been generated automatically by MetaDOM
 */

#include <gdome.h>


#include "GdomeSmartDOMBasic.hh"
#include "GdomeSmartDOMDOMImplementation.hh"
#include "GdomeSmartDOMCore.hh"


namespace GdomeSmartDOM {

Node::Node(GdomeNode* obj)

{
  gdome_obj = obj;
  if (gdome_obj != 0) {
    GdomeException exc_;
    gdome_n_ref(gdome_obj, &exc_);
    if (exc_ != 0) throw DOMException(exc_, "Node::Node");
  }
}

Node::Node(const Node& obj)
  
{
  
  GdomeException exc_ = 0;
  gdome_obj = obj.gdome_obj;
  if (gdome_obj != 0) gdome_n_ref(gdome_obj, &exc_);
  if (exc_ != 0) throw DOMException(exc_, "Node::Node casting from Node");
  
}

  Node& Node::operator=(const Node& obj)
{
  if (this == &obj) return *this;

  GdomeException exc_ = 0;

  if (gdome_obj != 0) {

    gdome_n_unref(gdome_obj, &exc_);
  

    gdome_obj = 0;
  }
  
  if (exc_ == 0) {
    gdome_obj = obj.gdome_obj;

    if (gdome_obj != 0) gdome_n_ref(gdome_obj, &exc_);
  
  }
  
  if (exc_ != 0) throw DOMException(exc_, "Node::operator=");

  return *this;
}

bool Node::operator==(const Node& obj) const
{
  return gdome_obj == obj.gdome_obj;
}

Node::~Node()
{
  
  if (gdome_obj != 0) {
    GdomeException exc_;
    gdome_n_unref(gdome_obj, &exc_);
    if (exc_ != 0) throw DOMException(exc_, "Node::~Node");
    gdome_obj = 0;
  }
  
}


GdomeNode* Node::gdome_object() const
{
  if (gdome_obj != 0) {
    GdomeException exc_;
    gdome_n_ref(gdome_obj, &exc_);
    if (exc_ != 0) throw DOMException(exc_, "Node::gdome_object");
  }

  return gdome_obj;
}

void*
Node::get_userData() const
{
  if (gdome_obj == 0) throw DOMException(GDOME_NULL_POINTER_ERR, "Node::get_userData");
  return gdome_obj->user_data;
}

void
Node::set_userData(void* v) const
{
  if (gdome_obj == 0) throw DOMException(GDOME_NULL_POINTER_ERR, "Node::set_userData");
  gdome_obj->user_data = v;
}
DOMString Node::get_nodeName() const
{
  GdomeException exc_;
  GdomeDOMString* res_ = gdome_n_nodeName((GdomeNode*) gdome_obj, &exc_);
  if (exc_ != 0) throw DOMException(exc_, "Node::get_nodeName");
  return DOMString_of_GdomeDOMString(res_);
}

DOMString Node::get_nodeValue() const
{
  GdomeException exc_;
  GdomeDOMString* res_ = gdome_n_nodeValue((GdomeNode*) gdome_obj, &exc_);
  if (exc_ != 0) throw DOMException(exc_, "Node::get_nodeValue");
  return DOMString_of_GdomeDOMString(res_);
}

void
Node::set_nodeValue(const DOMString& v) const
{
  GdomeException exc_;
  GdomeDOMString* v_ = GdomeDOMString_of_DOMString(v);
  gdome_n_set_nodeValue((GdomeNode*) gdome_obj, v_, &exc_);
  
  if (v_ != 0) gdome_str_unref(v_);
  
  if (exc_ != 0) throw DOMException(exc_, "Node::set_nodeValue");
}

unsigned short Node::get_nodeType() const
{
  GdomeException exc_;
  unsigned short res_ = gdome_n_nodeType((GdomeNode*) gdome_obj, &exc_);
  if (exc_ != 0) throw DOMException(exc_, "Node::get_nodeType");
  return res_;
}

Node Node::get_parentNode() const
{
  GdomeException exc_;
  GdomeNode* res_ = gdome_n_parentNode((GdomeNode*) gdome_obj, &exc_);
  if (exc_ != 0) throw DOMException(exc_, "Node::get_parentNode");
  return Node(res_);
}

NodeList Node::get_childNodes() const
{
  GdomeException exc_;
  GdomeNodeList* res_ = gdome_n_childNodes((GdomeNode*) gdome_obj, &exc_);
  if (exc_ != 0) throw DOMException(exc_, "Node::get_childNodes");
  return NodeList(res_);
}

Node Node::get_firstChild() const
{
  GdomeException exc_;
  GdomeNode* res_ = gdome_n_firstChild((GdomeNode*) gdome_obj, &exc_);
  if (exc_ != 0) throw DOMException(exc_, "Node::get_firstChild");
  return Node(res_);
}

Node Node::get_lastChild() const
{
  GdomeException exc_;
  GdomeNode* res_ = gdome_n_lastChild((GdomeNode*) gdome_obj, &exc_);
  if (exc_ != 0) throw DOMException(exc_, "Node::get_lastChild");
  return Node(res_);
}

Node Node::get_previousSibling() const
{
  GdomeException exc_;
  GdomeNode* res_ = gdome_n_previousSibling((GdomeNode*) gdome_obj, &exc_);
  if (exc_ != 0) throw DOMException(exc_, "Node::get_previousSibling");
  return Node(res_);
}

Node Node::get_nextSibling() const
{
  GdomeException exc_;
  GdomeNode* res_ = gdome_n_nextSibling((GdomeNode*) gdome_obj, &exc_);
  if (exc_ != 0) throw DOMException(exc_, "Node::get_nextSibling");
  return Node(res_);
}

NamedNodeMap Node::get_attributes() const
{
  GdomeException exc_;
  GdomeNamedNodeMap* res_ = gdome_n_attributes((GdomeNode*) gdome_obj, &exc_);
  if (exc_ != 0) throw DOMException(exc_, "Node::get_attributes");
  return NamedNodeMap(res_);
}

Document Node::get_ownerDocument() const
{
  GdomeException exc_;
  GdomeDocument* res_ = gdome_n_ownerDocument((GdomeNode*) gdome_obj, &exc_);
  if (exc_ != 0) throw DOMException(exc_, "Node::get_ownerDocument");
  return Document(res_);
}

DOMString Node::get_namespaceURI() const
{
  GdomeException exc_;
  GdomeDOMString* res_ = gdome_n_namespaceURI((GdomeNode*) gdome_obj, &exc_);
  if (exc_ != 0) throw DOMException(exc_, "Node::get_namespaceURI");
  return DOMString_of_GdomeDOMString(res_);
}

DOMString Node::get_prefix() const
{
  GdomeException exc_;
  GdomeDOMString* res_ = gdome_n_prefix((GdomeNode*) gdome_obj, &exc_);
  if (exc_ != 0) throw DOMException(exc_, "Node::get_prefix");
  return DOMString_of_GdomeDOMString(res_);
}

void
Node::set_prefix(const DOMString& v) const
{
  GdomeException exc_;
  GdomeDOMString* v_ = GdomeDOMString_of_DOMString(v);
  gdome_n_set_prefix((GdomeNode*) gdome_obj, v_, &exc_);
  
  if (v_ != 0) gdome_str_unref(v_);
  
  if (exc_ != 0) throw DOMException(exc_, "Node::set_prefix");
}

DOMString Node::get_localName() const
{
  GdomeException exc_;
  GdomeDOMString* res_ = gdome_n_localName((GdomeNode*) gdome_obj, &exc_);
  if (exc_ != 0) throw DOMException(exc_, "Node::get_localName");
  return DOMString_of_GdomeDOMString(res_);
}

Node Node::insertBefore(const Node& newChild, const Node& refChild) const
{
  GdomeException exc_;
  GdomeNode* res_ = gdome_n_insertBefore((GdomeNode*) gdome_obj, (GdomeNode*) newChild.gdome_object(), (GdomeNode*) refChild.gdome_object(), &exc_);
  
  if (exc_ != 0) throw DOMException(exc_, "Node::insertBefore");
  return Node(res_);
}

Node Node::replaceChild(const Node& newChild, const Node& oldChild) const
{
  GdomeException exc_;
  GdomeNode* res_ = gdome_n_replaceChild((GdomeNode*) gdome_obj, (GdomeNode*) newChild.gdome_object(), (GdomeNode*) oldChild.gdome_object(), &exc_);
  
  if (exc_ != 0) throw DOMException(exc_, "Node::replaceChild");
  return Node(res_);
}

Node Node::removeChild(const Node& oldChild) const
{
  GdomeException exc_;
  GdomeNode* res_ = gdome_n_removeChild((GdomeNode*) gdome_obj, (GdomeNode*) oldChild.gdome_object(), &exc_);
  
  if (exc_ != 0) throw DOMException(exc_, "Node::removeChild");
  return Node(res_);
}

Node Node::appendChild(const Node& newChild) const
{
  GdomeException exc_;
  GdomeNode* res_ = gdome_n_appendChild((GdomeNode*) gdome_obj, (GdomeNode*) newChild.gdome_object(), &exc_);
  
  if (exc_ != 0) throw DOMException(exc_, "Node::appendChild");
  return Node(res_);
}

bool Node::hasChildNodes() const
{
  GdomeException exc_;
  GdomeBoolean res_ = gdome_n_hasChildNodes((GdomeNode*) gdome_obj, &exc_);
  
  if (exc_ != 0) throw DOMException(exc_, "Node::hasChildNodes");
  return res_;
}

Node Node::cloneNode(const bool deep) const
{
  GdomeException exc_;
  GdomeNode* res_ = gdome_n_cloneNode((GdomeNode*) gdome_obj, deep, &exc_);
  
  if (exc_ != 0) throw DOMException(exc_, "Node::cloneNode");
  return Node(res_);
}

void Node::normalize() const
{
  GdomeException exc_;
  gdome_n_normalize((GdomeNode*) gdome_obj, &exc_);
  
  if (exc_ != 0) throw DOMException(exc_, "Node::normalize");
  
}

bool Node::isSupported(const DOMString& feature, const DOMString& version) const
{
  GdomeException exc_;
  GdomeDOMString* feature_ = GdomeDOMString_of_DOMString(feature);
  GdomeDOMString* version_ = GdomeDOMString_of_DOMString(version);
  GdomeBoolean res_ = gdome_n_isSupported((GdomeNode*) gdome_obj, feature_, version_, &exc_);
  
  if (feature_ != 0) gdome_str_unref(feature_);
  
  if (version_ != 0) gdome_str_unref(version_);
  
  if (exc_ != 0) throw DOMException(exc_, "Node::isSupported");
  return res_;
}

bool Node::hasAttributes() const
{
  GdomeException exc_;
  GdomeBoolean res_ = gdome_n_hasAttributes((GdomeNode*) gdome_obj, &exc_);
  
  if (exc_ != 0) throw DOMException(exc_, "Node::hasAttributes");
  return res_;
}



}

