.TH PSROSE l "18 Apr 2001"
.SH NAME
psrose \- Plot (length, azimuth) as windrose diagram or polar histogram (sector or rose diagram).
.SH SYNOPSIS
\fBpsrose\fP \fIfile\fP [ \fB\-A\fP\fIsector_width\fP[\fBr\fP] ]
[ \fB\-B\fP\fItickinfo\fP ] [ \fB\-C\fP[\fImode-file\fP] ] [ \fB\-E\fP\fIazimuth/elevation\fP ] [ \fB\-G\fP\fIfill\fP ]
[ \fB\-H\fP[\fInrec\fP] ] [ \fB\-I\fP ] [ \fB\-K\fP ] [ \fB\-M\fP[\fIparameters\fP ] [ \fB\-O\fP ] [ \fB\-P\fP ]
[ \fB\-R\fP\fIr0/r1/az_0/az_1\fP ] [ \fB\-S\fP\fIradial_scale\fP[\fBn\fP] ] [ \fB\-T\fP ] [ \fB\-U\fP[\fI/dx/dy/\fP][\fIlabel\fP] ]
[ \fB\-V\fP ] [ \fB\-W\fP\fIpen\fP ] [ \fB\-X\fP\fIx-shift\fP ]
[ \fB\-Y\fP\fIy-shift\fP ] [ \fB\-Z\fP\fIscale\fP ] [ \fB\-c\fP\fIcopies\fP ] [ \fB\-:\fP ] [ \fB\-bi\fP[\fBs\fP][\fIn\fP] ]
.SH DESCRIPTION
\fBpsrose\fP reads (length,azimuth) pairs from \fIfile\fP [or standard input] and
generates \fIPostScript\fP code that will plot a windrose diagram. Optionally (with \fB\-A\fP), polar histograms
may be drawn (sector diagram or rose diagram). Options include full circle and half circle plots.
The \fIPostScript\fP code is written to standard output.
.TP
\fIfile\fP
Name of ASCII [or binary, see \fB\-b\fP] data file. If no file is given, psrose will read standard input.
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-A
Gives the sector width in degrees for sector and rose diagram. [Default 0 means windrose diagram]. Append \fBr\fP to draw
rose diagram instead of sector diagram.
.TP
.B \-B
Sets map boundary tickmark intervals. See \fBpsbasemap\fP for details.
Remember that "x" here is radial distance and
"y" is azimuth. The ylabel may be used to plot a figure caption.
.TP
.B \-C
Plot vectors showing the principal directions given in the \fImodes\fP file. If no file is
given, compute and plot mean direction.
.TP
.B \-E
Sets the viewpoint's azimuth and elevation [180/90]'
.TP
.B \-G
Selects shade or color for sector infill [Default is no fill].
Specify the shade (0\-255) or color (r/g/b, each in 0\-255).
.TP
.B \-H
Input file(s) has Header record(s). Number of header records can be changed by editing
your \.gmtdefaults file. If used, \fBGMT\fP default is 1 header record.
.TP
.B \-I
Inquire. Computes statistics needed to specify useful \fB\-R\fP. No plot is generated.
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-M
Specify new arrow attributes tailwidth/headlength/headwidth/r/g/b to change
the appearance of arrows (Only if \fB\-C\fP is set). [Default is 0.075\fBc\fP/0.3\fBc\fP/0.25\fBc\fP/0/0/0 (or 0.03\fBi\fP/0.12\fBi\fP/0.1\fBi\fP/0/0/0)].
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see gmtdefaults to change this].
.TP
.B \-R
Specifies the 'region' of interest in (r,azimuth) space. r0 is 0, r1 is max length in units. For azimuth, specify
-90/90 for half circle plot or 0/360 for full circle.
.TP
.B \-S
Specifies radius of circle. Append \fBn\fP to normalize input radii to go from 0 to 1.
.TP
.B \-T
Specifies that the input data is orientation data (has a 180 degree ambiguity) instead of true
0-360 degree directions [Default].
.TP
.B \-U
Draw Unix System time stamp on plot. User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot. Optionally,
append a label, or \fBc\fP (which will plot the command string.). The GMT parameters
UNIX_TIME and UNIX_TIME_POS can affect the appearance; see the \fBgmtdefaults\fP man
page for details.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
Set pen attributes for sector outline or rose plot. [Default is no outline].
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP).
Prepend \fBa\fP for absolute coordinates;
the default (\fBr\fP) will reset plot origin.
.TP
.B \-Z
Multiply the data radii by \fIscale\fP. E.g., use \fB\-Z\fP0.001 to convert your data from m to km [Default is no scaling].
.TP
.B \-c
Specifies the number of plot copies. [Default is 1]
.TP
.B \-:
Input file has (azimuth,radius) pairs rather than the expected (radius,azimuth).
.TP
.B \-bi
Selects binary input. Append \fBs\fP for single precision [Default is double].
Append \fIn\fP for the number of columns in the binary file(s).
[Default is 2 input columns].
.SH EXAMPLES
To plot a half circle rose diagram of the data in the file fault_segments.az_r (containing
pairs of (azimuth, length in meters), using a 10 degree bin sector width,
on a circle of radius = 3 inch, grid going out to radius = 150 km in steps of 25 km with a 30 degree
sector interval, radial direction annotated every 50 km, using a light blue shading (200/240/255) outlined
by a solid red pen (width = 0.75 points), draw the mean azimuth, and shown in Portrait orientation, try:
.br
.sp
psrose fault_segments.az_r \fB\-R\fP0/150/-90/90 \fB\-B\fP50g25:"Fault length":/g30:."Rose diagram":
\fB\-S\fP3\fBi\fP \fB\-A\fP10\fBr \-G\fP200/240/255 \fB\-W\fP0.75\fBp\fP/255/0/0 \fB\-Z\fP0.001 \fB\-C\fP \fB\-P \-T\fP \fB\-:\fP | lpr
.br
.sp
To plot a full circle wind rose diagram of the data in the file lines.r_az, on a circle of radius = 5 cm,
grid going out to radius = 500 units in steps of 100 with a 45 degree sector interval, using a solid pen (width = 0.5 point),
and shown in landscape [Default] orientation with UNIX timestamp and command line plotted, try:
.br
.sp
psrose lines.az_r \fB\-R\fP0/500/0/360 \fB\-S\fP5\fBc\fP \fB\-Bg\fP100/\fBg\fP45:."Windrose diagram": \fB\-W\fP0.5\fBp\fP \fB\-Uc\fP | lpr
.SH BUGS
No default radial scale and grid settings for polar histograms. User must run \fBpsrose \-I\fP to find max length in
binned data set.
.SH "SEE ALSO"
.IR gmt (l),
.IR gmtdefaults (l),
.IR pshistogram (l)
