/**
 * GMyth Library
 *
 * @file gmyth/gmyth_livetv.h
 * 
 * @brief <p> GMythLiveTV starts a remote TV session with the MythTV backend.
 *
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia.
 * @author Rosfran Lins Borges <rosfran.borges@indt.org.br>
 *
* 
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU Lesser General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
	* but WITHOUT ANY WARRANTY; without even the implied warranty of
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	* GNU General Public License for more details.
	*
	* You should have received a copy of the GNU Lesser General Public License
	* along with this program; if not, write to the Free Software
	* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	*/

#ifndef GMYTH_LIVETV_H_
#define GMYTH_LIVETV_H_

#include <glib.h>
#include <glib-object.h>

#include "gmyth_recorder.h"
#include "gmyth_tvchain.h"
#include "gmyth_monitor_handler.h"
#include "gmyth_file.h"
#include "gmyth_programinfo.h"
#include "gmyth_backendinfo.h"

G_BEGIN_DECLS
#define GMYTH_LIVETV_TYPE               (gmyth_livetv_get_type ())
#define GMYTH_LIVETV(obj)               (G_TYPE_CHECK_INSTANCE_CAST ((obj), GMYTH_LIVETV_TYPE, GMythLiveTV))
#define GMYTH_LIVETV_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), GMYTH_LIVETV_TYPE, GMythLiveTVClass))
#define IS_GMYTH_LIVETV(obj)            (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GMYTH_LIVETV_TYPE))
#define IS_GMYTH_LIVETV_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GMYTH_LIVETV_TYPE))
#define GMYTH_LIVETV_GET_CLASS(obj)     (G_TYPE_INSTANCE_GET_CLASS ((obj), GMYTH_LIVETV_TYPE, GMythLiveTVClass))
typedef struct _GMythLiveTV GMythLiveTV;
typedef struct _GMythLiveTVClass GMythLiveTVClass;

struct _GMythLiveTVClass {
    GObjectClass    parent_class;

    /*
     * callbacks 
     */
};

struct _GMythLiveTV {
    GObject         parent;

    GMythSocket    *socket;

    GString        *local_hostname;

    GMythBackendInfo *backend_info;

    GMythRecorder  *recorder;
    GMythTVChain   *tvchain;
    GMythProgramInfo *proginfo;

    GMythFile      *file;

    GMythMonitorHandler *monitor;
    GMythURI       *uri;

    gboolean        is_livetv;
    gboolean        setup_done;

    GMutex         *mutex;
    gboolean        disposed;
};

GType           gmyth_livetv_get_type(void);

GMythLiveTV    *gmyth_livetv_new(GMythBackendInfo * backend_info);

void            gmyth_livetv_start_playing(GMythLiveTV * livetv);
void            gmyth_livetv_stop_playing(GMythLiveTV * livetv);

gboolean        gmyth_livetv_setup(GMythLiveTV * livetv);
gboolean        gmyth_livetv_channel_setup(GMythLiveTV * livetv,
                                           gint channel);
gboolean        gmyth_livetv_channel_name_setup(GMythLiveTV * livetv,
                                                gchar * channel);
gboolean        gmyth_livetv_next_program_chain(GMythLiveTV * livetv);

GMythFile      *gmyth_livetv_create_file_transfer(GMythLiveTV * livetv);

gboolean        gmyth_livetv_monitor_handler_start(GMythLiveTV * livetv);
void            gmyth_livetv_monitor_handler_stop(GMythLiveTV * livetv);

G_END_DECLS
#endif                          /* GMYTH_LIVETV_H_ */
