#include <glib-object.h>
#include <gmyth/gmyth.h>
#include <glib.h>

#include "common.h"

int
main(int args, const char **argv)
{
    GMythBackendInfo *backend_info;
    g_type_init();
    g_thread_init(NULL);

    backend_info = gmyth_backend_info_new();

    GMythVlc        vlc;
    vlc.n_inputs = 0;
    vlc.n_outputs = 0;

    gmyth_backend_info_set_hostname(backend_info, "192.168.3.137");
    gmyth_backend_info_set_port(backend_info, 6543);

    int             res =
        gmyth_vlc_connect(&vlc, backend_info, "admin", 4212);

    if (res >= 0) {
        gmyth_vlc_create_channel(&vlc, "broadcast", 8080, THEORA);
        gmyth_vlc_create_input(&vlc, 0, "/tmp/mpg/bad_day.mpg");
        gmyth_vlc_control_input(&vlc, 0, "play");
        gmyth_vlc_disconnect(&vlc);
    }
    // gchar* teste = gmyth_http_retrieve_setting(backend_info,
    // "RecordFilePrefix", "hmelo-desktop");

    fprintf(stdout, SYNC_STRING);
    fflush(NULL);
    getchar();

    if (backend_info != NULL)
        g_object_unref(backend_info);

    return (0);
}
