#include "gnapster.h"

#ifndef HAVE_GNOME
extern GtkItemFactory *browse_popup_menu;
#else
static GnomeUIInfo browse_popup_menu[] = {
   GNOMEUIINFO_ITEM_STOCK(N_("Download"), NULL, browse_download_cb,
			  GNOME_STOCK_MENU_NEW),
   GNOMEUIINFO_END,
};
#endif /* ! HAVE_GNOME */

extern GnapsterMain *gmain;

void append_bt_server(STab *stab) {
   GtkWidget *mitem;
   
   mitem = gtk_menu_item_new_with_label(stab->ci->server);
   gtk_signal_connect(GTK_OBJECT(mitem), "activate",
		      GTK_SIGNAL_FUNC(set_bt_server), stab);
   gtk_menu_append(GTK_MENU(gmain->bt->smenu), mitem);
   gtk_menu_item_activate(GTK_MENU_ITEM(mitem));
   gtk_widget_show(mitem);
   
   if (!gtk_option_menu_get_menu(GTK_OPTION_MENU(gmain->bt->omenu)))
     gtk_option_menu_set_menu(GTK_OPTION_MENU(gmain->bt->omenu),
			      gmain->bt->smenu);
   
   gtk_option_menu_set_history(GTK_OPTION_MENU(gmain->bt->omenu),
			       stab->pn);
}

void remove_bt_servers(STab *stab) {
   gtk_option_menu_remove_menu(GTK_OPTION_MENU(gmain->bt->omenu));
/*   gtk_widget_destroy(gmain->bt->smenu);*/
   gmain->bt->smenu = gtk_menu_new();
/*   g_list_foreach(GTK_MENU_SHELL(gmain->bt->smenu)->children,
		 remove_bt_server, NULL);*/
}

void remove_bt_server(void *data, void *ud) {
   if (data && GTK_IS_WIDGET(data))
     gtk_widget_destroy(data);
}
/*


int find_bt_server(const void *a, const void *b) {
   GtkWidget *m1, *lbl;
   char *s;
   STab *stab;
   
   d_assert_return(a != NULL, -1);
   d_assert_return(b != NULL, -1);
   
   m1 = (GtkWidget *)a;
   stab = (STab *)b;

   gtk_menu_shell_remove(GTK_MENU_SHELL(gmain->bt->smenu), m1);
   
   return -1;
   
   lbl = GTK_BIN(m1)->child;
   if (!lbl)
     return -1;
   
   gtk_label_get(GTK_LABEL(lbl), &s);
   
   return strcmp(s, stab->ci->server);
}*/

void set_bt_server(GtkWidget *w, STab *stab) {
   SET_DATA(gmain->bt->omenu, "stab", stab);
}

BrowseTab *create_browse_tab(GtkWidget *notebook) {
   int w;
   char *titles[] = { _("Filename"), _("Size"), _("Kbps"), NULL };
   BrowseTab *bt;
   
   w = j_config_get_int("/gnapster/Geometry/w");
   
   bt = d_new(BROWSE_TAB);
   
   bt->vbox = gtk_vbox_new(FALSE, 5);

   bt->hbox = j_line_new(bt->vbox, 0, 0);

   bt->label = gtk_label_new("Username: ");
   j_box_pack(bt->hbox, bt->label, 0, 0, 0);
   
   bt->entry = gtk_entry_new();
   gtk_signal_connect(GTK_OBJECT(bt->entry), "activate",
		      GTK_SIGNAL_FUNC(browse_user_cb), NULL);
   j_box_pack(bt->hbox, bt->entry, 0, 0, 0);
   
   bt->omenu = gtk_option_menu_new();
   bt->smenu = gtk_menu_new();
   j_box_pack(bt->hbox, bt->omenu, 0, 0, 0);
   
   bt->list_btn = gtk_button_new_with_label(_("Browse user"));
   gtk_signal_connect(GTK_OBJECT(bt->list_btn), "clicked",
		      GTK_SIGNAL_FUNC(browse_user_cb), NULL);
   j_box_pack(bt->hbox, bt->list_btn, 0, 0, 0);
   
   bt->clear_btn = gtk_button_new_with_label(_("Clear"));
   gtk_signal_connect(GTK_OBJECT(bt->clear_btn), "clicked",
		      GTK_SIGNAL_FUNC(browse_clear), NULL);
   j_box_pack(bt->hbox, bt->clear_btn, 0, 0, 0);

   bt->hbox = j_line_new(bt->vbox, 1, 1);

   bt->scroller = gtk_scrolled_window_new(NULL, NULL);
   gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(bt->scroller),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
   j_box_pack(bt->hbox, bt->scroller, 1, 1, 0);
   
   bt->ctree = gtk_ctree_new_with_titles(3, 0, titles);
   gtk_clist_set_column_width(GTK_CLIST(bt->ctree), 0, 450 + (w - DEFAULT_WIDTH));
   gtk_clist_set_column_width(GTK_CLIST(bt->ctree), 1, 90);
   gtk_clist_set_selection_mode(GTK_CLIST(bt->ctree),
				GTK_SELECTION_EXTENDED);
   gtk_clist_set_sort_column(GTK_CLIST(bt->ctree), 0);
   gtk_clist_set_auto_sort(GTK_CLIST(bt->ctree), 1);
   gtk_ctree_set_line_style(GTK_CTREE(bt->ctree), GTK_CTREE_LINES_DOTTED);
/*   GTK_CLIST(bt->ctree)->button_actions[2] = GTK_BUTTON_SELECTS;*/
   gtk_container_add(GTK_CONTAINER(bt->scroller), bt->ctree);
   gtk_signal_connect(GTK_OBJECT(bt->ctree), "button_press_event",
		      GTK_SIGNAL_FUNC(menu_popup_cb), browse_popup_menu);
   
   gtk_container_set_border_width(GTK_CONTAINER(bt->vbox), 5);
   
   gtk_notebook_append_page(GTK_NOTEBOOK(notebook),
			    bt->vbox, gtk_label_new(_("Browse")));
   
   return bt;
}


GList *browse_breakdown_path(Search *browse) {
   char *ptr, *file, *path, *orig = NULL;
   GList *elem = NULL;
   
   if (!browse || !browse->user || !browse->file)
     return NULL;
   
   file = browse->file;
   
   /* ok, the new browse method returns data with 1:\1\ style pathnames
    * that look like complete shit in the tree, we need to hack those out */
   if (isdigit(*file)) {
      int i;
      
      /* there is a blanant problem here w/ error checking...fix it later */
      for(i=0; file && i<2; file++, i++)
	file = strchr(file, '\\');
   }
   
   if (!file || !(*file))
     return NULL;
   
   d_msprintf(&path, "\\%s%s%s", browse->user,
	      *file == '\\' ? "" : "\\", file);
   
   while((ptr = next_arg_full(path, &path, '\\'))) {
      if (!orig) {
	 orig = ptr;
	 
	 /* anything before the first \ is useless. */
	 ptr = next_arg_full(path, &path, '\\');
      }
      
      elem = g_list_append(elem, d_strdup(ptr));
   }
   
   NA_RESET();
   
   d_free(orig);
   
   return elem;
}

void browse_tab_find(GtkCTreeNode **last, GtkCTreeNode *node, GList *ptr, int *l) {
   char *buf, *str;

   if (!node)
     node = GTK_CTREE_NODE(GTK_CLIST(gmain->bt->ctree)->row_list);
   
   while(node) {
      buf = GTK_CELL_PIXTEXT(GTK_CTREE_ROW(node)->row.cell[0])->text;
      
      str = g_list_nth_data(ptr, *l);
      if (!str)
	break;
      
      if (!j_strcmp(buf, str)) {
	 *last = node, (*l)++;
	 
	 if (GTK_CTREE_ROW(node)->children)
	   browse_tab_find(last, GTK_CTREE_ROW(node)->children, ptr, l);
	 
	 return;
      }
      
      node = GTK_CTREE_ROW(node)->sibling;
   }
}

void browse_tab_add(Search *browse) {
   GtkCTreeNode *node = NULL;
   GList *elem, *ptr;
   int i = 0, leaf = 0;
   char *text[3];
   
   elem = browse_breakdown_path(browse);
   browse_tab_find(&node, NULL, elem, &i);

   for(ptr=g_list_nth(elem, i); ptr; ptr=ptr->next) {
      leaf = (ptr->next) ? 0 : 1;
      
      memset(text, 0, sizeof(text));
      
      text[0] = ptr->data;
   
      if (leaf) {
	 int seconds;
	 
	 seconds = 
	   (browse->kbps) ? (browse->size / ((browse->kbps * 1000) / 8)) : 0;
	 
	 d_msprintf(&text[1], "%.02fM (%i:%02i)",
		    ((float)browse->size / 1024) / 1024,
		    seconds / 60, seconds % 60);
	 d_msprintf(&text[2], "%i", browse->kbps);
      }
      
      node = gtk_ctree_insert_node(GTK_CTREE(gmain->bt->ctree),
				   node, NULL, text, 0, NULL, NULL,
				   NULL, NULL, leaf, 0);
      if (leaf) {
	 char *pos;
	 
	 d_free(browse->user);
	 
	 if ((pos = strchr(browse->file, '\\')))
	   *pos = 0;
	 
	 /* on UNIX systems, the first char is a \, thus browse->file's
	  * first char will be 0. */
	 if (*(browse->file))
	   browse->file = d_realloc(browse->file, strlen(browse->file) + 1);
	 else /* d_free returns NULL always */
	   browse->file = d_free(browse->file);
	 
	 browse->user = browse->trunc_file = NULL;
	 
	 gtk_ctree_node_set_row_data_full(GTK_CTREE(gmain->bt->ctree),
					  node, browse,
					  (GtkDestroyNotify)gnapster_destroy);
	 d_free(text[1]);
	 d_free(text[2]);
      }
   }
   
   for(ptr=elem; ptr; ptr=ptr->next)
     d_free(ptr->data);
   
   g_list_free(elem);
   
   highlight(gmain->srv_notebook, gmain->bt->vbox);
}

