/* upload.c - uhh, upload/share stuff :) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sys/wait.h>
#include <sys/time.h>

#include "gnapster.h"

#include "upload.h"
#include "md5.h"

#ifndef MAP_FAILED
#define MAP_FAILED (void *) -1
#endif

extern UserInfo user_info;
extern BuildDlg build_dlg;
extern GnapsterMain *gmain;

extern int building;

STab *curr_stab = NULL;

void register_formats() {
   register_exts();
}

void shared_free(STab *stab) {
   GList *ptr;
   ShareData *shr;

   if (!stab->ut->shared)
     return;
   
   for(ptr=stab->ut->shared; ptr; ptr=ptr->next) {
      shr = ptr->data;
      if (!shr)
	continue;
      
      j_free(SHARE, shr);
   }
   
   g_list_free(stab->ut->shared);
   stab->ut->shared = NULL;
}

void share_addpath(GtkWidget *w, void *data) {
   PropDlg *pd;
   char *dir;
   
   d_assert(data != NULL);
   
   pd = data;
   
   dir = gtk_entry_get_text(GTK_ENTRY(j_file_entry_gtk_entry(pd->upload_dir)));
   if (!dir || !(*dir))
     return;
   
   if (!file_exists(dir)) {
      j_error_dialog(_("The directory path that you specified is not valid!"));
      return;
   }
   
   gnapster_clist_append(pd->share_paths, NULL, NULL, dir, NULL);
   
   gtk_entry_set_text(GTK_ENTRY(j_file_entry_gtk_entry(pd->upload_dir)), "");
   
   d_free(user_info.upload_dir);
   user_info.upload_dir = share_buildpathstr(pd->share_paths);
}

void share_rempath(GtkWidget *w, void *data) {
   PropDlg *pd;
   char *path;
   int row;
   
   d_assert(data != NULL);
   
   pd = data;
   
   path = gtk_entry_get_text(GTK_ENTRY(j_file_entry_gtk_entry(pd->upload_dir)));
   if (!path || !(*path))
     return;

   gnapster_get_selection_data(pd->share_paths, &row);

   gtk_clist_remove(GTK_CLIST(pd->share_paths), row);
   
   gtk_entry_set_text(GTK_ENTRY(j_file_entry_gtk_entry(pd->upload_dir)), "");
   
   d_free(user_info.upload_dir);
   user_info.upload_dir = share_buildpathstr(pd->share_paths);
}

void share_showpath(GtkWidget *w, int row, int col, GdkEvent *ev, void *data) {
   PropDlg *pd;
   char *path;
   
   d_assert(data != NULL);
   
   pd = data;
   
   gtk_clist_get_text(GTK_CLIST(w), row, 0, &path);
   
   gtk_entry_set_text(GTK_ENTRY(j_file_entry_gtk_entry(pd->upload_dir)), path);
}

char *share_buildpathstr(GtkWidget *clist) {
   int i, x;
   char *path, *out;
   
   x = g_list_length(GTK_CLIST(clist)->row_list);
   if (!x)
     return NULL;
   
   out = d_strdup("");
   
   for(i=0; i<x; i++) {
      gtk_clist_get_text(GTK_CLIST(clist), i, 0, &path);
      
      d_strexp(&out, "%s%s\4", out, path);
   }
   
   if (!(*out)) {
      d_free(out);
      return NULL;
   }
   
   if ((path = strrchr(out, '\4')))
     *path = 0;
   
   return out;
}

void fill_share_paths(GtkWidget *clist) {
   char *ul, *dup, *ptr;
   
   gtk_clist_clear(GTK_CLIST(clist));
   
   dup = d_strdup(user_info.upload_dir);
   ptr = dup;
   
   while((ul = next_arg_full(ptr, &ptr, '\4')))
     gnapster_clist_append(clist, NULL, NULL, ul, NULL);
   
   d_free(dup);
}

ShareData *get_share_data(int source, char **str) {
   ShareData *shr;
   unsigned short size;
   char *pbuf;
   int n;
   
   n = read(source, &size, 2);
   if (n <= 0)
     return NULL;

   /* indicates that the operation is finished */
   if (!size)
     return NULL;
   
   pbuf = d_malloc(size + 1);
   n = read(source, pbuf, size);
   if (n <= 0) {
      d_free(pbuf);
      return NULL;
   }
   
   pbuf[n] = 0;
   
   shr = d_new(SHARE);
   
   if (str)
     *str = d_strdup(pbuf);
   
   parse_shared_entry(pbuf, shr);
   
   d_free(pbuf);
   
   return shr;
}

void build_pipe_read(gpointer data, int source, GdkInputCondition condition) {
   ShareData *shr;
   FILE *f;
   char *str;
   
   d_assert(data != NULL);
   
   f = data;
   
   shr = get_share_data(source, &str);
   if (!shr) {
      build_dlg_cancel_cb();
      
      return;
   }
   
   fprintf(f, "%s\n", str);
   
   gtk_label_set_text(GTK_LABEL(build_dlg.label), strrchr(shr->filename, '/') + 1);

   d_free(str);
   j_free(SHARE, shr);
}

void pipe_finish(int fd) {
   unsigned short size;
   
   size = 0;
   write(fd, &size, 2);
}

void setup_build_dlg(STab *stab, char *root, int flags) {
   FILE *f;
   int pd[2], cpid;
   
   f = open_shared("w");
   if (!f)
     return;
   
   pipe(pd);
   
   cpid = fork();
   
   if (cpid == 0) {
      /* child */
      close(pd[0]); /* close read */
      
      recursive_parse_start(stab, pd[1], root);
      
      pipe_finish(pd[1]);
      
      close(pd[1]); /* close write */
      
      _exit(0); /* die */
   }
   
   build_dlg.cpid = cpid;
   
   create_build_dlg();
   
   build_dlg.pipe_input = INPUT_ADD(pd[0], GDK_INPUT_READ, 
				    build_pipe_read, f);
   
   j_dialog_run(build_dlg.window, 1);
   
   /* wait for child cleanup */
   wait(NULL);
   
   fclose(f);
}

void remove_slash(char *s) {
   char *ptr;
   
   if (!s)
     return;
   
   ptr = strrchr(s, '/');
   if (!ptr[1])
     *ptr = 0;
}

FILE *open_shared(char *flags) {
   FILE *f;
   char *conf;
   
   conf = local_path("shared", NULL);
   
   f = fopen(conf, flags);
   
   if (!f)
     j_error("fopen", conf, NULL);
   
   d_free(conf);
   
   return f;
}

int parse_shared_entry(char *s, ShareData *shr) {
   convert(next_arg(s, &s), "%li", &(shr->mtime));
   
   shr->filename = d_strdup(next_arg(s, &s));
   shr->checksum = d_strdup(next_arg(s, &s));
   
   convert(next_arg(s, &s), "%lu", &(shr->filesize));
   convert(next_arg(s, &s), "%hu", &(shr->bitrate));
   convert(next_arg(s, &s), "%hu", &(shr->frequency));
   
   convert(next_arg(s, &s), "%li", &(shr->time));
   
   NA_ERR_HANDLE(-1);
   
   return 1;
}

char *path_get_file(char *file) {
   char *s1, *s2;
   
   s1 = d_strdup(file);
   
   if ((s2 = strrchr(s1, '\\')))
     *s2++ = 0;
   
   s2 = d_strdup(s2);
   d_free(s1);
   
   return s2;
}

char *path_get_dir(char *file) {
   char *s1, *s2;
   
   s1 = d_strdup(file);
   
   if ((s2 = strrchr(s1, '\\')))
     *(++s2) = 0;
   
   return s1;
}

GList *share_find(STab *stab, char *dir) {
   GList *ptr, *child;
   char *d;
   
   for(ptr=stab->ut->shared; ptr; ptr=ptr->next) {
      child = ptr->data;
      if (!child)
	continue;

      d = child->data;
      if (!d)
	continue;
	 
      if (!strcmp(dir, d))
	return child;
   }
   
   return NULL;
}

void share_add(STab *stab, ShareData *shr) {
   if (!shr)
     return;
   
   DOSPATH(shr->filename);
   
   stab->ut->shared = g_list_prepend(stab->ut->shared, shr);

/*      
   flist = share_find(stab, dir);
   if (!flist)
     add = 1;
   
   if (add)
     flist = g_list_prepend(flist, d_strdup(dir));
   
   d_free(dir);
   
   flist = g_list_insert(flist, shr, 1);
   
   if (add)
     stab->ut->shared = g_list_prepend(stab->ut->shared, flist);
 */
}

void share_remove(STab *stab, ShareData *shr) {
   GList *flist;
   char *dir;
   
   if (!shr)
     return;
   
   dir = path_get_dir(shr->filename);
   
   flist = share_find(stab, dir);
   
   d_free(dir);
   
   if (!flist)
     return;
   
   flist = g_list_remove(flist, shr);
}

/* return a structure if local mtime <= written mtime */
ShareData *find_share_mtime(STab *stab, char *path) {
   GList *ptr;
   ShareData *shr;
   struct stat st;
   
/*   dir = path_get_dir(path);
   
   flist = share_find(stab, dir);
   
   d_free(dir);

   if (!flist)
     return NULL;*/
   
   if (stat(path, &st) < 0)
     return NULL;  

   for(ptr=stab->ut->shared; ptr; ptr=ptr->next) {
      shr = ptr->data;
      if (!shr)
	continue;
      
      if (strcmp(shr->filename, path))
	continue;
      
      if (st.st_mtime <= shr->mtime)
	return shr;
   }

   return NULL;
}

void share_submit(STab *stab) {
   char *buf;
   ConnInfo *ci;
   
   ci = stab->ci;
   
   d_msprintf(&buf, "Sharing %i (%.02f gigabytes)", ci->sharing,
	      ((float)ci->share_size / 1024.0) / 1024.0);
   
   gtk_label_set_text(GTK_LABEL(gmain->ut->label), buf);
   
   d_free(buf);
      
   hook_text_insert(stab, CONSOLE, SYSTEM, "general_message", "%s",
		    "submitting mp3 list");
   
   ci->upload_input = INPUT_ADD(ci->sock, GDK_INPUT_WRITE,
				handle_submit, stab);
}

void build_shares(STab *stab) {
   ShareData *shr;
   FILE *f;
   char buf[4096];
   
   f = open_shared("r");
   if (!f)
     return;
   
   shared_free(stab);

   while(fgets(buf, sizeof(buf) - 1, f)) {
      shr = d_new(SHARE);
      
      if (parse_shared_entry(buf, shr) < 0) {
	 d_free(shr);
	 continue;
      }
      
      share_add(stab, shr);
      
      stab->ci->sharing++;
      stab->ci->share_size += shr->filesize / 1024.0;
   }
   
   fclose(f);
}

int share_cmp(FileEntry *fe1, FileEntry *fe2) {
   char *s1, *s2, *p1, *p2, *f1, *f2;
   int ret;
   
   s1 = d_strdup(fe1->lptr);
   s2 = d_strdup(fe2->lptr);
   p1 = s1;
   p2 = s2;

   next_arg(s1, &s1);
   f1 = next_arg(s1, &s1);
   
   next_arg(s2, &s2);
   f2 = next_arg(s2, &s2);
   
   ret = j_strcmp(f1, f2);
   
   d_free(p1);
   d_free(p2);
   
   return ret;
}

void sort_shares(STab *stab) {
   FILE *f;
   GList *felem, *ptr;
   FileEntry *fent;
   
   f = open_shared("r");
   if (!f)
     return;
   
   felem = read_file(f);
   
   fclose(f);
   
   felem = g_list_sort(felem, (GCompareFunc)share_cmp);
   
   f = open_shared("w");
   if (!f) {
      read_file_free(felem);
      return;
   }
  
   for(ptr=felem; ptr; ptr=ptr->next) {
      fent = ptr->data;
      if (!fent)
	continue;
      
      fprintf(f, "%s", fent->lptr);
   }
   
   fclose(f);
   
   read_file_free(felem);
}

int sanitize_path(char **s) {
   char *ul, *dup, *ptr, *out;
   int ret;
   
   dup = d_strdup(*s);
   ptr = dup;
   
   ret = 0;
   
   out = d_strdup("");
   
   while((ul = next_arg_full(ptr, &ptr, '\4'))) {
      if (!(*ul))
	break;
      
      if (!file_exists(ul))
	ret = 1;
      
      remove_slash(ul);
      
      d_strexp(&out, "%s%s\4", out, ul);
   }
   
   d_free(dup);
   
   d_free(user_info.upload_dir);
   user_info.upload_dir = out;
   *s = out;
   
   return ret;
}

int shared_list_handle(STab *stab, char *root, int flags) {
   ConnInfo *ci;
   
   ci = stab->ci;
   
   if (stab->ci->upload_input > 0)
     return 0;
   
   /* obviously we cannot submit the list if we aren't connected */
   if (flags & SUBMIT_LIST &&
       !connected(ci) && !connecting(ci))
     return 0;
   
   if (flags & SUBMIT_LIST && user_info.conf[DISABLE_UL])
     return 0;
   
   /* root is actually a path that must be broken down ... */
   if (sanitize_path(&root))
     return 0;
   
   if (flags & SUBMIT_LIST)
     ci->state |= SHARING_MASK;
   
   if (!(flags & UPDATE_LIST))
     ci->sharing = ci->share_size = 0;
   
/*   sort_shares(stab); */
   
   build_shares(stab);
   
   if (flags & BUILD_LIST)
     setup_build_dlg(stab, root, flags);
   
   if (flags & SUBMIT_LIST)
     share_submit(stab);
   else
     shared_free(stab);

   return 1;
}
