/* Native support for HPPA-RISC machine running HPUX 11.x, for GDB.
   Copyright 1998 Free Software Foundation, Inc. 

   This file is part of GDB.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#define GDB_NATIVE_HPUX_11

#define FROM_SAME_FORK(pid1,pid2) hppa11_from_same_fork (pid1, pid2)
extern int hppa11_from_same_fork (int, int);

#define U_REGS_OFFSET 0
#define KERNEL_U_ADDR 0

/* What a coincidence! */
#define REGISTER_U_ADDR(addr, blockend, regno)				\
{ addr = (int)(blockend) + DEPRECATED_REGISTER_BYTE (regno);}

#define CHILD_XFER_MEMORY

/* Provided by infptrace.c or infttrace.c.  */
#define CHILD_PID_TO_EXEC_FILE
#define CHILD_POST_STARTUP_INFERIOR
#define CHILD_ACKNOWLEDGE_CREATED_INFERIOR
#define CHILD_THREAD_ALIVE

/* Provided by ia64-hpux-nat.c.  */
#define CHILD_WAIT
struct target_waitstatus;
extern ptid_t child_wait (ptid_t ptid, struct target_waitstatus *ourstatus);

#define IN_SYSCALL ia64_hpux_in_syscall ()
extern int ia64_hpux_in_syscall (void);

#define THREAD_PTID_CONTAINS_LWP_NULL_NULL (1)
