/****************************************************************************/
/*                                                                          */
/*                         GNAT COMPILER COMPONENTS                         */
/*                                                                          */
/*                             A - G T R A N 3                              */
/*                                                                          */
/*                              C Header File                               */
/*                                                                          */
/*                            $Revision: 1.43 $
/*                                                                          */
/*          Copyright (C) 1992-2001 Free Software Foundation, Inc.          */
/*                                                                          */
/* GNAT is free software;  you can  redistribute it  and/or modify it under */
/* terms of the  GNU General Public License as published  by the Free Soft- */
/* ware  Foundation;  either version 2,  or (at your option) any later ver- */
/* sion.  GNAT is distributed in the hope that it will be useful, but WITH- */
/* OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY */
/* or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License */
/* for  more details.  You should have  received  a copy of the GNU General */
/* Public License  distributed with GNAT;  see file COPYING.  If not, write */
/* to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, */
/* MA 02111-1307, USA.                                                      */
/*                                                                          */
/* GNAT was originally developed  by the GNAT team at  New York University. */
/* It is now maintained by Ada Core Technologies Inc (http://www.gnat.com). */
/*                                                                          */
/****************************************************************************/

/*  Definitions to access front-end functions used in gigi */
#define In_Extended_Main_Code_Unit lib__in_extended_main_code_unit
extern Boolean In_Extended_Main_Code_Unit PROTO((Entity_Id));
#define Get_Encoded_Name exp_dbug__get_encoded_name
extern void Get_Encoded_Name PROTO((Entity_Id));
#define Get_External_Name_With_Suffix exp_dbug__get_external_name_with_suffix
/*  Don't give prototype here for now, as this requires more general 
    typedefs and macros for fat pointers */
#define Defining_Entity		 sem_util__defining_entity
extern Entity_Id Defining_Entity PROTO((Node_Id));
#define Requires_Transient_Scope sem_util__requires_transient_scope
extern Boolean Requires_Transient_Scope PROTO((Entity_Id));
#define Expr_Value		 sem_eval__expr_value
extern Uint Expr_Value		 PROTO((Node_Id));
#define Expr_Value_S		 sem_eval__expr_value_s
extern Node_Id Expr_Value_S	 PROTO((Node_Id));
#define Get_Attribute_Definition_Clause \
sem_ch13__get_attribute_definition_clause
extern Node_Id Get_Attribute_Definition_Clause PROTO((Entity_Id, char));


/* Given GNAT_ENTITY, a GNAT defining identifier node, which denotes some Ada
   entity, this routine returns the equivalent GCC tree for that entity
   (an ..._DECL node) and associates the ..._DECL node with the input GNAT
   defining identifier.

   If GNAT_ENTITY is a variable or a constant declaration, GNU_EXPR gives its
   initial value (in GCC tree form). This is optional for variables.
   For renamed entities, GNU_EXPR gives the object being renamed.

   DEFINITION is nonzero if this call is intended for a definition.  This is
   used for separate compilation where it necessary to know whether an
   external declaration or a definition should be created if the GCC equivalent
   was not created previously.  The value of 1 is normally used for a non-zero
   DEFINITION, but a value of 2 is used in special circumstances, defined in
   the code.  */
extern tree gnat_to_gnu_entity	PROTO((Entity_Id, tree, int));

/* Given GNAT_ENTITY, an entity in the incoming GNAT tree, return a
   GCC type corresponding to that entity.  GNAT_ENTITY is assumed to
   refer to an Ada type.  */
extern tree gnat_to_gnu_type	PROTO((Entity_Id));

/* Given GNAT_ENTITY, elaborate all expressions that are required to
   be elaborated at the point of its definition, but do nothing else.  */
extern void elaborate_entity	PROTO((Entity_Id));

/* Make a dummy type corresponding to GNAT_TYPE.  */
extern tree make_dummy_type	PROTO((Entity_Id));

/* Get the unpadded version of a GNAT type.  */
extern tree get_unpadded_type	PROTO((Entity_Id));

/* Called when we need to protect a variable object using a save_expr.  */
extern tree maybe_variable	PROTO((tree, Node_Id));

/* Create a record type that contains a field of TYPE with a starting bit
   position so that it is aligned to ALIGN bits.  */
/* Create a record type that contains a field of TYPE with a starting bit
   position so that it is aligned to ALIGN bits and is SIZE bytes long.  */
extern tree make_aligning_type	PROTO((tree, int, tree));

/* Given a GNU tree and a GNAT list of choices, generate an expression to test
   the value passed against the list of choices.  */
extern tree choices_to_gnu	PROTO((tree, Node_Id));

/* Given a type T, a FIELD_DECL F, and a replacement value R,
   return a new type with all size expressions that contain F
   updated by replacing F with R.  This is identical to GCC's
   substitute_in_type except that it knows about TYPE_INDEX_TYPE.  */
extern tree gnat_substitute_in_type PROTO((tree, tree, tree));

/* Return the "RM size" of GNU_TYPE.  This is the actual number of bits
   needed to represent the object.  */
extern tree rm_size		PROTO((tree));

/* Given GNU_ID, an IDENTIFIER_NODE containing a name and SUFFIX, a
   string, return a new IDENTIFIER_NODE that is the concatenation of
   the name in GNU_ID and SUFFIX.  */
extern tree concat_id_with_name PROTO((tree, char *));

/* Return the name to be used for GNAT_ENTITY.  If a type, create a 
   fully-qualified name, possibly with type information encoding.
   Otherwise, return the name.  */
extern tree get_entity_name PROTO((Entity_Id));

/* Return a name for GNAT_ENTITY concatenated with two underscores and
   SUFFIX.  */
extern tree create_concat_name PROTO((Entity_Id, char *));
