------------------------------------------------------------------------------
--                                                                          --
--                      GNAT COMPATIBILITY COMPONENTS                       --
--                                                                          --
--                    C U R R E N T _ E X C E P T I O N                     --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.2 $                              --
--                                                                          --
--         Copyright (C) 1996,1998 Free Software Foundation, Inc.           --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- It is now maintained by Ada Core Technologies Inc (http://www.gnat.com). --
--                                                                          --
------------------------------------------------------------------------------

--  This package is intended to duplicate the interface provided by the
--  OpenVMS package Current_Exception, as described in the DEC Ada manuals.

package Current_Exception is
   pragma Pure (Current_Exception);

   function Exception_Information return String;
   --  Returns the result of calling Ada.Exceptions.Exception_Information
   --  with an argument that is the Exception_Occurrence corresponding to
   --  the current exception. Returns the null string if called from outside
   --  an exception handler.

   function Exception_Message return String;
   --  Returns the result of calling Ada.Exceptions.Exception_Message with
   --  an argument that is the Exception_Occurrence corresponding to the
   --  current exception. Returns the null string if called from outside an
   --  exception handler.

   function Exception_Name return String;
   --  Returns the result of calling Ada.Exceptions.Exception_Name with
   --  an argument that is the Exception_Occurrence corresponding to the
   --  current exception. Returns the null string if called from outside an
   --  exception handler.

private
   pragma Import (Intrinsic, Exception_Information);
   pragma Import (intrinsic, Exception_Message);
   pragma Import (Intrinsic, Exception_Name);

end Current_Exception;
