/* 
 * Copyright (C) 1999 JP Rosevear
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef POSITION_H
#define POSITION_H

#include <glib.h>

typedef struct {
	gshort tomove;	/* Color to move */
	gshort wta;	/* Flag if the white 'a' rook has moved */
	gshort wth;	/* Flag if the white 'h' rook has moved */
	gshort wki;	/* Flag if the white king has moved */
	gshort sta;	/* Flag if the black 'a' rook has moved */
	gshort sth;	/* Flag if the black 'h' rook has moved */
	gshort ski;	/* Flag if the black king has moved */
	gshort ep;	/* En passent */
	gshort vf;	/* Last piece captured */

	gchar     square[120]; /* A 10x10 board - extra is for move generation */
} position;
    
extern position *currPositionPtr; 

position* gnomechess_position_new(void);
position* gnomechess_position_new_initial(void);
position* gnomechess_position_copy(position *pos );
void gnomechess_position_set_initial(position *pos);
void gnomechess_position_move(position *pos, int from, int to);
void gnomechess_position_move_reverse_white(position *pos, int from, int to);
void gnomechess_position_move_reverse_black(position *pos, int from, int to);
void gnomechess_position_move_reverse(position *pos, int from, int to);
void gnomechess_position_destroy(position **pos);

#endif /* POSITION_H */
