/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2002 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#include "gnome-cmd-includes.h"

//#define DEBUG_POOL

static GList *entries = NULL;


GnomeCmdDir *
dir_pool_get (const gchar *dir_uri_str)
{
	GList *tmp = entries;

	g_return_val_if_fail (dir_uri_str != NULL, NULL);

	while (tmp) {
		GnomeCmdDir *dir = (GnomeCmdDir*)tmp->data;
		if (strcmp (gnome_cmd_dir_get_uri_str (dir), dir_uri_str) == 0) {			
#ifdef DEBUG_POOL
			debug_print ("found %s 0x%x in the pool\n", dir->path, dir);
#endif
			return dir;
		}
		tmp = tmp->next;
	}

	return gnome_cmd_dir_new_from_uri_str (dir_uri_str);
}


void
dir_pool_add (GnomeCmdDir *dir)
{
	g_return_if_fail (dir != NULL);
	
#ifdef DEBUG_POOL
	debug_print ("adding %s 0x%x to the pool\n", dir->path, dir);
#endif
	entries = g_list_append (entries, dir);
}


void
dir_pool_remove (GnomeCmdDir *dir)
{
	g_return_if_fail (dir != NULL);
	
#ifdef DEBUG_POOL
	debug_print ("removing %s 0x%x from the pool\n", dir->path, dir);
#endif
	entries = g_list_remove (entries, dir);
}


gboolean
dir_pool_exists (GnomeCmdDir *dir)
{
	return (g_list_index (entries, dir) != -1);
}
