/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2002 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#include <config.h>
#include "gnome-cmd-includes.h"

typedef struct
{
	GList               *files;
} DeleteData;


static gint
progress_callback (GnomeVFSXferProgressInfo *info, gpointer user_data)
{
	if (info->status != GNOME_VFS_XFER_PROGRESS_STATUS_OK)
	{
		if (info->vfs_status != GNOME_VFS_OK)
			gnome_error_dialog (
				gnome_vfs_result_to_string (info->vfs_status));
	}
	
	return 1;
}


static void
reply_callback (gint reply, DeleteData *data)
{
	GnomeVFSXferOptions xferOptions = 0;
	GnomeVFSXferErrorMode xferErrorMode = 0;
	GList *uri_list = NULL;
	GnomeVFSResult result;
	int i;

	/* skip if cancel was pressed */
	if (reply == 1) {
		gnome_cmd_file_list_free (data->files);
		return;
	}

	for ( i=0 ; i<g_list_length (data->files) ; i++ )
	{
		GnomeVFSURI *uri;		
		GnomeCmdFile *finfo = (GnomeCmdFile*)g_list_nth_data (data->files, i);

		if (g_strcasecmp(finfo->info->name, "..") == 0
			|| g_strcasecmp(finfo->info->name, ".") == 0) continue;
		
		uri = gnome_cmd_file_get_uri (finfo);

		uri_list = g_list_append (uri_list, uri);
	}

	if (uri_list != NULL)
	{
		result = gnome_vfs_xfer_delete_list (
			uri_list,
			xferErrorMode,
			xferOptions,
			(GnomeVFSXferProgressCallback)progress_callback,
			NULL);

		if (result != GNOME_VFS_OK)
			gnome_error_dialog (gnome_vfs_result_to_string (result));		
	}
	
	gnome_cmd_file_list_free (data->files);
	g_list_free (uri_list);
	g_free (data);
}


void
gnome_cmd_delete_dialog_show (GList *files)
{
	GtkWidget *dialog;
	DeleteData *data = g_new (DeleteData, 1);
	GnomeCmdFile *finfo;
	gint num_files;
	gchar *msg;

	data->files = gnome_cmd_file_list_copy (files);
	num_files = g_list_length (data->files);

	gnome_cmd_file_selector_unselect_all (
		gnome_cmd_main_win_get_active_fs (main_win));
	
	if (num_files == 1)
	{
		const gchar *what;
		finfo = (GnomeCmdFile*)g_list_nth_data (data->files, 0);
		if (g_strcasecmp(finfo->info->name, "..") == 0)
		{
			g_free (data);
			return;
		}
		what = gnome_cmd_file_get_type_desc (finfo);
		msg = g_strdup_printf (_("Do you want to delete the %s \"%s\" ?"),
							   what, finfo->info->name);
	}
	else
		msg = g_strdup_printf (_("Do you want to delete the  %d selected files ?"),
							   num_files);
	
	dialog = gnome_question_dialog (msg, (GnomeReplyCallback)reply_callback, data);
	gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER);
	gtk_widget_show (dialog);

	g_free  (msg);
}


