/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* chaninfo-dialog.cpp
 *
 * Copyright (C) 2006 Takuo KITAME.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 *
 * Author: Takuo KITAME.
 *
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "gnome-peercast.h"
#include "logview.h"

static gboolean
scroll_idle_cb (gpointer data)
{
        GtkTextView *tv = GTK_TEXT_VIEW (data);
	GtkTextIter iter;
	GtkTextBuffer *buffer = gtk_text_view_get_buffer (tv);

	gtk_text_buffer_get_end_iter (buffer, &iter);
	gtk_text_view_scroll_to_iter (tv, &iter, 0, FALSE, 0, 0);	

        return FALSE;
}

LogView::LogView (GtkWidget *w)
{
	GtkTextBuffer *buffer;

        debug_print (1, "New object: LogView");
	textview = GTK_TEXT_VIEW (w);
        scroll_src = 0;
	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (textview));
	gtk_text_buffer_create_tag (buffer, "bold",
				    "weight", PANGO_WEIGHT_BOLD, NULL);
}

void
LogView::scrollToEnd (void)
{
        if (scroll_src)
                g_source_remove (scroll_src);
        scroll_src = g_idle_add_full (GDK_PRIORITY_REDRAW + 15, scroll_idle_cb,
				      textview, NULL);
	gtk_widget_show (GTK_WIDGET (textview));
}


void
LogView::appendLog (LogBuffer::TYPE type, const gchar *str)
{
	struct tm * lt;
	time_t t;
	gchar timestr[40];
	static unsigned int line = 0;
	GnomePeercastApp *app = (GnomePeercastApp *)peercastApp;
	GtkWidget *w;
	GtkTextBuffer *buffer;
	GtkTextIter iter;

	line++;
	
	t = sys->getTime();
	lt = localtime ((const time_t *)&t);
	strftime (timestr, sizeof(timestr), "%m/%d %H:%M:%S", lt);

	buffer = gtk_text_view_get_buffer (textview);
	gtk_text_buffer_get_end_iter (buffer, &iter);
	gtk_text_buffer_insert (buffer, &iter, timestr, -1);
	gtk_text_buffer_insert (buffer, &iter, " [", -1);
	gtk_text_buffer_insert_with_tags_by_name (buffer, &iter,
						  LogBuffer::getTypeStr(type),
						  -1,
						  "bold", NULL);
	gtk_text_buffer_insert (buffer, &iter, "] ", -1);
	gtk_text_buffer_insert (buffer, &iter, str, -1);
	gtk_text_buffer_insert (buffer, &iter, "\n", -1);

	w = app->getWidget ("log_scroll");
	
	if (gtk_toggle_tool_button_get_active (GTK_TOGGLE_TOOL_BUTTON (w))) {
		gtk_text_view_scroll_to_iter (textview, &iter, 0, FALSE, 0, 0);
	}
}

void
LogView::appendLog_s (gpointer data)
{
	LogString *ls = (LogString *)data;
	struct tm * lt;
	time_t t;
	gchar timestr[40];
	static unsigned int line = 0;
	GnomePeercastApp *app = (GnomePeercastApp *)peercastApp;
	GtkWidget *w;
	GtkTextBuffer *buffer;
	GtkTextIter iter;
	GtkTextView *tv = (GtkTextView *)app->getWidget("text_log");

	gdk_threads_enter();
	
	line++;
	
	t = sys->getTime();
	lt = localtime ((const time_t *)&t);
	strftime (timestr, sizeof(timestr), "%m/%d %H:%M:%S", lt);

	buffer = gtk_text_view_get_buffer (tv);
	gtk_text_buffer_get_end_iter (buffer, &iter);
	gtk_text_buffer_insert (buffer, &iter, timestr, -1);
	gtk_text_buffer_insert (buffer, &iter, " [", -1);
	gtk_text_buffer_insert_with_tags_by_name (buffer, &iter,
						  LogBuffer::getTypeStr(ls->type),
						  -1,
						  "bold", NULL);
	gtk_text_buffer_insert (buffer, &iter, "] ", -1);
	gtk_text_buffer_insert (buffer, &iter, ls->data, -1);
	gtk_text_buffer_insert (buffer, &iter, "\n", -1);

	delete ls;
	
	w = app->getWidget ("log_scroll");
	
	if (gtk_toggle_tool_button_get_active (GTK_TOGGLE_TOOL_BUTTON (w))) {
		gtk_text_buffer_get_end_iter (buffer, &iter);
		gtk_text_view_scroll_to_iter (tv, &iter, 0, FALSE, 0, 0);
	}
	gdk_threads_leave();
}

void
LogView::clearLog (void)
{
	GtkTextBuffer *buffer;

	buffer = gtk_text_view_get_buffer (textview);
	gtk_text_buffer_set_text (buffer, "", -1);
}

LogString::LogString(LogBuffer::TYPE t, const char *str)
{
	data = g_strdup(str);
	type = t;
}
