/* gnome-rdp
 * Copyright (C) 2005-2006 Balazs Varkonyi
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using Gtk;
using Gdk;
using System;
using System.Data;
using Mono.Data.SqliteClient;
using Mono.Unix;
using System.Collections;
using System.IO;

namespace GnomeRDP
{
	public class Configuration
	{
		private IDataReader result;
		private Sqlite db;
		private string HOME = Environment.GetEnvironmentVariable("HOME");

		private string		_sessionName;
		private int		_protocol;
		private string		_computer;
		private string		_user;
		private string		_password;
		private string		_domain;
		private int		_srvType;
		private int		_colorDepth;
		private int		_screenResolutionX;
		private int		_screenResolutionY;
		private int 		_soundRedirection;
		private string		_keyboardLang;
		private int		_connectionType;
		private int		_windowMode;
		private int		_terminalSize;
		private int		_compressionLevel;
		private int		_imageQuality;
		private int		_id;
		private int		_parentId;
		private bool		_isCategory;
	
		public string SessionName
		{
			get {return _sessionName;}
			set {_sessionName = value;}
		}
		public int Protocol
		{
			get {return _protocol;}
			set {_protocol = value;}
		}
		public string Computer
		{
			get {return _computer;}
			set {_computer = value;}
		}
		public string User
		{
			get {return _user;}
			set {_user = value;}
		}
		public string Password
		{
			get {return _password;}
			set {_password = value;}
		}
		public string Domain
		{
			get {return _domain;}
			set {_domain = value;}
		}
		public int SrvType
		{
			get {return _srvType;}
			set {_srvType = value;}
		}
		public int ColorDepth
		{
			get {return _colorDepth;}
			set {_colorDepth = value;}
		}
		public int ScreenResolutionX
		{
			get {return _screenResolutionX;}
			set {_screenResolutionX = value;}
		}
		public int ScreenResolutionY
		{
			get {return _screenResolutionY;}
			set {_screenResolutionY = value;}
		}		
		public int SoundRedirection
		{
			get {return _soundRedirection;}
			set {_soundRedirection = value;}
		}
		public string KeyboardLang
		{
			get {return _keyboardLang;}
			set {_keyboardLang = value;}
		}
		public int ConnectionType
		{
			get {return _connectionType;}
			set {_connectionType = value;}
		}
		public int WindowMode
		{
			get {return _windowMode;}
			set {_windowMode = value;}
		}
		public int TerminalSize
		{
			get {return _terminalSize;}
			set {_terminalSize = value;}
		}
		public int CompressionLevel
		{
			get {return _compressionLevel;}
			set {_compressionLevel = value;}
		}
		public int ImageQuality
		{
			get {return _imageQuality;}
			set {_imageQuality = value;}
		}
		public int Id
		{
			get {return _id;}
		}		
		public int ParentId
		{
			get {return _parentId;}
			set {_parentId = value;}
		}		
		public bool IsCategory
		{
			get {return _isCategory;}
			set {_isCategory = value;}
		}		

		public Configuration()
		{
			this._colorDepth = 0;
			this._compressionLevel = 0;
			this._computer = "";
			this._connectionType = 0;
			this._domain = "";
			this._imageQuality = 0;
			this._isCategory = false;
			this._parentId = 0;
			this._password = "";
			this._protocol = 0;
			this._screenResolutionX = 640;
			this._screenResolutionY = 480;
			this._sessionName = "";
			this._soundRedirection = 0;
			this._srvType = 0;
			this._terminalSize = 0;
			this._user = "";
			this._windowMode = 0;
			this._keyboardLang = "en-us";
		}
		
		public void CreateDatabase()
		{
			db = new Sqlite(null);
			db.Connect(HOME + "/.gnome-rdp.db");
			db.Query("CREATE TABLE version (" +
				"id INTEGER PRIMARY KEY, " +
				"dbversion VARCHAR(10))");
			db.FreeResult();
			db.Query("INSERT INTO version (id, dbversion) " +
				"VALUES (1, '" + Defines.REQUIRED_DBVERSION + "')");
			db.FreeResult();
			db.Query("CREATE TABLE session (" +
				"id INTEGER PRIMARY KEY, " +
				"parentid INTEGER, " +
				"iscategory BOOL, " +
				"sessionname VARCHAR(30), " +
				"protocol INTEGER, " +
				"computer VARCHAR(30), " +
				"user VARCHAR(30), " +
				"password VARCHAR(30), " +
				"domain VARCHAR(30), " +
				"srvtype INTEGER, " +
				"colordepth INTEGER, " +
				"screenresolutionx INTEGER, " +
				"screenresolutiony INTEGER, " +
				"soundredirection INTEGER, " +
				"keyboardlang VARCHAR(10), " +
				"connectiontype INTEGER, " +
				"windowmode INTEGER, " +
				"terminalsize INTEGER, " +
				"compressionlevel INTEGER, " +
				"imagequality INTEGER)");
			db.Close();		
		}
		
		public bool CheckDatabaseVersion()
		{
			bool retval = false;
			string version = "";
			db = new Sqlite(null);
			db.Connect(HOME + "/.gnome-rdp.db");
			db.Query("SELECT * FROM version WHERE id = 1");
			if (db.FetchRow(out result))
			{
				version = result["dbversion"].ToString();
			}
			db.Close();
			if (version == Defines.REQUIRED_DBVERSION)
			{
				return true;
			}
			else
			{
				switch (version)
				{
					case "0.2.0":
						retval=ConvertFrom0_2_0();
						break;
				}
				return retval;
			}
		}
		
		public bool ConvertFrom0_2_0()
		{
			IDataReader result;
			Sqlite db;
			string tmpFileName = System.IO.Path.GetTempFileName();
			
			try
			{
				Console.Write(Catalog.GetString("Upgrading database to ") + Defines.REQUIRED_DBVERSION + "... ");
				System.IO.File.Delete(tmpFileName);
				System.IO.File.Move(HOME + "/.gnome-rdp.db", tmpFileName);
				this.CreateDatabase();
				db = new Sqlite(null);
				db.Connect(tmpFileName);
				db.Query("SELECT * FROM session");
				while (db.FetchRow(out result))
				{
					Configuration cfg = new Configuration();
					cfg._id = Convert.ToInt32(result["id"].ToString());
					cfg._parentId = Convert.ToInt32(result["parentid"].ToString());
					cfg._isCategory = Convert.ToBoolean(Convert.ToInt32(result["iscategory"]));
					cfg._colorDepth = Convert.ToInt32(result["colordepth"].ToString());
					cfg._compressionLevel = Convert.ToInt32(result["compressionlevel"].ToString());
					cfg._computer = result["computer"].ToString();
					cfg._connectionType = Convert.ToInt32(result["connectiontype"].ToString());
					cfg._domain = result["domain"].ToString();
					cfg._imageQuality = Convert.ToInt32(result["imagequality"].ToString());
					cfg._keyboardLang = result["keyboardlang"].ToString();
					cfg._password = result["password"].ToString();
					cfg._protocol = Convert.ToInt32(result["protocol"].ToString());
					switch (Convert.ToInt32(result["screenresolution"].ToString()))
					{
						case 0:
							cfg._screenResolutionX = 640;
							cfg._screenResolutionY = 480;
							break;
						case 1:
							cfg._screenResolutionX = 800;
							cfg._screenResolutionY = 600;
							break;
						case 2:
							cfg._screenResolutionX = 0;
							cfg._screenResolutionY = 0;
							break;
					}
					cfg._sessionName = result["sessionname"].ToString();
					cfg._soundRedirection = Convert.ToInt32(result["soundredirection"].ToString());
					cfg._srvType = Convert.ToInt32(result["srvtype"].ToString());
					cfg._terminalSize = Convert.ToInt32(result["terminalsize"].ToString());
					cfg._user = result["user"].ToString();
					cfg._windowMode = Convert.ToInt32(result["windowmode"].ToString());
					cfg.SaveSession((cfg.Password.Length>0?true:false),true);
				}	
				db.Close();
			}
			catch
			{
				Console.WriteLine(Catalog.GetString("Failed to convert database..."));
				return false;
			}
			Console.WriteLine(Catalog.GetString("Successful"));
			return true;
		}
		
		public void DeleteSession()
		{
			if (!this.IsCategory)
			{
				db = new Sqlite(null);
				db.Connect(HOME + "/.gnome-rdp.db");
				db.Query("DELETE FROM session WHERE id = " + this._id);
				db.Close();
			}
			else
			{
				db = new Sqlite(null);
				db.Connect(HOME + "/.gnome-rdp.db");
				this.DeleteCategoryTreeRecursive(this._id);
				db.Query("DELETE FROM session WHERE id = " + this._id);
				db.Close();
			}
					
		}
		
		private void DeleteCategoryTreeRecursive(int parentId)
		{
			ArrayList cfgList;
			Configuration cf = new Configuration();
			cfgList = cf.LoadSessions();
			
			foreach (Configuration cfg in cfgList)
			{
				if (cfg.ParentId == parentId)
				{
					if (cfg.IsCategory)
					{
						this.DeleteCategoryTreeRecursive(cfg.Id);
					}
					db.Query("DELETE FROM session WHERE id = " + cfg.Id);
				}
			}	
		}
		
		public void UpdateSession(bool IsSavePasswd)
		{
			db = new Sqlite(null);
			db.Connect(HOME + "/.gnome-rdp.db");
			if (IsSavePasswd)
			{
				db.Query("UPDATE session SET " +
					"parentid = " + this._parentId + ", " +
					"iscategory = " + Convert.ToInt32(this._isCategory) + ", " +
					"sessionname = '" + this._sessionName + "', " +
					"protocol = " + this._protocol + ", " +
					"computer = '" + this._computer + "', " +
					"user = '" + this._user + "', " +
					"password = '" + this._password + "', " +
					"domain = '" + this._domain + "', " +
					"srvtype = " + this._srvType + ", " +
					"colordepth = " + this._colorDepth + ", " +
					"screenresolutionx = " + this._screenResolutionX + ", " +
					"screenresolutiony = " + this._screenResolutionY + ", " +
					"soundredirection = " + this._soundRedirection + ", " +
					"keyboardlang = '" + this._keyboardLang + "', " +
					"connectiontype = " + this._connectionType + ", " +
					"windowmode = " + this._windowMode + ", " +
					"terminalsize = " + this._terminalSize + ", " +
					"compressionlevel = " + this._compressionLevel + ", " +
					"imagequality = " + this._imageQuality + " " +
					"WHERE id = " + this._id);
			}
			else
			{
				db.Query("UPDATE session SET " +
					"parentid = " + this._parentId + ", " +
					"iscategory = " + Convert.ToInt32(this._isCategory) + ", " +
					"sessionname = '" + this._sessionName + "', " +
					"protocol = " + this._protocol + ", " +
					"computer = '" + this._computer + "', " +
					"user = '" + this._user + "', " +
					"password = '', " +
					"domain = '" + this._domain + "', " +
					"srvtype = " + this._srvType + ", " +
					"colordepth = " + this._colorDepth + ", " +
					"screenresolutionx = " + this._screenResolutionX + ", " +
					"screenresolutiony = " + this._screenResolutionY + ", " +
					"soundredirection = " + this._soundRedirection + ", " +
					"keyboardlang = '" + this._keyboardLang + "', " +
					"connectiontype = " + this._connectionType + ", " +
					"windowmode = " + this._windowMode + ", " +
					"terminalsize = " + this._terminalSize + ", " +
					"compressionlevel = " + this._compressionLevel + ", " +
					"imagequality = " + this._imageQuality + " " +
					"WHERE id = " + this._id);
			}
			db.Close();	
		}
		
		public void SaveSession(bool IsSavePasswd, bool WithId)
		{
			db = new Sqlite(null);
			db.Connect(HOME + "/.gnome-rdp.db");
			db.Query("INSERT INTO session (" +
				(WithId?"id, ":"") +
				"parentid, " +
				"iscategory, " +
				"sessionname, " +
				"protocol, " +
				"computer, " +
				"user, " +
				"password, " +
				"domain, " +
				"srvtype, " +
				"colordepth, " + 
				"screenresolutionx, " +
				"screenresolutiony, " +
				"soundredirection, " +
				"keyboardlang, " +
				"connectiontype, " +
				"windowmode, " +
				"terminalsize, " +
				"compressionlevel, " +
				"imagequality) " +
				"VALUES (" + 
				(WithId?this.Id + ", ":"") +
				this.ParentId + ", " +
				Convert.ToInt32(this.IsCategory) + ", '" +
				this.SessionName + "', " + 
				this.Protocol + ", '" + 
				this.Computer +	"', '" + 
				this.User + "', '" + 
				(IsSavePasswd?this.Password:"") + "', '" + 
				this.Domain + "', " + 
				this.SrvType + ", " + 
				this.ColorDepth + ", " + 
				this.ScreenResolutionX + ", " +
				this.ScreenResolutionY + ", " +
				this.SoundRedirection + ", '" + 
				this.KeyboardLang + "', " + 
				this.ConnectionType + ", " + 
				this.WindowMode + ", " + 
				this.TerminalSize +	", " + 
				this.CompressionLevel + ", " + 
				this.ImageQuality +")");
			db.Close();		
		}
		
		public ArrayList LoadSessions()
		{
			ArrayList sessions = new ArrayList();
			
			db = new Sqlite(null);
			db.Connect(HOME + "/.gnome-rdp.db");
			db.Query("SELECT * FROM session ORDER BY iscategory DESC, sessionname");
			while (db.FetchRow(out result))
			{
				Configuration cfg = new Configuration();
				cfg._id = Convert.ToInt32(result["id"].ToString());
				cfg._parentId = Convert.ToInt32(result["parentid"].ToString());
				cfg._isCategory = Convert.ToBoolean(Convert.ToInt32(result["iscategory"]));
				cfg._colorDepth = Convert.ToInt32(result["colordepth"].ToString());
				cfg._compressionLevel = Convert.ToInt32(result["compressionlevel"].ToString());
				cfg._computer = result["computer"].ToString();
				cfg._connectionType = Convert.ToInt32(result["connectiontype"].ToString());
				cfg._domain = result["domain"].ToString();
				cfg._imageQuality = Convert.ToInt32(result["imagequality"].ToString());
				cfg._keyboardLang = result["keyboardlang"].ToString();
				cfg._password = result["password"].ToString();
				cfg._protocol = Convert.ToInt32(result["protocol"].ToString());
				cfg._screenResolutionX = Convert.ToInt32(result["screenresolutionx"].ToString());
				cfg._screenResolutionY = Convert.ToInt32(result["screenresolutiony"].ToString());
				cfg._sessionName = result["sessionname"].ToString();
				cfg._soundRedirection = Convert.ToInt32(result["soundredirection"].ToString());
				cfg._srvType = Convert.ToInt32(result["srvtype"].ToString());
				cfg._terminalSize = Convert.ToInt32(result["terminalsize"].ToString());
				cfg._user = result["user"].ToString();
				cfg._windowMode = Convert.ToInt32(result["windowmode"].ToString());
				sessions.Add(cfg);
			}
			db.Close();
			return sessions;
		}
		
		public void LoadSessionData(string sessionName)
		{
			db = new Sqlite(null);
			db.Connect(HOME + "/.gnome-rdp.db");
			db.Query("SELECT * FROM session WHERE sessionname = '" + sessionName + "'");
			if (db.FetchRow(out result))
			{
				this._id = Convert.ToInt32(result["id"]);
				this._parentId = Convert.ToInt32(result["parentid"]);
				this._isCategory = Convert.ToBoolean(Convert.ToInt32(result["iscategory"]));
				this._colorDepth = Convert.ToInt32(result["colordepth"]);
				this._computer = result["computer"].ToString();
				this._connectionType = Convert.ToInt32(result["connectiontype"]);
				this._domain = result["domain"].ToString();
				this._keyboardLang = result["keyboardlang"].ToString();
				this._password = result["password"].ToString();
				this._protocol = Convert.ToInt32(result["protocol"]);
				this._screenResolutionX = Convert.ToInt32(result["screenresolutionx"]);
				this._screenResolutionY = Convert.ToInt32(result["screenresolutiony"]);
				this._soundRedirection = Convert.ToInt32(result["soundredirection"]);
				this._srvType = Convert.ToInt32(result["srvtype"]);
				this._terminalSize = Convert.ToInt32(result["terminalsize"]);
				this._user = result["user"].ToString();
				this._windowMode = Convert.ToInt32(result["windowmode"]);
				this._compressionLevel = Convert.ToInt32(result["compressionlevel"].ToString());
				this._imageQuality = Convert.ToInt32(result["imagequality"].ToString());				
			}
			db.Close();			
		}
		
		public ArrayList LoadCategories()
		{
			ArrayList categories = new ArrayList();
			
			db = new Sqlite(null);
			db.Connect(HOME + "/.gnome-rdp.db");
			db.Query("SELECT * FROM session WHERE iscategory = 1 ORDER BY sessionname");
			while (db.FetchRow(out result))
			{
				Configuration cfg = new Configuration();
				cfg._id = Convert.ToInt32(result["id"].ToString());
				cfg._parentId = Convert.ToInt32(result["parentid"].ToString());
				cfg.SessionName = result["sessionname"].ToString();
				cfg.Protocol = Convert.ToInt32(result["protocol"].ToString());
				cfg._isCategory = Convert.ToBoolean(Convert.ToInt32(result["iscategory"]));
				categories.Add(cfg);
			}
			db.Close();
			return categories;		
		}
	}
}