/* $Id: rbgnome-about.c,v 1.1.1.1 2000/03/29 18:43:11 iga Exp $ */

/* Gnome::About widget for Ruby/Gnome
 * Copyright (C) 1999 Minoru Inachi <inachi@earth.interq.or.jp>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "rbgnome.h"

/*
 * Class Gnome::About
 *
 * Description:
 *   A very specialized widget to display "About this program"-like
 *   boxes.
 *
 * Hierarchy:
 *
 *   Object
 *     +----Gtk::Object
 *            +----Gtk::Widget
 *                   +----Gtk::Container
 *                          +----Gtk::Bin
 *                                 +----Gtk::Window
 *                                        +----Gnome::Dialog
 *                                               +----Gnome::About
 */
VALUE gnoAbout;

static VALUE
about_initialize(argc, argv, self)
    int argc;
    VALUE* argv;
    VALUE self;
{
    VALUE title, version, copyright, authors, comments, logo;
    gchar *c_title, *c_version, *c_copyright, *c_comments, *c_logo;
    const gchar **c_authors;
    int i;
    GtkWidget* result;

    rb_scan_args(argc, argv, "06",
		 &title, &version, &copyright, &authors, &comments, &logo);

    c_title = NIL_P(title)?0:STR2CSTR(title);
    c_version = NIL_P(version)?0:STR2CSTR(version);
    c_copyright = NIL_P(copyright)?0:STR2CSTR(copyright);

    if (NIL_P(authors)) {
	c_authors = 0;
    } else {
	Check_Type(authors, T_ARRAY);
	c_authors = ALLOCA_N(const gchar*, RARRAY(authors)->len+1);
	for (i=0; i<RARRAY(authors)->len; i++) {
	    c_authors[i] = STR2CSTR(RARRAY(authors)->ptr[i]);
	}
	c_authors[i] = 0;
    }

    c_comments = NIL_P(comments)?0:STR2CSTR(comments);
    c_logo = NIL_P(logo)?0:STR2CSTR(logo);

    result = gnome_about_new(c_title, c_version, c_copyright,
			     c_authors, c_comments, c_logo);

    set_widget(self, result);

    return Qnil;
}

void
Init_gnome_about()
{
    gnoAbout = rb_define_class_under(mGnome, "About", gnoDialog);

    /*
     * instance methods
     */
    rb_define_method(gnoAbout, "initialize", about_initialize, -1);
}

