/* $Id: rbgnome-canvas.c,v 1.1.1.1 2000/03/29 18:43:12 iga Exp $ */

VALUE gnoCanvasItem;

/* Create a canvas item using the standard Gtk argument mechanism.  The item is
 * automatically inserted at the top of the specified canvas group.  The last
 * argument must be a NULL pointer.
 */
static VALUE
canvasitem_initialize(self, parent, type, args)
    VALUE self, parent, type, args;
{
    GnomeCanvasItem *item;

    GnomeCanvasItem *gnome_canvas_item_newv (GnomeCanvasGroup *parent, GtkType type,
					 guint nargs, GtkArg *args);

/* Constructors for use in derived classes and language wrappers */
void gnome_canvas_item_construct (GnomeCanvasItem *item, GnomeCanvasGroup *parent,
				  const gchar *first_arg_name, va_list args);

void gnome_canvas_item_constructv (GnomeCanvasItem *item, GnomeCanvasGroup *parent,
				   guint nargs, GtkArg *args);

/* Configure an item using the standard Gtk argument mechanism.  The last
 * argument must be a NULL pointer.
 */
void gnome_canvas_item_set (GnomeCanvasItem *item, const gchar *first_arg_name, ...);

/* Same as above, with parsed args */
void gnome_canvas_item_setv (GnomeCanvasItem *item, guint nargs, GtkArg *args);

/* Used only for language wrappers and the like */
void gnome_canvas_item_set_valist (GnomeCanvasItem *item,
				   const gchar *first_arg_name, va_list args);

/* Move an item by the specified amount */
void gnome_canvas_item_move (GnomeCanvasItem *item, double dx, double dy);

/* Apply a relative affine transformation to the item. */
void gnome_canvas_item_affine_relative (GnomeCanvasItem *item, const double affine[6]);

/* Apply an absolute affine transformation to the item. */
void gnome_canvas_item_affine_absolute (GnomeCanvasItem *item, const double affine[6]);

/* Scale an item about a point by the specified factors */
void gnome_canvas_item_scale (GnomeCanvasItem *item,
			      double x, double y,
			      double scale_x, double scale_y);

/* Rotate an item about a point by the specified number of degrees */
void gnome_canvas_item_rotate (GnomeCanvasItem *item, double x, double y, double angle);

/* Raise an item in the z-order of its parent group by the specified number of
 * positions.
 */
void gnome_canvas_item_raise (GnomeCanvasItem *item, int positions);

/* Lower an item in the z-order of its parent group by the specified number of
 * positions.
 */
void gnome_canvas_item_lower (GnomeCanvasItem *item, int positions);

/* Raise an item to the top of its parent group's z-order. */
void gnome_canvas_item_raise_to_top (GnomeCanvasItem *item);

/* Lower an item to the bottom of its parent group's z-order */
void gnome_canvas_item_lower_to_bottom (GnomeCanvasItem *item);

/* Show an item (make it visible).  If the item is already shown, it has no
 * effect.
 */
void gnome_canvas_item_show (GnomeCanvasItem *item);

/* Hide an item (make it invisible).  If the item is already invisible, it has
 * no effect.
 */
void gnome_canvas_item_hide (GnomeCanvasItem *item);

/* Grab the mouse for the specified item.  Only the events in event_mask will be
 * reported.  If cursor is non-NULL, it will be used during the duration of the
 * grab.  Time is a proper X event time parameter.  Returns the same values as
 * XGrabPointer().
 */
int gnome_canvas_item_grab (GnomeCanvasItem *item, unsigned int event_mask,
			    GdkCursor *cursor, guint32 etime);

/* Ungrabs the mouse -- the specified item must be the same that was passed to
 * gnome_canvas_item_grab().  Time is a proper X event time parameter.
 */
void gnome_canvas_item_ungrab (GnomeCanvasItem *item, guint32 etime);

/* These functions convert from a coordinate system to another.  "w" is world
 * coordinates and "i" is item coordinates.
 */
void gnome_canvas_item_w2i (GnomeCanvasItem *item, double *x, double *y);
void gnome_canvas_item_i2w (GnomeCanvasItem *item, double *x, double *y);

/* Gets the affine transform that converts from item-relative coordinates to
 * world coordinates.
 */
void gnome_canvas_item_i2w_affine (GnomeCanvasItem *item, double affine[6]);

/* Gets the affine transform that converts from item-relative coordinates to
 * canvas pixel coordinates.
 */
void gnome_canvas_item_i2c_affine (GnomeCanvasItem *item, double affine[6]);

/* Remove the item from its parent group and make the new group its parent.  The
 * item will be put on top of all the items in the new group.  The item's
 * coordinates relative to its new parent to *not* change -- this means that the
 * item could potentially move on the screen.
 * 
 * The item and the group must be in the same canvas.  An item cannot be
 * reparented to a group that is the item itself or that is an inferior of the
 * item.
 */
void gnome_canvas_item_reparent (GnomeCanvasItem *item, GnomeCanvasGroup *new_group);

/* Used to send all of the keystroke events to a specific item as well as
 * GDK_FOCUS_CHANGE events.
 */
void gnome_canvas_item_grab_focus (GnomeCanvasItem *item);

/* Fetch the bounding box of the item.  The bounding box may not be exactly
 * tight, but the canvas items will do the best they can.  The returned bounding
 * box is in the coordinate system of the item's parent.
 */
void gnome_canvas_item_get_bounds (GnomeCanvasItem *item,
				   double *x1, double *y1, double *x2, double *y2);

/* Request that the update method eventually get called.  This should be used
 * only by item implementations.
 */
void gnome_canvas_item_request_update (GnomeCanvasItem *item);


void
Init_gnome_canvas()
{
    /*
     * Gnome::Canvas
     */
    gnoCanvasItem = rb_define_class_under(mGnome, "CanvasItem", gObject);

    /* Constsnts */
    rb_define_const(gnoCanvasItem, "REALIZED",
		    INT2FIX(GNOME_CANVAS_ITEM_REALIZED));
    rb_define_const(gnoCanvasItem, "MAPPED",
		    INT2FIX(GNOME_CANVAS_ITEM_MAPPED));
    rb_define_const(gnoCanvasItem, "ALWAYS_REDRAW",
		    INT2FIX(GNOME_CANVAS_ITEM_ALWAYS_REDRAW));
    rb_define_const(gnoCanvasItem, "VISIBLE",
		    INT2FIX(GNOME_CANVAS_ITEM_VISIBLE));
    rb_define_const(gnoCanvasItem, "NEED_UPDATE",
		    INT2FIX(GNOME_CANVAS_ITEM_NEED_UPDATE));
    rb_define_const(gnoCanvasItem, "NEED_AFFINE",
		    INT2FIX(GNOME_CANVAS_ITEM_NEED_AFFINE));
    rb_define_const(gnoCanvasItem, "NEED_CLIP",
		    INT2FIX(GNOME_CANVAS_ITEM_NEED_CLIP));
    rb_define_const(gnoCanvasItem, "NEED_VIS",
		    INT2FIX(GNOME_CANVAS_ITEM_NEED_VIS));
    rb_define_const(gnoCanvasItem, "AFFINE_FULL",
		    INT2FIX(GNOME_CANVAS_ITEM_AFFINE_FULL));

    rb_define_const(gnoCanvas, "UPDATE_REQUESTED",
		    INT2FIX(GNOME_CANVAS_UPDATE_REQUESTED));
    rb_define_const(gnoCanvas, "UPDATE_AFFINE",
		    INT2FIX(GNOME_CANVAS_UPDATE_AFFINE));
    rb_define_const(gnoCanvas, "UPDATE_CLIP",
		    INT2FIX(GNOME_CANVAS_UPDATE_CLIP));
    rb_define_const(gnoCanvas, "UPDATE_VISIBILITY",
		    INT2FIX(GNOME_CANVAS_UPDATE_VISIBILITY));
    rb_define_const(gnoCanvas, "UPDATE_IS_VISIBLE",
		    INT2FIX(GNOME_CANVAS_UPDATE_IS_VISIBLE));
}
