/* sudoku-game.c generated by valac 0.26.0.21-afb3, the Vala compiler
 * generated from sudoku-game.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <string.h>


#define TYPE_SUDOKU_GAME (sudoku_game_get_type ())
#define SUDOKU_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_GAME, SudokuGame))
#define SUDOKU_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_GAME, SudokuGameClass))
#define IS_SUDOKU_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_GAME))
#define IS_SUDOKU_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_GAME))
#define SUDOKU_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_GAME, SudokuGameClass))

typedef struct _SudokuGame SudokuGame;
typedef struct _SudokuGameClass SudokuGameClass;
typedef struct _SudokuGamePrivate SudokuGamePrivate;

#define TYPE_SUDOKU_BOARD (sudoku_board_get_type ())
#define SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_BOARD, SudokuBoard))
#define SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_BOARD, SudokuBoardClass))
#define IS_SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_BOARD))
#define IS_SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_BOARD))
#define SUDOKU_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_BOARD, SudokuBoardClass))

typedef struct _SudokuBoard SudokuBoard;
typedef struct _SudokuBoardClass SudokuBoardClass;

#define SUDOKU_GAME_TYPE_UNDO_ITEM (sudoku_game_undo_item_get_type ())
typedef struct _SudokuGameUndoItem SudokuGameUndoItem;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
typedef struct _SudokuBoardPrivate SudokuBoardPrivate;

#define TYPE_COORD (coord_get_type ())
typedef struct _Coord Coord;
#define _sudoku_game_undo_item_free0(var) ((var == NULL) ? NULL : (var = (sudoku_game_undo_item_free (var), NULL)))

struct _SudokuGame {
	GObject parent_instance;
	SudokuGamePrivate * priv;
	SudokuBoard* board;
	GTimer* timer;
};

struct _SudokuGameClass {
	GObjectClass parent_class;
};

struct _SudokuGameUndoItem {
	gint row;
	gint col;
	gint val;
};

struct _SudokuGamePrivate {
	GeeArrayList* undostack;
	GeeArrayList* redostack;
};

struct _Coord {
	gint row;
	gint col;
};

struct _SudokuBoard {
	GObject parent_instance;
	SudokuBoardPrivate * priv;
	gint* cells;
	gint cells_length1;
	gint cells_length2;
	gboolean* is_fixed;
	gint is_fixed_length1;
	gint is_fixed_length2;
	GeeSet* broken_coords;
	GeeList* coords_for_col;
	GeeList* coords_for_row;
	GeeMap* coords_for_block;
};

struct _SudokuBoardClass {
	GObjectClass parent_class;
};


static gpointer sudoku_game_parent_class = NULL;

GType sudoku_game_get_type (void) G_GNUC_CONST;
GType sudoku_board_get_type (void) G_GNUC_CONST;
static GType sudoku_game_undo_item_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SudokuGameUndoItem* sudoku_game_undo_item_dup (const SudokuGameUndoItem* self);
static void sudoku_game_undo_item_free (SudokuGameUndoItem* self);
#define SUDOKU_GAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_GAME, SudokuGamePrivate))
enum  {
	SUDOKU_GAME_DUMMY_PROPERTY
};
gboolean sudoku_game_is_undostack_null (SudokuGame* self);
gboolean sudoku_game_is_redostack_null (SudokuGame* self);
SudokuGame* sudoku_game_new (SudokuBoard* board);
SudokuGame* sudoku_game_construct (GType object_type, SudokuBoard* board);
void sudoku_game_insert (SudokuGame* self, gint row, gint col, gint val);
gint sudoku_board_get (SudokuBoard* self, gint row, gint col);
void sudoku_game_update_undo (SudokuGame* self, gint row, gint col, gint old_val, gint new_val);
void sudoku_board_insert (SudokuBoard* self, gint row, gint col, gint val, gboolean is_fixed);
void sudoku_game_remove (SudokuGame* self, gint row, gint col);
void sudoku_board_remove (SudokuBoard* self, gint row, gint col, gboolean is_fixed);
void sudoku_game_undo (SudokuGame* self);
static void sudoku_game_apply_stack (SudokuGame* self, GeeArrayList** from, GeeArrayList** to);
void sudoku_game_redo (SudokuGame* self);
void sudoku_game_reset (SudokuGame* self);
gint sudoku_board_get_rows (SudokuBoard* self);
gint sudoku_board_get_cols (SudokuBoard* self);
GType coord_get_type (void) G_GNUC_CONST;
Coord* coord_dup (const Coord* self);
void coord_free (Coord* self);
void sudoku_game_cell_changed_cb (SudokuGame* self, gint row, gint col, gint old_val, gint new_val);
static void sudoku_game_add_to_stack (SudokuGame* self, GeeArrayList** stack, gint r, gint c, gint v);
gdouble sudoku_game_get_total_time_played (SudokuGame* self);
gdouble sudoku_board_get_previous_played_time (SudokuBoard* self);
static void g_cclosure_user_marshal_VOID__INT_INT_INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void sudoku_game_finalize (GObject* obj);


gboolean sudoku_game_is_undostack_null (SudokuGame* self) {
	gboolean result = FALSE;
	GeeArrayList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = self->priv->undostack;
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp0_);
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = _tmp1_;
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	result = _tmp2_ == 0;
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	return result;
#line 167 "sudoku-game.c"
}


gboolean sudoku_game_is_redostack_null (SudokuGame* self) {
	gboolean result = FALSE;
	GeeArrayList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = self->priv->redostack;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp0_);
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = _tmp1_;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	result = _tmp2_ == 0;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	return result;
#line 188 "sudoku-game.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	return self ? g_object_ref (self) : NULL;
#line 195 "sudoku-game.c"
}


SudokuGame* sudoku_game_construct (GType object_type, SudokuBoard* board) {
	SudokuGame * self = NULL;
	SudokuBoard* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	GTimer* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_val_if_fail (board != NULL, NULL);
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	self = (SudokuGame*) g_object_new (object_type, NULL);
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = board;
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_g_object_unref0 (self->board);
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	self->board = _tmp1_;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = g_timer_new ();
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_g_timer_destroy0 (self->timer);
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	self->timer = _tmp2_;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_ = gee_array_list_new (SUDOKU_GAME_TYPE_UNDO_ITEM, (GBoxedCopyFunc) sudoku_game_undo_item_dup, sudoku_game_undo_item_free, NULL, NULL, NULL);
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_g_object_unref0 (self->priv->undostack);
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	self->priv->undostack = _tmp3_;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp4_ = gee_array_list_new (SUDOKU_GAME_TYPE_UNDO_ITEM, (GBoxedCopyFunc) sudoku_game_undo_item_dup, sudoku_game_undo_item_free, NULL, NULL, NULL);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_g_object_unref0 (self->priv->redostack);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	self->priv->redostack = _tmp4_;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	return self;
#line 238 "sudoku-game.c"
}


SudokuGame* sudoku_game_new (SudokuBoard* board) {
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	return sudoku_game_construct (TYPE_SUDOKU_GAME, board);
#line 245 "sudoku-game.c"
}


void sudoku_game_insert (SudokuGame* self, gint row, gint col, gint val) {
	gint old_val = 0;
	SudokuBoard* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	SudokuBoard* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = self->board;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = row;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = col;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_ = sudoku_board_get (_tmp0_, _tmp1_, _tmp2_);
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	old_val = _tmp3_;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp4_ = row;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp5_ = col;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp6_ = val;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_game_update_undo (self, _tmp4_, _tmp5_, old_val, _tmp6_);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp7_ = self->board;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp8_ = row;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp9_ = col;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp10_ = val;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_board_insert (_tmp7_, _tmp8_, _tmp9_, _tmp10_, FALSE);
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp11_ = row;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp12_ = col;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp13_ = val;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_signal_emit_by_name (self, "cell-changed", _tmp11_, _tmp12_, old_val, _tmp13_);
#line 303 "sudoku-game.c"
}


void sudoku_game_remove (SudokuGame* self, gint row, gint col) {
	gint old_val = 0;
	SudokuBoard* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	SudokuBoard* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = self->board;
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = row;
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = col;
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_ = sudoku_board_get (_tmp0_, _tmp1_, _tmp2_);
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	old_val = _tmp3_;
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp4_ = row;
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp5_ = col;
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_game_update_undo (self, _tmp4_, _tmp5_, old_val, 0);
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp6_ = self->board;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp7_ = row;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp8_ = col;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_board_remove (_tmp6_, _tmp7_, _tmp8_, FALSE);
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp9_ = row;
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp10_ = col;
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_signal_emit_by_name (self, "cell-changed", _tmp9_, _tmp10_, old_val, 0);
#line 352 "sudoku-game.c"
}


void sudoku_game_undo (SudokuGame* self) {
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_game_apply_stack (self, &self->priv->undostack, &self->priv->redostack);
#line 361 "sudoku-game.c"
}


void sudoku_game_redo (SudokuGame* self) {
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_game_apply_stack (self, &self->priv->redostack, &self->priv->undostack);
#line 370 "sudoku-game.c"
}


void sudoku_game_reset (SudokuGame* self) {
	GTimer* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	SudokuBoard* _tmp29_ = NULL;
	GeeSet* _tmp30_ = NULL;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = self->timer;
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_timer_reset (_tmp0_);
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = self->priv->undostack;
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = self->priv->redostack;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp2_);
#line 394 "sudoku-game.c"
	{
		gint l1 = 0;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		l1 = 0;
#line 399 "sudoku-game.c"
		{
			gboolean _tmp3_ = FALSE;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp3_ = TRUE;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			while (TRUE) {
#line 406 "sudoku-game.c"
				gint _tmp5_ = 0;
				SudokuBoard* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
				if (!_tmp3_) {
#line 413 "sudoku-game.c"
					gint _tmp4_ = 0;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
					_tmp4_ = l1;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
					l1 = _tmp4_ + 1;
#line 419 "sudoku-game.c"
				}
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
				_tmp3_ = FALSE;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
				_tmp5_ = l1;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
				_tmp6_ = self->board;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
				_tmp7_ = sudoku_board_get_rows (_tmp6_);
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
				_tmp8_ = _tmp7_;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
				if (!(_tmp5_ < _tmp8_)) {
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
					break;
#line 435 "sudoku-game.c"
				}
				{
					gint l2 = 0;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
					l2 = 0;
#line 441 "sudoku-game.c"
					{
						gboolean _tmp9_ = FALSE;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
						_tmp9_ = TRUE;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
						while (TRUE) {
#line 448 "sudoku-game.c"
							gint _tmp11_ = 0;
							SudokuBoard* _tmp12_ = NULL;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							SudokuBoard* _tmp15_ = NULL;
							gboolean* _tmp16_ = NULL;
							gint _tmp16__length1 = 0;
							gint _tmp16__length2 = 0;
							gint _tmp17_ = 0;
							gint _tmp18_ = 0;
							gboolean _tmp19_ = FALSE;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							if (!_tmp9_) {
#line 462 "sudoku-game.c"
								gint _tmp10_ = 0;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								_tmp10_ = l2;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								l2 = _tmp10_ + 1;
#line 468 "sudoku-game.c"
							}
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp9_ = FALSE;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp11_ = l2;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp12_ = self->board;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp13_ = sudoku_board_get_cols (_tmp12_);
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp14_ = _tmp13_;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							if (!(_tmp11_ < _tmp14_)) {
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								break;
#line 484 "sudoku-game.c"
							}
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp15_ = self->board;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp16_ = _tmp15_->is_fixed;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp16__length1 = _tmp15_->is_fixed_length1;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp16__length2 = _tmp15_->is_fixed_length2;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp17_ = l1;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp18_ = l2;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp19_ = _tmp16_[(_tmp17_ * _tmp16__length2) + _tmp18_];
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							if (!_tmp19_) {
#line 502 "sudoku-game.c"
								SudokuBoard* _tmp20_ = NULL;
								gint _tmp21_ = 0;
								gint _tmp22_ = 0;
								gint _tmp23_ = 0;
								gint _tmp24_ = 0;
								SudokuBoard* _tmp25_ = NULL;
								gint _tmp26_ = 0;
								gint _tmp27_ = 0;
								gint _tmp28_ = 0;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								_tmp20_ = self->board;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								_tmp21_ = l1;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								_tmp22_ = l2;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								sudoku_board_remove (_tmp20_, _tmp21_, _tmp22_, FALSE);
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								_tmp23_ = l1;
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								_tmp24_ = l2;
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								_tmp25_ = self->board;
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								_tmp26_ = l1;
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								_tmp27_ = l2;
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								_tmp28_ = sudoku_board_get (_tmp25_, _tmp26_, _tmp27_);
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								g_signal_emit_by_name (self, "cell-changed", _tmp23_, _tmp24_, _tmp28_, 0);
#line 534 "sudoku-game.c"
							}
						}
					}
				}
			}
		}
	}
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp29_ = self->board;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp30_ = _tmp29_->broken_coords;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	gee_collection_clear ((GeeCollection*) _tmp30_);
#line 548 "sudoku-game.c"
}


void sudoku_game_cell_changed_cb (SudokuGame* self, gint row, gint col, gint old_val, gint new_val) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = row;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = col;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = old_val;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_ = new_val;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_signal_emit_by_name (self, "cell-changed", _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 569 "sudoku-game.c"
}


void sudoku_game_update_undo (SudokuGame* self, gint row, gint col, gint old_val, gint new_val) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GeeArrayList* _tmp3_ = NULL;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = row;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = col;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = old_val;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_game_add_to_stack (self, &self->priv->undostack, _tmp0_, _tmp1_, _tmp2_);
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_ = self->priv->redostack;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp3_);
#line 592 "sudoku-game.c"
}


static void sudoku_game_add_to_stack (SudokuGame* self, GeeArrayList** stack, gint r, gint c, gint v) {
	SudokuGameUndoItem step = {0};
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	SudokuGameUndoItem _tmp3_ = {0};
	GeeArrayList* _tmp4_ = NULL;
	SudokuGameUndoItem _tmp5_ = {0};
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (*stack != NULL);
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = r;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = c;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = v;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_.row = _tmp0_;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_.col = _tmp1_;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_.val = _tmp2_;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	step = _tmp3_;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp4_ = *stack;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp5_ = step;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, &_tmp5_);
#line 628 "sudoku-game.c"
}


static void sudoku_game_apply_stack (SudokuGame* self, GeeArrayList** from, GeeArrayList** to) {
	GeeArrayList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	SudokuGameUndoItem* top = NULL;
	GeeArrayList* _tmp3_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gpointer _tmp7_ = NULL;
	gint old_val = 0;
	SudokuBoard* _tmp8_ = NULL;
	SudokuGameUndoItem* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	SudokuGameUndoItem* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	SudokuGameUndoItem* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	SudokuGameUndoItem* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	SudokuBoard* _tmp19_ = NULL;
	SudokuGameUndoItem* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	SudokuGameUndoItem* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	SudokuGameUndoItem* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	SudokuGameUndoItem* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	SudokuGameUndoItem* _tmp35_ = NULL;
	gint _tmp36_ = 0;
	gint _tmp37_ = 0;
	SudokuGameUndoItem* _tmp38_ = NULL;
	gint _tmp39_ = 0;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (*from != NULL);
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (*to != NULL);
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = *from;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp0_);
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = _tmp1_;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	if (_tmp2_ == 0) {
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		return;
#line 684 "sudoku-game.c"
	}
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_ = *from;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp4_ = *from;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp5_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp4_);
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp6_ = _tmp5_;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp7_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp3_, _tmp6_ - 1);
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	top = (SudokuGameUndoItem*) _tmp7_;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp8_ = self->board;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp9_ = top;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp10_ = (*_tmp9_).row;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp11_ = top;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp12_ = (*_tmp11_).col;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp13_ = sudoku_board_get (_tmp8_, _tmp10_, _tmp12_);
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	old_val = _tmp13_;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp14_ = top;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp15_ = (*_tmp14_).row;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp16_ = top;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp17_ = (*_tmp16_).col;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp18_ = old_val;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_game_add_to_stack (self, to, _tmp15_, _tmp17_, _tmp18_);
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp19_ = self->board;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp20_ = top;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp21_ = (*_tmp20_).row;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp22_ = top;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp23_ = (*_tmp22_).col;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_board_remove (_tmp19_, _tmp21_, _tmp23_, FALSE);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp24_ = top;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp25_ = (*_tmp24_).val;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	if (_tmp25_ != 0) {
#line 742 "sudoku-game.c"
		SudokuBoard* _tmp26_ = NULL;
		SudokuGameUndoItem* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		SudokuGameUndoItem* _tmp29_ = NULL;
		gint _tmp30_ = 0;
		SudokuGameUndoItem* _tmp31_ = NULL;
		gint _tmp32_ = 0;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp26_ = self->board;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp27_ = top;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp28_ = (*_tmp27_).row;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp29_ = top;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp30_ = (*_tmp29_).col;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp31_ = top;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp32_ = (*_tmp31_).val;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		sudoku_board_insert (_tmp26_, _tmp28_, _tmp30_, _tmp32_, FALSE);
#line 766 "sudoku-game.c"
	}
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp33_ = top;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp34_ = (*_tmp33_).row;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp35_ = top;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp36_ = (*_tmp35_).col;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp37_ = old_val;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp38_ = top;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp39_ = (*_tmp38_).val;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_signal_emit_by_name (self, "cell-changed", _tmp34_, _tmp36_, _tmp37_, _tmp39_);
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_sudoku_game_undo_item_free0 (top);
#line 786 "sudoku-game.c"
}


gdouble sudoku_game_get_total_time_played (SudokuGame* self) {
	gdouble result = 0.0;
	SudokuBoard* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	GTimer* _tmp3_ = NULL;
	gdouble _tmp4_ = 0.0;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = self->board;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = sudoku_board_get_previous_played_time (_tmp0_);
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = _tmp1_;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_ = self->timer;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp4_ = g_timer_elapsed (_tmp3_, NULL);
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	result = _tmp2_ + _tmp4_;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	return result;
#line 813 "sudoku-game.c"
}


static void g_cclosure_user_marshal_VOID__INT_INT_INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT_INT_INT) (gpointer data1, gint arg_1, gint arg_2, gint arg_3, gint arg_4, gpointer data2);
	register GMarshalFunc_VOID__INT_INT_INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (n_param_values == 5);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		data1 = closure->data;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		data2 = param_values->data[0].v_pointer;
#line 832 "sudoku-game.c"
	} else {
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		data1 = param_values->data[0].v_pointer;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		data2 = closure->data;
#line 838 "sudoku-game.c"
	}
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	callback = (GMarshalFunc_VOID__INT_INT_INT_INT) (marshal_data ? marshal_data : cc->callback);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), g_value_get_int (param_values + 3), g_value_get_int (param_values + 4), data2);
#line 844 "sudoku-game.c"
}


static SudokuGameUndoItem* sudoku_game_undo_item_dup (const SudokuGameUndoItem* self) {
	SudokuGameUndoItem* dup;
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	dup = g_new0 (SudokuGameUndoItem, 1);
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	memcpy (dup, self, sizeof (SudokuGameUndoItem));
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	return dup;
#line 856 "sudoku-game.c"
}


static void sudoku_game_undo_item_free (SudokuGameUndoItem* self) {
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_free (self);
#line 863 "sudoku-game.c"
}


static GType sudoku_game_undo_item_get_type (void) {
	static volatile gsize sudoku_game_undo_item_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_game_undo_item_type_id__volatile)) {
		GType sudoku_game_undo_item_type_id;
		sudoku_game_undo_item_type_id = g_boxed_type_register_static ("SudokuGameUndoItem", (GBoxedCopyFunc) sudoku_game_undo_item_dup, (GBoxedFreeFunc) sudoku_game_undo_item_free);
		g_once_init_leave (&sudoku_game_undo_item_type_id__volatile, sudoku_game_undo_item_type_id);
	}
	return sudoku_game_undo_item_type_id__volatile;
}


static void sudoku_game_class_init (SudokuGameClass * klass) {
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_game_parent_class = g_type_class_peek_parent (klass);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_type_class_add_private (klass, sizeof (SudokuGamePrivate));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_game_finalize;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_signal_new ("cell_changed", TYPE_SUDOKU_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT_INT_INT, G_TYPE_NONE, 4, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT);
#line 887 "sudoku-game.c"
}


static void sudoku_game_instance_init (SudokuGame * self) {
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	self->priv = SUDOKU_GAME_GET_PRIVATE (self);
#line 894 "sudoku-game.c"
}


static void sudoku_game_finalize (GObject* obj) {
	SudokuGame * self;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_GAME, SudokuGame);
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_g_object_unref0 (self->board);
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_g_timer_destroy0 (self->timer);
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_g_object_unref0 (self->priv->undostack);
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_g_object_unref0 (self->priv->redostack);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	G_OBJECT_CLASS (sudoku_game_parent_class)->finalize (obj);
#line 912 "sudoku-game.c"
}


GType sudoku_game_get_type (void) {
	static volatile gsize sudoku_game_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_game_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuGameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuGame), 0, (GInstanceInitFunc) sudoku_game_instance_init, NULL };
		GType sudoku_game_type_id;
		sudoku_game_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuGame", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_game_type_id__volatile, sudoku_game_type_id);
	}
	return sudoku_game_type_id__volatile;
}



