/* GnoSamba 0.3.3
 * copyright 1998-9 Perry Piplani
 * redistributable under the terms of the GPL:
 * http://www.gnu.org/copyleft/gpl.html
 */



#include "gtksamba.h"
#include <string.h>

static int smbwin_count=0;



int main (int argc, char *argv[]){

  gnome_init (PACKAGE,VERSION, argc, argv);

  smbwin_new(NULL);
  g_print("Built with gtk+-%d.%d.%d\n",
	  GTK_MAJOR_VERSION, GTK_MINOR_VERSION, GTK_MICRO_VERSION);
  g_print ("Gnome support added\n");
  check_prefs();
  gtk_main ();
          
  return 0;
}



GtkWidget *smbwin_new(char *file){
  GtkWidget *window;
  GtkWidget *hpaned;
  GtkWidget *leftscroll;
  GtkWidget *rightnote;
  GtkWidget *servicelist;
  
  char *service_title[1] = {
    "Service name"
  };
  

  smbwin_count++;
  
  window=gnome_app_new (PACKAGE,PACKAGE);

  gtk_widget_set_usize(GTK_WIDGET(window), 500, 300);
  gtk_window_set_policy(GTK_WINDOW(window),TRUE,TRUE,FALSE);
  gtk_widget_realize (window);
  
  gtk_signal_connect(GTK_OBJECT(window),
		     "delete_event",
		     GTK_SIGNAL_FUNC(sw_delete_event),
		     window);

  sw_main_menu(window);
  sw_toolbars(window);

  hpaned = gtk_hpaned_new ();
  
  gnome_app_set_contents ( GNOME_APP(window), hpaned);
  gtk_paned_compute_position(GTK_PANED(hpaned),500,0,0);
  gtk_paned_set_position(GTK_PANED(hpaned), 150);
  gtk_widget_show (hpaned);

  servicelist = gtk_clist_new_with_titles( 1, service_title);

  gtk_object_set_data(GTK_OBJECT(window),"servicelist",servicelist);
 

  gtk_clist_set_selection_mode(GTK_CLIST(servicelist),
			       GTK_SELECTION_BROWSE);
  gtk_signal_connect(GTK_OBJECT(servicelist),
		     "select_row",
		     GTK_SIGNAL_FUNC(c_select_service),
		     window);

  leftscroll = gtk_scrolled_window_new(NULL, NULL);
  
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(leftscroll), 
				 GTK_POLICY_AUTOMATIC, 
				 GTK_POLICY_AUTOMATIC);
  gtk_widget_show (leftscroll);
  gtk_paned_add1 (GTK_PANED(hpaned), leftscroll);
  gtk_container_add (GTK_CONTAINER(leftscroll), servicelist);
  gtk_widget_show (servicelist);

  rightnote = gtk_notebook_new ();
  gtk_object_set_data(GTK_OBJECT(window),"rightnote",rightnote);
  gtk_notebook_set_show_tabs(GTK_NOTEBOOK (rightnote),FALSE);
  gtk_notebook_set_show_border(GTK_NOTEBOOK (rightnote),FALSE);
  gtk_paned_add2 (GTK_PANED(hpaned), rightnote);
  gtk_widget_show (rightnote);

  if(file)
    smbwin_open_lists(window,file);

  gtk_widget_show(window);
  return window;
}




gint sw_delete_event(GtkWidget *widget, GdkEvent *event, gpointer data){
  c_make_exit_dialog(widget,data);
  return TRUE;
}


void c_smbwin_destroy(GtkWidget *widget, gpointer window){
  GtkWidget *diagwin;
  GtkWidget *filew;
  GtkWidget *inserter;

  diagwin=gtk_object_get_data(GTK_OBJECT(window),"dialog");
  if(diagwin)
    gtk_widget_destroy(diagwin);
 
  inserter=gtk_object_get_data(GTK_OBJECT(window),
			    "inserter");  
  if(inserter)
    gtk_widget_destroy(inserter);

  smbwin_clear_lists(GTK_WIDGET(window));
  filew=gtk_object_get_data(GTK_OBJECT(window),
			    "filew");
  gtk_widget_destroy(GTK_WIDGET(window));
  if(filew)
    gtk_widget_destroy(filew);

  smbwin_count--;
  if(smbwin_count <= 0)
    gtk_main_quit();
}

void c_smbwin_close(GtkWidget *button, gpointer window){
  gchar *filepath;

  filepath=gtk_object_get_data(GTK_OBJECT(window),"filepath");
  if(filepath){
    g_free(filepath);
    gtk_object_set_data(GTK_OBJECT(window),"filepath",NULL);
  }
  
  smbwin_clear_lists(GTK_WIDGET(window));
  gtk_window_set_title(GTK_WINDOW(window), "Gtksamba");

  return;

}
  


void c_smbwin_new(GtkWidget *button, gpointer nulldata){
  smbwin_new(NULL);
}


void smbwin_filesel_ok(GtkWidget *button, gpointer window){
  GtkWidget *filew;
  int write;
  GtkWidget *servicelist;

  servicelist=gtk_object_get_data(GTK_OBJECT(window),"servicelist");

  filew=gtk_object_get_data(GTK_OBJECT(window),
			    "filew");    
  gtk_widget_hide(GTK_WIDGET(filew));
  resensitize_sw(GTK_WIDGET(window));
  write=GPOINTER_TO_INT(gtk_object_get_data
			(GTK_OBJECT(window),
			 "write"));
  if(write)
    write_smb_file(servicelist,
		   gtk_file_selection_get_filename 
		   (GTK_FILE_SELECTION (filew)));

  else
  smbwin_open_lists(GTK_WIDGET(window), 
		    gtk_file_selection_get_filename 
		    (GTK_FILE_SELECTION (filew)));
  return;
}

void smbwin_filesel_cancel(GtkWidget *button, gpointer window){
  GtkWidget *filew;

  filew=gtk_object_get_data(GTK_OBJECT(window),
			    "filew");    
  gtk_widget_hide(GTK_WIDGET(filew));
  resensitize_sw(window);
  return;
}

int smbwin_filesel_delete(GtkWidget *widget, GdkEvent *event, 
			  gpointer window){
  GtkWidget *filew;

  filew=gtk_object_get_data(GTK_OBJECT(window),
			    "filew");    
  gtk_widget_hide(GTK_WIDGET(filew));
  resensitize_sw(GTK_WIDGET(window));
  return TRUE;
}

void cw_make_sensitive
(GtkWidget *widget){
  if(widget)
    gtk_widget_set_sensitive(widget,TRUE);
  return;
}


void smbwin_filesel(GtkWidget *button, gpointer window){
  char *value;
  GtkWidget *filew;

  desensitize_sw(window);

  filew=gtk_object_get_data(GTK_OBJECT(window),
			    "filew");
  
  if(!filew){
    filew = gtk_file_selection_new ("File selection");
    gtk_object_set_data(GTK_OBJECT(window),
			    "filew",filew);         

    gtk_signal_connect(GTK_OBJECT (filew),
		       "delete_event",
		       (GtkSignalFunc) smbwin_filesel_delete,
		       window);
		       
		       
    /* Connect the ok_button to file_ok_sel function */
    gtk_signal_connect 
      (GTK_OBJECT (GTK_FILE_SELECTION (filew)->ok_button),
       "clicked", (GtkSignalFunc) smbwin_filesel_ok, window);
          
    /* Connect the cancel_button to destroy the widget */
    gtk_signal_connect 
      (GTK_OBJECT (GTK_FILE_SELECTION (filew)->cancel_button),
       "clicked", (GtkSignalFunc) smbwin_filesel_cancel ,window);
    
    value= get_config_val("smblocal","conf");
    gtk_file_selection_set_filename(GTK_FILE_SELECTION(filew),
				    value);
    g_free(value);

  }
  gtk_widget_show(GTK_WIDGET (filew));

  return;

}

void c_conf_open(GtkWidget *widget, gpointer window){
  char *value;

  value= get_config_val("smblocal","conf");
  smbwin_open_lists(GTK_WIDGET(window),value);
  g_free(value);

}


void c_alt_open(GtkWidget *button, gpointer window){
  gtk_object_set_data(GTK_OBJECT(window),
		      "write",
		      GINT_TO_POINTER(0));
  smbwin_filesel(button, window);
}

  

void c_write_conf(GtkWidget *widget, gpointer window){
  GtkWidget *servicelist;
  gchar *filepath;

  servicelist=gtk_object_get_data(GTK_OBJECT(window),"servicelist");
  filepath=gtk_object_get_data(GTK_OBJECT(window),"filepath");  

  write_smb_file(servicelist,filepath);
  return;
}

void c_write_alt(GtkWidget *button, gpointer window){
  gtk_object_set_data(GTK_OBJECT(window),
		      "write",
		      GINT_TO_POINTER(1));
  smbwin_filesel(button, window);
}




void c_edit_param(GtkWidget *menu_item, gpointer window){
  GtkWidget *sublist;

  sublist=gtk_object_get_data(GTK_OBJECT(window),"sublist");
	
  if(sublist && GTK_CLIST(sublist)->selection)
    make_edit_dialog(GTK_WIDGET(window));
  else
    make_user_mesg("Cannot edit parameter\nNothing is selected",
		    "message");
  return;
}
  


void c_delete_param(GtkWidget *menu_item, gpointer window){
  GtkWidget *sublist;

  sublist=gtk_object_get_data(GTK_OBJECT(window),"sublist");
	
  if(sublist && GTK_CLIST(sublist)->selection)
    make_del_dialog(GTK_WIDGET(window));
  else
    make_user_mesg("Cannot delete parameter\nNothing is selected",
		    "message");
  return;
}

void c_delete_service(GtkWidget *menu_item, gpointer window){
  GtkWidget *servicelist;

  servicelist=gtk_object_get_data(GTK_OBJECT(window),"servicelist");


  if(GTK_CLIST(servicelist)->selection)
    make_del_service_dialog(GTK_WIDGET(window));
  else
    make_user_mesg("Cannot delete service\nNothing is selected",
		    "message");
  return;
}
void c_insert_service(GtkWidget *menu_item, gpointer window){
  make_insert_service_dialog(GTK_WIDGET(window));
}

void c_help_about(GtkWidget *widget, gpointer data){
  const gchar *authors[] = {"perry@opensystems.com",NULL};
  GtkWidget *about;

  about=gnome_about_new(PACKAGE,VERSION,
			"Copyright 1998-9 Perry Piplani",
			authors, NULL, NULL);
  gtk_widget_show (about);
  return;
}

void c_help_sel_param(GtkWidget *widget, gpointer window){
  int row;
  char *text;
  GtkWidget *sublist;
 
  sublist=gtk_object_get_data(GTK_OBJECT(window),"sublist");

  if(sublist && GTK_CLIST(sublist)->selection){
    row = (int)(GTK_CLIST(sublist)->selection->data);
    gtk_clist_get_text(GTK_CLIST(sublist),
		       row ,0,&text);
    make_param_help(text);
  }
  else
    make_user_mesg("No parameter selected:",
		    "Message");
}

  

void c_param_diag_cancel(GtkWidget *button, gpointer window){
  GtkWidget *dialog;
 
  resensitize_sw(window);
  
  dialog=gtk_object_get_data(GTK_OBJECT(window),"dialog");
  if(dialog){
    gtk_widget_destroy(dialog);
    gtk_object_set_data(GTK_OBJECT(window),"dialog",NULL);
  }
return;

}

void c_param_diag_delete(GtkWidget *button, GdkEvent *event, 
			  gpointer data){

  c_param_diag_cancel(button,data);
  return;
}



void c_make_exit_dialog(GtkWidget *widget, gpointer window){
  GtkWidget *diagwin;
  GtkWidget *label;

  diagwin = gnome_dialog_new ("Exit?",
				  GNOME_STOCK_BUTTON_OK,
				  GNOME_STOCK_BUTTON_CANCEL,
				  NULL);
  gtk_object_set_data(GTK_OBJECT(window),"dialog",diagwin);
  gtk_window_position (GTK_WINDOW (diagwin),GTK_WIN_POS_CENTER);
  gnome_dialog_button_connect(GNOME_DIALOG(diagwin), 0,
                     GTK_SIGNAL_FUNC(c_smbwin_destroy),
                     (gpointer) window);
  gnome_dialog_button_connect(GNOME_DIALOG(diagwin), 1,
                     GTK_SIGNAL_FUNC(c_param_diag_cancel),
                     (gpointer) window);

  label = gtk_label_new("Do you really want to quit?");
  gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (diagwin)->vbox), 
		      label, TRUE, TRUE, 10);
  gtk_widget_show (label);
  gtk_widget_show (diagwin);
  return;

}



void desensitize_sw(GtkWidget *window){
  GtkWidget *inserter;

  gtk_widget_set_sensitive(window,FALSE);
  inserter=gtk_object_get_data(GTK_OBJECT(window),
			       "inserter");  
  if(inserter)
    gtk_widget_set_sensitive(inserter,FALSE);
  return;
}


void resensitize_sw(GtkWidget *window){
  GtkWidget *inserter;
  
  gtk_widget_set_sensitive(window,TRUE);
  inserter=gtk_object_get_data(GTK_OBJECT(window),
			       "inserter");  
  if(inserter)
    gtk_widget_set_sensitive(inserter,TRUE);

  return;
}





  

