/* mguru.h - Multiway guru widget.

   Copyright (C) 1999 Perry Piplani. Idea inspired by Havoc
   Pennington's gnome-guru widget, but is a re-implemention
   from scratch.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License
   as published by the Free Software Foundation; either version 2, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  */

#ifndef __GNOME_MGURU_H__
#define __GNOME_MGURU_H__

#include <gnome.h>

BEGIN_GNOME_DECLS

#define GNOME_MGURU(Obj)         GTK_CHECK_CAST (Obj, gnome_mguru_get_type (), GnomeMGuru)
#define GNOME_MGURU_CLASS(Klass) GTK_CHECK_CLASS_CAST (Klass, gnome_mguru_get_type (), GnomeMGuruClass)
#define GNOME_IS_MGURU(Obj)      GTK_CHECK_TYPE (Obj, gnome_mguru_get_type ())

typedef enum
{
  GNOME_MGURU_START,
  GNOME_MGURU_MIDDLE,
  GNOME_MGURU_LAST,
  GNOME_MGURU_ONLY
} GnomeMGuruState;

enum
{
  MGURU_BUTTON_CANCEL,
  MGURU_BUTTON_PREV,
  MGURU_BUTTON_NEXT,
  MGURU_BUTTON_APPLY,
  MGURU_LAST_BUTTON
} ;


typedef struct _GnomeMGuru     GnomeMGuru;
typedef struct _GnomeMGuruClass GnomeMGuruClass;

struct _GnomeMGuru
{
  GtkVBox vbox;
  
  GtkWidget *dialog;

  /* The notebook widget to contain the guru pages*/
  GtkWidget *notebook;	
  GtkWidget *button[MGURU_LAST_BUTTON];      
  
  gint multi;
  GnomeMGuruState state;
};

struct _GnomeMGuruClass
{
  GtkVBoxClass parent_class;
  
  void (* cancel) (GnomeMGuru *mguru, gint page);
  void (* apply) (GnomeMGuru *mguru, gint page);
  
  void (* prev) (GnomeMGuru *mguru, gint page);
  void (* next) (GnomeMGuru *mguru, gint page);

  void (* mguru_click) (GnomeMGuru *mguru, gint page, gint button);

};

guint gnome_mguru_get_type (void);

/* gnome_mguru_new()

   When creating this widget, you can create it as either single-way
   or multi-way by passing the multiway arguement as either FALSE or TRUE. 

   If creating a single-way guru, the widget is designed to only pass
   thru a linear sequence of pages. The page switching and button
   sensitivities are handled internally and you only need to connect
   to the "cancel" and "apply" signals. Connecting to the other
   signals is not recommended.

   If creating a multi-way guru, the widget can pass thru any sequence
   of pages. Use this when the need for one or more pages depends on
   user input at a previous page. You will have to capture all the
   button clicks and manually handle all the page switching and button
   sensitivities, using the _set_page(), _next_page(), _prev_page()
   and _set_state() methods.

   If the dialog arguement is not NULL, the widget will assume it is
   an empty dialog and wrap itself inside it.
   
   If the graphic arguement is not NULL, the guru will include a graphic.


*/

GtkWidget *gnome_mguru_new (gboolean multiway, 
			    GnomeDialog *dialog,
 			    GtkWidget   *graphic);

gint  gnome_mguru_append_page (GnomeMGuru *mguru,
			       GtkWidget *child, 
			       gchar *title);


void gnome_mguru_set_state(GnomeMGuru *mguru, 
			   GnomeMGuruState state);

void gnome_mguru_set_page(GnomeMGuru *mguru, gint page);

gint gnome_mguru_get_page(GnomeMGuru *mguru);

GtkWidget *gnome_mguru_get_page_child(GnomeMGuru *mguru, gint page);

void gnome_mguru_prev_page(GnomeMGuru *mguru);

void gnome_mguru_next_page(GnomeMGuru *mguru);

END_GNOME_DECLS

#endif /* __GNOME_MGURU_H___ */
