#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not, 
# write to the Free Software Foundation, Inc., 59 Temple Place 
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000, 2001 Free Software Foundation
#
# FILE:
# GConnections.py
#
# DESCRIPTION:
# Class that handles prompting user for login information 
# (design to be subclassed by the UI portion).
#
# NOTES:
#
# HISTORY:
#


#
# If user stops the login process (cancel button?), raise this exception
#
class UserCanceledLogin(Exception): 
  pass



class LoginHandler: 

  # The client app can set any default values for the needed parameters.
  defaults = {}

  #
  # getLogin is passed an list consisting of: 
  #   Connection Name
  #   Connection Comments/Description 
  #   List of Fields to Input: 
  #      Attribute Name, Label/Description, Is Password?
  #
  # It should return a dictionary of {Attribute Name: Inputted Value}
  #
  def getLogin(self, requiredFields): 
    pass


