# DBfactory - create an instance of a specific driver
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not, 
# write to the Free Software Foundation, Inc., 59 Temple Place 
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000 Free Software Foundation
#

import string
import sys
import os
from gnue.common import dyn_import

class factory:
    def create(self, driver):
        driver = string.split(driver, '|')

        if sys.platform == 'win32':
          os.putenv('PYTHONCASEOK','1')

        DBdriver = dyn_import("gnue.common.dbdrivers.%s" % (driver[0])).DBdriver()

        if driver[0] == "odbc":
            # call the ODBC driver loadDriver method to properly load
            # the correct ODBC subpackage
            DBdriver.loadDriver(driver)
        
        return DBdriver






