# GNU Enterprise RPC interface - Client adapter
#
# Copyright 2001-2005 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: client.py 7046 2005-02-20 14:43:17Z jan $

import string

from gnue.common.apps import errors, plugin

# =============================================================================
# Public functions
# =============================================================================

# -----------------------------------------------------------------------------
# Attach to a client driver
# -----------------------------------------------------------------------------

def attach (interface, params):
  driver = plugin.find (interface, 'gnue.common.rpc.drivers', 'ClientAdapter')
  return driver.ClientAdapter (params)

# =============================================================================
# Exceptions
# =============================================================================

# -----------------------------------------------------------------------------
# The basis of all rpc.client exceptions
# -----------------------------------------------------------------------------

class Error (gException):
  pass

# -----------------------------------------------------------------------------
# Requested adapter does not exist
# -----------------------------------------------------------------------------

class InvalidAdapter (errors.AdminError):
  pass

# -----------------------------------------------------------------------------
# The requested adapter could not initialize. Perhaps the
# supplied parameters do not point to a valid server, etc.
# -----------------------------------------------------------------------------

class AdapterInitializationError (errors.AdminError):
  pass

# -----------------------------------------------------------------------------
# The parameters supplied to the adapter are not in the
# correct format, or all the needed parameters were not
# supplied.
# -----------------------------------------------------------------------------

class AdapterConfigurationError (AdapterInitializationError):
  pass

# -----------------------------------------------------------------------------
# Parent for all caller errors
# -----------------------------------------------------------------------------

class ProgrammingError (errors.SystemError):
  pass

# -----------------------------------------------------------------------------
# A client application requested a service that is not
# exposed by the server.
# -----------------------------------------------------------------------------

class InvalidService (ProgrammingError):
  pass

# -----------------------------------------------------------------------------
# An invalid parameter was passed to a RPC
# -----------------------------------------------------------------------------

class InvalidParameter (ProgrammingError):
  pass


# =============================================================================
# Self test code - requires server.py running
# =============================================================================

if __name__ == '__main__':

  import traceback
  import sys
  from gnue.common.apps import errors
  
  if (len(sys.argv)==2) and \
     (sys.argv[1] in ['pyro','xmlrpc','socket','soap','xmlrpc.pw_xmlrpc','xmlrpc.py_xmlrpc']):
    connection = attach (sys.argv[1], {})
  else:
    print """
GNUe RPC test client

Usage: gcvs client.py <transport>

"""
    raise SystemExit

  obj = connection.request ('test')

  print 'stringtest:', repr (obj.stringtest ('This'))
  try:
    print 'ustringtest:', (obj.ustringtest (u'\xe0\xe2\xe1\xe4')).encode ('utf-8')
  except:
    print "UnicodeStringtest failed"
  print 'inttest: 21 * 2 =', repr (obj.inttest (21))
  print 'floattest: 123.45 * 2 =', repr (obj.floattest (123.45))
  print 'datetimetest:', repr (obj.datetimetest ())
  print 'booltest:', repr (obj.booltest ())
  #subobj = obj.objtest ()
  #print 'objtest:', repr (subobj)
# print 'subobj.test'
# subobj.test ()
  #del subobj

  print 'testing exception ...'

  try:
    obj.exceptiontest ()

  except Exception, e:
    print "-" * 70
    if isinstance (e, errors.gException):
      print "Exception Group:", e.getGroup ()
      print "Exception Name :", e.getName ()
      print "Message        :", e.getMessage ()
    else:
      print "Exception:", e

    print "-" * 70
    print "local traceback:"
    traceback.print_exc ()

    if isinstance (e, errors.gException):
      print "-" * 70
      print "remote exception detail:", e.getDetail ()
      print "-" * 70

  print 'shutting down server ...'
  try:
    # This will raise an exception because the server will not even answer any
    # more. Need to find a better way to shutdown the server.
    obj.shutdown ()
  except:
    pass
