#
# Copyright 2001-2005 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# FILE:
# PropertyBar.py
#
# DESCRIPTION:
#
# NOTES:

from wxPython.wx import *
import sys, string
from Utils import *
from gnue.common.apps import GDebug

#
#
#
class PropertyBar (wxPanel):
  def __init__(self, parent):
    wxPanel.__init__(self, parent, -1, style=wxCLIP_CHILDREN)
    self.parent = parent
    self.object = None
#    self.nameLabel = wxStaticText(self, -1, "Current Object:", pos=wxPoint(6,4))
#    self.nameEditor = wxTextCtrl(self, -1,
#          pos=calcRelPos(self.nameLabel, dx=6, absy=4))
#    self.nameEditor.SetEditable(0)

    self.blockLabel = wxStaticText(self, -1, "Current Block:",
          pos=wxPoint(6,4))
#          pos=calcRelPos(self.nameEditor, dx=6, absy=4))
    self.blockEditor = wxComboBox(self, -1,
          pos=calcRelPos(self.blockLabel, dx=6, absy=4))

    self.SetSize((100,8 + max(self.blockEditor.GetSizeTuple()[1],
#        self.nameEditor.GetSizeTuple()[1],
        self.blockLabel.GetSizeTuple()[1])))

##    self.typeLabel = wxStaticText(self, -1, "Class:",
##          pos=calcRelPos(self.nameEditor, absx=4, dy=8))
##    self.typeEditor = wxTextCtrl(self, -1,
##          pos=calcRelPos(self.nameLabel, self.nameEditor, dx=6, dy=4))
##    self.typeEditor.SetEditable(0)

##    self.xLabel = wxStaticText(self, -1, "x:",
##          pos=calcRelPos(self.nameEditor, dx=10, absy=8))
##    self.xEditor = wxSpinCtrl(self, -1,
##          pos=calcRelPos(self.xLabel, dx=4, absy=6))
##    self.xEditor.SetSize((50, self.xEditor.GetSize().height))
##
##    self.wLabel = wxStaticText(self, -1, "Width:  ",
##          pos=calcRelPos(self.xEditor, dx=6, absy=8))
##    self.wEditor = wxSpinCtrl(self, -1,
##          pos=calcRelPos(self.wLabel, dx=4, absy=6))
##    self.wEditor.SetSize(self.xEditor.GetSize())
##
##    self.yLabel = wxStaticText(self, -1, "y:",
##          pos=calcRelPos(self.nameEditor, self.xEditor, dx=10, dy=8))
##    self.yEditor = wxSpinCtrl(self, -1,
##          pos=calcRelPos(self.xLabel, self.xEditor, dx=4, dy=6))
##    self.yEditor.SetSize(self.xEditor.GetSize())
##
##    self.hLabel = wxStaticText(self, -1, "Height:",
##          pos=calcRelPos(self.xEditor, self.wEditor, dx=6, dy=8))
##    self.hEditor = wxSpinCtrl(self, -1,
##          pos=calcRelPos(self.wLabel, self.wEditor, dx=4, dy=6))
##    self.hEditor.SetSize(self.wEditor.GetSize())


##    self.Fit()

##    EVT_SPINCTRL(self, self.xEditor.GetId(), self.OnXUpdated)
##    EVT_SPINCTRL(self, self.yEditor.GetId(), self.OnYUpdated)
##    EVT_SPINCTRL(self, self.wEditor.GetId(), self.OnWidthUpdated)
##    EVT_SPINCTRL(self, self.hEditor.GetId(), self.OnHeightUpdated)


  def OnNameUpdated(self, event):
    self.object.name = self.nameEditor.GetValue()
#    self.parent._instance.onModifyObject(self.object, "Forms::LayoutEditor",

  def OnXUpdated(self, event):
    if hasattr(self.object, 'x'):
      dx = self.xEditor.GetValue() - self.object.x
      if dx:
        self.object._widgetHandler.relativeMove(dx,0)
    else:
      self.xEditor.SetValue(0)

  def OnYUpdated(self, event):
    if hasattr(self.object, 'y'):
      dy = self.yEditor.GetValue() - self.object.y
      if dy:
        self.object._widgetHandler.relativeMove(0, dy)
    else:
      self.yEditor.SetValue(0)

  def OnWidthUpdated(self, event):
    if hasattr(self.object, 'width'):
      dw = self.wEditor.GetValue() - self.object.width
      if dw:
        self.object._widgetHandler.relativeResize(dw,0)
    else:
      self.wEditor.SetValue(0)

  def OnHeightUpdated(self, event):
    if hasattr(self.object, 'height'):
      dh = self.hEditor.GetValue() - self.object.height
      if dh:
        self.object._widgetHandler.relativeResize(0,dh)
    else:
      self.hEditor.SetValue(0)

  def setCurrentObject(self, object):
    self.object = object

    self.typeEditor.SetValue(object._type[2:])

    if hasattr(object, 'x'):
      self.xEditor.SetValue(object.x)
#      self.xEditor.SetEditable(1)
    else:
      self.xEditor.SetValue(0)
#      self.xEditor.SetEditable(0)

    if hasattr(object, 'y'):
      self.yEditor.SetValue(object.y)
#      self.yEditor.SetEditable(1)
    else:
      self.yEditor.SetValue(0)
#      self.yEditor.SetEditable(0)

    if hasattr(object, 'width'):
      self.wEditor.SetValue(object.width)
#      self.wEditor.SetEditable(1)
    else:
      self.wEditor.SetValue(0)
#      self.wEditor.SetEditable(0)

    if hasattr(object, 'height'):
      self.hEditor.SetValue(object.height)
#      self.hEditor.SetEditable(1)
    else:
      self.hEditor.SetValue(0)
#      self.hEditor.SetEditable(0)

    if hasattr(object, 'name'):
      self.nameEditor.SetValue(object.name)
      self.nameEditor.SetEditable(0)
    else:
      self.nameEditor.SetValue(0)
      self.nameEditor.SetEditable(0)

  def onModifyObject (self, event):
    raise "I have not been fixed yet!"
    if object == None:
      return
    if object == self.object:
      for modification in modifications:
        field, value = modification
        if field == 'x':
          self.xEditor.SetValue(value)
        elif field == 'y':
          self.yEditor.SetValue(value)
        elif field == 'width':
          self.wEditor.SetValue(value)
        elif field == 'height':
          self.hEditor.SetValue(value)
        elif field == 'name':
          self.nameEditor.SetValue(value)

