/*
**
**  AddressBookWindow.m
**
**  Copyright (c) 2001, 2002
**
**  Ludovic Marcotte <ludovic@Sophos.ca>
**  Jonathan B. Leffert <jonathan@leffert.net>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "AddressBookWindow.h"

#import "AddressBook.h"
#import "AddressBookController.h"
#import "GNUMailConstants.h"
#import "LabelWidget.h"
#import "Utilities.h"


@implementation AddressBookWindow

- (void) dealloc
{
  RELEASE(browser);

  RELEASE(nameTextField);

  RELEASE(add);
  RELEASE(delete);
  RELEASE(modify);

  RELEASE(popup);
  
  [super dealloc];
}

- (void) layoutWindow
{
  NSButton *to, *cc, *bcc;
  NSButton *close, *import;
  NSScrollView *scrollView;
  LabelWidget *nameLabel;

  // Our NSBrowser object for our groups of addresses and addresses
  browser = [[NSBrowser alloc] initWithFrame: NSMakeRect(10,130,460,200)];
  [browser setAllowsMultipleSelection: NO];
  [browser setMaxVisibleColumns: 2];
  [browser setDelegate: [self windowController]];
  [browser setDoubleAction: @selector(doubleClicked:)];
  [browser setTitle: _(@"Groups")
	   ofColumn: 0];
  
  scrollView = [[NSScrollView alloc] initWithFrame: NSMakeRect(10,130,460,200)];
  [scrollView setBorderType: NSNoBorder];
  [scrollView setHasHorizontalScroller: NO];
  [scrollView setDocumentView: browser];
  [[self contentView] addSubview: scrollView];
  RELEASE(scrollView);
  
  
  // Our Name label / text field
  nameLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(10,100,50,TextFieldHeight)
			   label: _(@"Name:")];
  [[self contentView] addSubview: nameLabel];

  nameTextField = [[NSTextField alloc] initWithFrame: NSMakeRect(65,100,405,TextFieldHeight)];
  [[self contentView] addSubview: nameTextField];

  // Our add / delete / modify buttons and our Move to popup
  add = [[NSButton alloc] initWithFrame: NSMakeRect(10,65,110,ButtonHeight)];
  [add setStringValue: @"Add Group"];
  [add setTarget: [self windowController]];
  [[self contentView] addSubview: add];
 
  delete = [[NSButton alloc] initWithFrame: NSMakeRect(125,65,110,ButtonHeight)];
  [delete setStringValue: @"Delete Group"];
  [delete setTarget: [self windowController]];
  [[self contentView] addSubview: delete];

  modify = [[NSButton alloc] initWithFrame: NSMakeRect(240,65,100,ButtonHeight)];
  [modify setStringValue: _(@"Modify")];
  [modify setTarget: [self windowController]];
  [[self contentView] addSubview: modify];

  popup = [[NSPopUpButton alloc] initWithFrame: NSMakeRect(345,65,125,ButtonHeight)];
  [popup setTarget: [self windowController]];
  [popup setAction: @selector(selectionInPopUpHasChanged:)];
  [[self contentView] addSubview: popup];

  to = [[NSButton alloc] initWithFrame: NSMakeRect(10,5,50,50)];
  [to setStringValue: @""];
  [to setImagePosition: NSImageOnly];
  [to setImage:[NSImage imageNamed: @"Address_to.tiff"]];;
  [to setTarget: [self windowController]];
  [to setAction: @selector(toClicked:)];
  [[self contentView] addSubview: to];
  RELEASE(to);

  cc = [[NSButton alloc] initWithFrame: NSMakeRect(65,5,50,50)];
  [cc setStringValue: @""];
  [cc setImagePosition: NSImageOnly];
  [cc setImage:[NSImage imageNamed: @"Address_cc.tiff"]];
  [cc setTarget: [self windowController]];
  [cc setAction: @selector(ccClicked:)];
  [[self contentView] addSubview: cc];
  RELEASE(cc);

  bcc = [[NSButton alloc] initWithFrame: NSMakeRect(120,5,50,50)];
  [bcc setStringValue: @""];
  [bcc setImagePosition: NSImageOnly];
  [bcc setImage:[NSImage imageNamed: @"Address_bcc.tiff"]];
  [bcc setTarget: [self windowController]];
  [bcc setAction: @selector(bccClicked:)];
  [[self contentView] addSubview: bcc];
  RELEASE(bcc);

  import = [[NSButton alloc] initWithFrame: NSMakeRect(265,5,100,ButtonHeight)];
  [import setStringValue: _(@"Import")];
  [import setTarget: [self windowController]];
  [import setAction: @selector(importClicked:)];
  [[self contentView] addSubview: import];
  RELEASE(import);

  close = [[NSButton alloc] initWithFrame: NSMakeRect(370,5,100,ButtonHeight)];
  [close setStringValue: _(@"Close")];
  [close setTarget: self];
  [close setAction: @selector(close)];
  [[self contentView] addSubview: close];
  RELEASE(close);
}

//
// access/mutation methods
//

- (NSBrowser *) browser
{
  return browser;
}

- (NSTextField *) nameTextField
{
  return nameTextField;
}

- (NSButton *) add
{
  return add;
}

- (NSButton *) delete
{
  return delete;
}

- (NSButton *) modify
{
  return modify;
}

- (NSPopUpButton *) popup
{
  return popup;
}


@end
