/*
**  POP3View.m
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#import <AppKit/AppKit.h>
#import "POP3View.h"

#import "GNUMailConstants.h"
#import "LabelWidget.h"

@implementation POP3View

- (void) dealloc
{
  //NSLog(@"POP3View: -dealloc");

  RELEASE(leaveOnServer);
  RELEASE(daysField);
  RELEASE(useAPOP);

  [super dealloc];
}

- (void) initUI
{
  LabelWidget *label;

  leaveOnServer = [[NSButton alloc] initWithFrame: NSMakeRect(5,165,200,ButtonHeight)];
  [leaveOnServer setButtonType: NSSwitchButton];
  [leaveOnServer setBordered: NO];
  [leaveOnServer setTitle: _(@"Leave messages on server for")];
  [self addSubview: leaveOnServer];

  daysField = [[NSTextField alloc] initWithFrame: NSMakeRect(210,167,40,TextFieldHeight)];
  [self addSubview: daysField];
  
  label = [LabelWidget labelWidgetWithFrame: NSMakeRect(260,165,50,TextFieldHeight)
		       label: _(@"days")];
  [self addSubview: label];
  

  useAPOP = [[NSButton alloc] initWithFrame: NSMakeRect(5,135,200,ButtonHeight)];
  [useAPOP setButtonType: NSSwitchButton];
  [useAPOP setBordered: NO];
  [useAPOP setTitle: _(@"Use APOP (if possible)")];
  [self addSubview: useAPOP];
}


- (NSButton *) leaveOnServer
{
  return leaveOnServer;
}

- (NSTextField *) daysField
{
  return daysField;
}

- (NSButton *) useAPOP
{
  return useAPOP;
}

@end
