/*
**  ReceivingWindow.h
**
**  Copyright (c) 2001
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#import <AppKit/AppKit.h>

@class IMAPView;
@class POP3View;

@interface ReceivingWindow : NSWindow
{
  NSTabView *tabView;
  NSTabViewItem *tabViewItem1, *tabViewItem2;
  
  IMAPView *imapView;
  POP3View *pop3View;

  NSTextField *serverNameField, *serverPortField, *usernameField;
  NSPopUpButton *popup;
  NSSecureTextField *passwordSecureField;
  NSButton *rememberPassword;
}

- (void) layoutWindow;

//
// access/mutation methods
//

- (NSTabView *) tabView;
- (NSTabViewItem *) tabViewItem1;
- (NSTabViewItem *) tabViewItem2;

- (IMAPView *) imapView;
- (POP3View *) pop3View;

- (NSTextField *) serverNameField;
- (NSTextField *) serverPortField;
- (NSTextField *) usernameField;
- (NSPopUpButton *) popup;
- (NSSecureTextField *) passwordSecureField;
- (NSButton *) rememberPassword;

@end
