/*
**  ViewingView.m
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "ViewingView.h"

#import "GNUMailConstants.h"
#import "LabelWidget.h"

const NSString *TableColumnIdentifier = @"header";

@implementation ViewingView

- (id) initWithParent: (id) theParent
{
  self = [super init];

  parent = theParent;

  return self;
}

- (void) layoutView
{
  NSButton *removeShown, *addShown, *addDefaults;
  NSButton *moveUp, *moveDown;

  NSTableColumn *tableColumn;
  NSScrollView *scrollView;

  NSButtonCell *cell;

  LabelWidget *keyLabel;
  NSBox *box;

  //
  // Our messages box
  //
  box = [[NSBox alloc] initWithFrame: NSMakeRect(5,235,260,115)];
  [box setTitlePosition: NSAtTop];
  [box setTitle: _(@"Messages")];
  [box setBorderType: NSGrooveBorder];

  hideDeletedMessages = [[NSButton alloc] initWithFrame: NSMakeRect(5,45,250,ButtonHeight)];
  [hideDeletedMessages setButtonType: NSSwitchButton];
  [hideDeletedMessages setBordered: NO];
  [hideDeletedMessages setTitle: _(@"Hide deleted messages on startup")];
  [[box contentView] addSubview: hideDeletedMessages];
  
  highlightURLs = [[NSButton alloc] initWithFrame: NSMakeRect(5,15,250,ButtonHeight)];
  [highlightURLs setButtonType: NSSwitchButton];
  [highlightURLs setBordered: NO];
  [highlightURLs setTitle: _(@"Highlight URLs in message content")];
  [[box contentView] addSubview: highlightURLs];

  [self addSubview: box];
  RELEASE(box);

  
  //
  // Our table columns box
  //
  box = [[NSBox alloc] initWithFrame: NSMakeRect(270,235,165,115)];
  [box setContentViewMargins: NSMakeSize(10,5)];
  [box setTitlePosition: NSAtTop];
  [box setTitle: _(@"Table columns")];
  [box setBorderType: NSGrooveBorder];
  
  cell = [[NSButtonCell alloc] init];
  [cell setButtonType: NSSwitchButton];
  [cell setBordered: NO];
  [cell setImagePosition: NSImageLeft];

  matrix = [[NSMatrix alloc] initWithFrame: NSZeroRect
			     mode: NSHighlightModeMatrix
			     prototype: cell
			     numberOfRows: 3
			     numberOfColumns: 2];
  [matrix setIntercellSpacing: NSMakeSize (20, 12) ];
  [matrix setAutosizesCells: NO];

  cell = [matrix cellAtRow: 0 column: 0];
  [cell setTitle: _(@"Status")];

  cell = [matrix cellAtRow: 1 column: 0];
  [cell setTitle: _(@"Id")];

  cell = [matrix cellAtRow: 2 column: 0];
  [cell setTitle: _(@"Date")];

  cell = [matrix cellAtRow: 0 column: 1];
  [cell setTitle: _(@"From")];

  cell = [matrix cellAtRow: 1 column: 1];
  [cell setTitle: _(@"Subject")];

  cell = [matrix cellAtRow: 2 column: 1];
  [cell setTitle: _(@"Size")];

  [matrix sizeToFit];  
  [[box contentView] addSubview: matrix];

  [self addSubview: box];
  RELEASE(box);
  
  //
  // Our visible header box
  // 
  box = [[NSBox alloc] initWithFrame: NSMakeRect(5,5,430,220)];
  [box setContentViewMargins: NSMakeSize(5,0)];
  [box setTitlePosition: NSAtTop];
  [box setTitle: _(@"Shown headers while viewing a mail")];
  [box setBorderType: NSGrooveBorder];
  
  showAllHeaders = [[NSButton alloc] initWithFrame: NSMakeRect(5,165,200,ButtonHeight)];
  [showAllHeaders setButtonType: NSSwitchButton];
  [showAllHeaders setBordered: NO];
  [showAllHeaders setTitle: _(@"Show all headers")];
  [box addSubview: showAllHeaders];

  removeShown = [[NSButton alloc] initWithFrame: NSMakeRect(5,5,80,ButtonHeight)];
  [removeShown setStringValue: _(@"Remove")];
  [removeShown setTarget: parent];
  [removeShown setAction:@selector(removeShown:)];
  [[box contentView] addSubview: removeShown];
  RELEASE(removeShown);

  addShown = [[NSButton alloc] initWithFrame: NSMakeRect(95,5,80,ButtonHeight)];
  [addShown setStringValue: _(@"Add")];
  [addShown setTarget: parent];
  [addShown setAction:@selector(addShown:)];
  [[box contentView] addSubview: addShown];
  RELEASE(addShown);

  addDefaults = [[NSButton alloc] initWithFrame: NSMakeRect(185,5,80,ButtonHeight)];
  [addDefaults setStringValue: _(@"Defaults")];
  [addDefaults setTarget: parent];
  [addDefaults setAction:@selector(addDefaults:)];
  [[box contentView] addSubview: addDefaults];
  RELEASE(addDefaults);

  moveUp = [[NSButton alloc] initWithFrame:NSMakeRect(275,5,64,ButtonHeight)];
  [moveUp setTitle: @""];
  [moveUp setImagePosition: NSImageOnly];
  [moveUp setImage: [NSImage imageNamed: @"up.tiff"]];
  [moveUp setTarget: parent];
  [moveUp setAction: @selector(moveUp:)];
  [moveUp setAutoresizingMask: NSViewMinYMargin];
  [[box contentView] addSubview: moveUp];
  RELEASE(moveUp);
  
  moveDown = [[NSButton alloc] initWithFrame:NSMakeRect(349,5,64,ButtonHeight)];
  [moveDown setTitle: @""];
  [moveDown setImagePosition: NSImageOnly];
  [moveDown setImage: [NSImage imageNamed: @"down.tiff"]];
  [moveDown setTarget: parent];
  [moveDown setAction: @selector(moveDown:)];
  [moveDown setAutoresizingMask: NSViewMinYMargin];
  [[box contentView] addSubview: moveDown];
  RELEASE(moveDown);

  keyLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(5,40,60,TextFieldHeight)
			  label: _(@"Key:") ];
  [[box contentView] addSubview: keyLabel];

  keyField = [[NSTextField alloc] initWithFrame: NSMakeRect(70,40,340,TextFieldHeight)];
  [[box contentView] addSubview: keyField];

  tableColumn = [[NSTableColumn alloc] initWithIdentifier: (id) TableColumnIdentifier];
  AUTORELEASE(tableColumn);
  [tableColumn setEditable: YES];
  [[tableColumn headerCell] setStringValue: _(@"Shown Headers")];
  [tableColumn setWidth: 240];

  tableView = [[NSTableView alloc] initWithFrame: NSMakeRect(5,75,405,80)];
  [tableView setDrawsGrid:NO];
  [tableView setAllowsColumnSelection: NO];
  [tableView setAllowsColumnReordering: NO];
  [tableView setAllowsEmptySelection: NO];
  [tableView setAllowsMultipleSelection: NO];
  [tableView addTableColumn: tableColumn];
  [tableView setDataSource: parent]; 
  [tableView setDelegate: parent];

  scrollView = [[NSScrollView alloc] initWithFrame: NSMakeRect(5,75,405,80)];
  [scrollView setHasHorizontalScroller: NO];
  [scrollView setHasVerticalScroller: YES];
  [scrollView setDocumentView:tableView];
  [[box contentView] addSubview: scrollView];
  RELEASE(scrollView);

  [self addSubview: box];
  RELEASE(box);
}


-(void) dealloc
{
  //NSLog(@"ViewingView: -dealloc");

  RELEASE(highlightURLs);

  RELEASE(hideDeletedMessages);
  RELEASE(showAllHeaders);

  RELEASE(matrix);

  RELEASE(keyField);
  RELEASE(tableView);
  
  [super dealloc];
}

//
// access methods
//

- (NSButton *) highlightURLs
{
  return highlightURLs;
}

- (NSTableView *) tableView
{
  return tableView;
}

- (NSTextField *) keyField
{
  return keyField;
}

- (NSButton *) showAllHeaders
{
  return showAllHeaders;
}

- (NSButton *) hideDeletedMessages
{
  return hideDeletedMessages;
}

- (NSMatrix *) matrix
{
  return matrix;
}

@end
