/*
**  EditWindow.m
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "EditWindow.h"

#import "GNUMailConstants.h"
#import "LabelWidget.h"

@implementation EditWindow

//
//
//
- (void) dealloc
{
  NSLog(@"EditWindow: -dealloc");

  RELEASE(scrollView);
  RELEASE(textView);

  RELEASE(fromLabel);
  RELEASE(personalProfilePopUpButton);
  RELEASE(usingLabel);
  RELEASE(transportMethodPopUpButton);

  RELEASE(toLabel);
  RELEASE(toText);

  RELEASE(ccLabel);
  RELEASE(ccText);

  RELEASE(bccLabel);
  RELEASE(bccText);

  RELEASE(subjectLabel);
  RELEASE(subjectText);

  RELEASE(icon);
  RELEASE(send);
  RELEASE(insert);
  RELEASE(addBcc);
  RELEASE(addCc);
  RELEASE(addresses);
  RELEASE(cancel);
  
  [super dealloc];
}

//
//
//
- (void) layoutWindow
{
  // We first add our 'icon' button
  icon = [[NSButton alloc] initWithFrame: NSMakeRect(4,445,16,16)];
  [icon setTitle: @""];
  [icon setImagePosition: NSImageOnly];
  [icon setImage: [NSImage imageNamed: @"anim-logo-1.tiff"]];
  [icon setBordered: NO];
  [icon setEnabled: NO];
  [icon setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview: icon];
  
  send = [[NSButton alloc] initWithFrame:NSMakeRect(24,445,64,64)];
  [send setTitle: _(@"Send")];
  [send setFont:[NSFont systemFontOfSize: 8]];
  [send setTarget: [self windowController]];
  [send setAction: @selector(sendMessage:)];
  [send setImagePosition: NSImageAbove];
  [send setImage: [NSImage imageNamed: @"MailIcon_send.tiff"]];
  [send setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview:send];
  
  insert = [[NSButton alloc] initWithFrame:NSMakeRect(96,445,64,64)];
  [insert setTitle: _(@"Attach")];
  [insert setFont:[NSFont systemFontOfSize: 8]];
  [insert setTarget: [self windowController]];
  [insert setAction: @selector(insertFile:)];
  [insert setImagePosition: NSImageAbove];
  [insert setImage: [NSImage imageNamed: @"MailIcon_attach.tiff"]];
  [insert setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview:insert];

  addCc = [[NSButton alloc] initWithFrame:NSMakeRect(168,445,64,64)];
  [addCc setTitle: _(@"Add Cc")];
  [addCc setFont:[NSFont systemFontOfSize: 8]];
  [addCc setTarget: [self windowController]];
  [addCc setAction: @selector(showCc:)];
  [addCc setImagePosition: NSImageAbove];
  [addCc setImage: [NSImage imageNamed: @"MailIcon_cc.tiff"]];
  [addCc setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview: addCc];

  addBcc = [[NSButton alloc] initWithFrame:NSMakeRect(240,445,64,64)];
  [addBcc setTitle: _(@"Add Bcc")];
  [addBcc setFont:[NSFont systemFontOfSize: 8]];
  [addBcc setTarget: [self windowController]];
  [addBcc setAction: @selector(showBcc:)];
  [addBcc setImagePosition: NSImageAbove];
  [addBcc setImage: [NSImage imageNamed: @"MailIcon_bcc.tiff"]];
  [addBcc setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview: addBcc];

  addresses = [[NSButton alloc] initWithFrame:NSMakeRect(312,445,64,64)];
  [addresses setTitle: _(@"Addresses")];
  [addresses setFont:[NSFont systemFontOfSize: 8]];
  [addresses setTarget: [NSApp delegate]];
  [addresses setAction: @selector(showAddressBook:)];
  [addresses setImagePosition: NSImageAbove];
  [addresses setImage: [NSImage imageNamed: @"MailIcon_addresses.tiff"]];
  [addresses setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview:addresses];

  cancel = [[NSButton alloc] initWithFrame:NSMakeRect(384,445,64,64)];
  [cancel setTitle: _(@"Cancel")];
  [cancel setFont:[NSFont systemFontOfSize: 8]];
  [cancel setTarget: self];
  [cancel setAction: @selector(performClose:)];
  [cancel setImagePosition: NSImageAbove];
  [cancel setImage: [NSImage imageNamed: @"MailIcon_stop.tiff"]];
  [cancel setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview: cancel];

  // From
  fromLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(5,410,55,21) 
			   label: _(@"From:") ];
  [fromLabel setAutoresizingMask: NSViewMinYMargin];
  RETAIN(fromLabel);
  
  personalProfilePopUpButton = [[NSPopUpButton alloc] initWithFrame: NSMakeRect(65,410,300,ButtonHeight)];
  [personalProfilePopUpButton setAutoresizingMask: NSViewMaxXMargin|NSViewMinYMargin|NSViewWidthSizable];
  [personalProfilePopUpButton setTarget: [self windowController]];
  [personalProfilePopUpButton setAction: @selector(personalProfilesSelectionHasChanged:)];
  
  // Using
  usingLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(390,410,45,21) 
			   label: _(@"Using:") ];
  [usingLabel setAutoresizingMask: NSViewMinXMargin|NSViewMaxXMargin|NSViewMinYMargin];
  RETAIN(usingLabel);
  
  transportMethodPopUpButton = [[NSPopUpButton alloc] initWithFrame: NSMakeRect(440,410,190,ButtonHeight)];
  [transportMethodPopUpButton setAutoenablesItems: NO];
  [transportMethodPopUpButton setAutoresizingMask: NSViewMinXMargin|NSViewMinYMargin|NSViewWidthSizable];
  [transportMethodPopUpButton addItemWithTitle: @"smtp.server.com"];

  // To 
  toLabel = [LabelWidget labelWidgetWithFrame:NSMakeRect(5,385,55,21) 
			 label: _(@"To:") ];
  [toLabel setAutoresizingMask: NSViewMinYMargin];
  RETAIN(toLabel);

  toText = [[NSTextField alloc] initWithFrame:NSMakeRect(65,385,565,21)];
  [toText setAutoresizingMask: NSViewMinYMargin|NSViewWidthSizable];
  [toText setDelegate: [self windowController]];
 
  // Cc
  ccLabel = [LabelWidget labelWidgetWithFrame:NSZeroRect
			 label: _(@"Cc:") ];
  [ccLabel setAutoresizingMask: NSViewMinYMargin];
  RETAIN(ccLabel);

  ccText = [[NSTextField alloc] init];
  [ccText setAutoresizingMask: NSViewMinYMargin|NSViewWidthSizable];
  [ccText setDelegate: [self windowController]];

  // Bcc
  bccLabel = [LabelWidget labelWidgetWithFrame:NSZeroRect
			  label: _(@"Bcc:") ];
  [bccLabel setAutoresizingMask: NSViewMinYMargin];
  RETAIN(bccLabel);

  bccText = [[NSTextField alloc] init];
  [bccText setAutoresizingMask: NSViewMinYMargin|NSViewWidthSizable];
  [bccText setDelegate: [self windowController]];

  // Subject
  subjectLabel = [LabelWidget labelWidgetWithFrame:NSZeroRect
			      label: _(@"Subject:") ];
  [subjectLabel setAutoresizingMask: NSViewMinYMargin];
  RETAIN(subjectLabel);

  subjectText = [[NSTextField alloc] init];
  [subjectText setAutoresizingMask: NSViewMinYMargin|NSViewWidthSizable];
  [subjectText setDelegate: [self windowController]];

  // Scrollview and text view
  scrollView = [[NSScrollView alloc] initWithFrame: NSMakeRect(5,5,640,335)];
  [scrollView setHasHorizontalScroller: NO];
  [scrollView setHasVerticalScroller: YES];
  [scrollView setAutoresizingMask: NSViewHeightSizable | NSViewWidthSizable];
  [[scrollView contentView] setAutoresizingMask: NSViewHeightSizable | NSViewWidthSizable];
  [[scrollView contentView] setAutoresizesSubviews:YES];
  
  textView = [[NSTextView alloc] initWithFrame: [[scrollView contentView] frame]];
  [textView setDelegate: [self windowController]];
  [textView setTextContainerInset: NSMakeSize(5,5)];
  [textView setBackgroundColor: [NSColor whiteColor]];
  [textView setRichText: YES];
  [textView setUsesFontPanel: YES];
  [textView setHorizontallyResizable: NO];
  [textView setVerticallyResizable: YES];
  [textView setMinSize: NSMakeSize (0, 0)];
  [textView setMaxSize: NSMakeSize (1E7, 1E7)];
  [textView setAutoresizingMask: NSViewHeightSizable | NSViewWidthSizable];
  [[textView textContainer] setContainerSize: NSMakeSize([[scrollView contentView] frame].size.width, 
  							 1E7)];
  [[textView textContainer] setWidthTracksTextView: YES];
  [textView setEditable: YES];
  [textView setString: @""];

  [subjectText setNextKeyView: textView];

  [scrollView setDocumentView: textView];
  
  // We add our UI elemnts
  [[self contentView] addSubview: fromLabel];
  [[self contentView] addSubview: personalProfilePopUpButton];
  [[self contentView] addSubview: usingLabel];
  [[self contentView] addSubview: transportMethodPopUpButton];

  [[self contentView] addSubview: toLabel];
  [[self contentView] addSubview: toText];

  [[self contentView] addSubview: subjectLabel];
  [[self contentView] addSubview: subjectText];

  [[self contentView] addSubview: scrollView];
}

//
//
//
- (NSTextField *) subjectText
{
  return subjectText;
}

//
//
//
- (NSTextField *) toText
{
  return toText;
}


//
//
//
- (NSTextField *) ccText
{
  return ccText;
}

//
//
//
- (NSTextField *) bccText
{
  return bccText;
}


//
//
//
- (LabelWidget *) subjectLabel
{
  return subjectLabel;
}

//
//
//
- (LabelWidget *) toLabel
{
  return toLabel;
}


//
//
//
- (LabelWidget *) ccLabel
{
  return ccLabel;
}


//
//
//
- (LabelWidget *) bccLabel
{
  return bccLabel;
}


//
//
//
- (LabelWidget *) fromLabel
{
  return fromLabel;
}

- (LabelWidget *) usingLabel
{
  return usingLabel;
}

//
//
//
- (NSScrollView *) scrollView
{
  return scrollView;
}


//
//
//
- (NSTextView *) textView
{
  return textView;
}


//
//
//
- (NSButton *) icon
{
  return icon;
}


- (NSButton *) send
{
  return send;
}

- (NSButton *) insert
{
  return insert;
}

//
//
//
- (NSButton *) addBcc
{
  return addBcc;
}


//
//
//
- (NSButton *) addCc
{
  return addCc;
}


- (NSButton *) addresses
{
  return addresses;
}

- (NSButton *) cancel
{
  return cancel;
}

//
//
//
- (NSPopUpButton *) personalProfilePopUpButton
{
  return personalProfilePopUpButton;
}


//
//
//
- (NSPopUpButton *) transportMethodPopUpButton
{
  return transportMethodPopUpButton;
}

@end


