/*
**  FindWindow.h
**
**  Copyright (c) 2001
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <AppKit/AppKit.h>
#import "LabelWidget.h"

@interface FindWindow: NSPanel
{
  NSTextField *findField;
  NSTextField *replaceWithField;
  LabelWidget *foundLabel;
  NSMatrix *matrix;
  NSButton *ignoreCaseButton;
  NSButton *regularExpressionButton;
}

- (void) dealloc;

- (void) layoutWindow;

//
// access/mutation methods
//

- (NSTextField *) findField;
- (NSTextField *) replaceWithField;
- (NSButton *) ignoreCaseButton;
- (NSButton *) regularExpressionButton;
- (LabelWidget *) foundLabel;
- (NSMatrix *) matrix;

@end

