/*
**  MailboxManager.m
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#import "MailboxManager.h"

#import "GNUMail.h"
#import "GNUMailConstants.h"
#import "LabelWidget.h"

#import <Pantomime/LocalStore.h>

@implementation MailboxManager

- (void) layoutWindow
{
  NSButton *open, *create, *delete, *close, *rename;
  NSScrollView *scrollView;
  LabelWidget *label;

  open = [[NSButton alloc] initWithFrame: NSMakeRect(5,388,40,40)];
  [open setButtonType: NSMomentaryPushButton];
  [open setTitle:@""];
  [open setTarget: [self windowController]];
  [open setAction: @selector(open:)];
  [open setImagePosition: NSImageOnly];
  [open setImage:[NSImage imageNamed: @"MailIcon_box_open.tiff"]];
  [open setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview:open];
  RELEASE(open);
   
  create = [[NSButton alloc] initWithFrame: NSMakeRect(50,388,40,40)];
  [create setButtonType: NSMomentaryPushButton];
  [create setTitle:@""];
  [create setTarget: [self windowController]];
  [create setAction: @selector(create:)];
  [create setImagePosition: NSImageOnly];
  [create setImage:[NSImage imageNamed: @"MailIcon_box_add.tiff"]];
  [create setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview:create];
  RELEASE(create);

  delete = [[NSButton alloc] initWithFrame: NSMakeRect(95,388,40,40)];
  [delete setButtonType: NSMomentaryPushButton];
  [delete setTitle:@""];
  [delete setTarget: [self windowController]];
  [delete setAction: @selector(delete:)];
  [delete setImagePosition: NSImageOnly];
  [delete setImage:[NSImage imageNamed: @"MailIcon_box_delete.tiff"]];
  [delete setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview:delete];
  RELEASE(delete);
  
  rename = [[NSButton alloc] initWithFrame: NSMakeRect(140,388,40,40)];
  [rename setButtonType: NSMomentaryPushButton];
  [rename setTitle:@""];
  [rename setTarget: [self windowController]];
  [rename setAction: @selector(rename:)];
  [rename setImagePosition: NSImageOnly];
  [rename setImage:[NSImage imageNamed: @"MailIcon_box_rename.tiff"]];
  [rename setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview:rename];
  RELEASE(rename);

  transfer = [[NSPopUpButton alloc] initWithFrame: NSMakeRect(5,350,70,ButtonHeight)];
  [transfer addItemWithTitle: _(@"Move")];
  [transfer addItemWithTitle: _(@"Copy")];
  [transfer setTarget: [self windowController]];
  [transfer setAction: @selector(transfer:)];
  [transfer setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview:transfer];

  label = [LabelWidget labelWidgetWithFrame: NSMakeRect(80,350,130,TextFieldHeight)
		       label: _(@"the selected message")];
  [label setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview: label];

  openOnStartup = [[NSButton alloc] initWithFrame: NSMakeRect(220,350,175,ButtonHeight)];
  [openOnStartup setButtonType: NSSwitchButton];
  [openOnStartup setBordered: NO];
  [openOnStartup setTitle: _(@"Open this folder on startup")];
  [openOnStartup setTarget: [self windowController]];
  [openOnStartup setAction: @selector(openOnStartupClicked:)];
  [openOnStartup setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview: openOnStartup];

  mailboxColumn = [[NSTableColumn alloc] initWithIdentifier: @"Mailbox"];
  [mailboxColumn setEditable: NO];
  [[mailboxColumn headerCell] setStringValue: _(@"Mailbox")];
  [mailboxColumn setMinWidth: 200];
  
  sizeColumn = [[NSTableColumn alloc] initWithIdentifier: @"Size"];
  [sizeColumn setEditable: NO];
  [[sizeColumn headerCell] setStringValue: _(@"Size")];
  [sizeColumn setMinWidth: 50];

  messagesColumn = [[NSTableColumn alloc] initWithIdentifier: @"Messages"];
  [messagesColumn setEditable: NO];
  [[messagesColumn headerCell] setStringValue: _(@"Messages")];
  [messagesColumn setMinWidth: 100];
  
  outlineView = [[NSOutlineView alloc] initWithFrame: NSMakeRect (0, 40, 400, 300)];
  [outlineView addTableColumn: mailboxColumn];
  [outlineView addTableColumn: sizeColumn];
  [outlineView addTableColumn: messagesColumn];
  [outlineView setOutlineTableColumn: mailboxColumn];
  [outlineView setDrawsGrid: NO];
  [outlineView setIndentationPerLevel: 10];
  [outlineView setAutoresizesOutlineColumn: YES];
  [outlineView setIndentationMarkerFollowsCell: YES];
  [outlineView setDataSource: [self windowController]];
  [outlineView setDelegate: [self windowController]];
  [outlineView setDoubleAction: @selector(open:)];

  scrollView = [[NSScrollView alloc] initWithFrame: NSMakeRect (0, 40, 400, 300)];
  [scrollView setDocumentView: outlineView];
  [scrollView setHasHorizontalScroller: YES];
  [scrollView setHasVerticalScroller: YES];
  [scrollView setBorderType: NSBezelBorder];
  [scrollView setAutoresizingMask: NSViewWidthSizable|NSViewHeightSizable];

  [[self contentView] addSubview: scrollView];
  
  close = [[NSButton alloc] initWithFrame: NSMakeRect(335,7,60,ButtonHeight)];
  [close setButtonType: NSMomentaryPushButton];
  [close setTitle: _(@"Close")];
  [close setTarget: self];
  [close setAction: @selector(close)];
  [close setAutoresizingMask: NSViewMinXMargin|NSViewMaxYMargin];
  [[self contentView] addSubview:close];
  RELEASE(close);

  [self setMinSize: NSMakeSize(250,250)];
}


//
//
//
- (void) dealloc
{
  NSLog(@"MailboxManager: -dealloc");

  RELEASE(mailboxColumn);
  RELEASE(sizeColumn);
  RELEASE(messagesColumn);
  
  RELEASE(outlineView);

  RELEASE(transfer);
  RELEASE(openOnStartup);

  [super dealloc];
}


//
// access/mutation methods
//
- (NSPopUpButton *) transfer
{
  return transfer;
}

- (NSOutlineView *) outlineView
{
  return outlineView;
}

- (NSButton *) openOnStartup
{
  return openOnStartup;
}

@end
