/*
**  PreferencesWindow.m
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#import "PreferencesWindow.h"

#import "GNUMailConstants.h"

@implementation PreferencesWindow

//
//
//
- (void) layoutWindow
{
  NSScrollView *mScrollView;
  NSButton *ok, *apply, *cancel;
  NSButtonCell *cell;

  box = [[NSBox alloc] initWithFrame: NSMakeRect(8,41,455,380)];
  [box setTitlePosition: NSAtTop];
  [box setBorderType: NSGrooveBorder];
  
  [[self contentView] addSubview: box];  
  
  cell = [[NSButtonCell alloc] init];
  AUTORELEASE(cell);
  [cell setButtonType: NSPushOnPushOffButton];
  [cell setImagePosition: NSImageAbove];
  
  matrix = [[NSMatrix alloc] initWithFrame: NSMakeRect(8,426,455,86)
			     mode: NSRadioModeMatrix
			     prototype: cell
			     numberOfRows: 1
			     numberOfColumns: 8];
  [matrix setTarget: [self windowController]];
  [matrix setCellSize: NSMakeSize(64,64)];
  [matrix setAction: @selector(handleCellAction:)];
  
  mScrollView = [[NSScrollView alloc] initWithFrame:NSMakeRect(8,426,455,86)];

  [mScrollView setHasHorizontalScroller: YES];
  [mScrollView setHasVerticalScroller: NO];
  [mScrollView setDocumentView: matrix];  
  [[self contentView] addSubview: mScrollView];
  RELEASE(mScrollView);

  /* We create the buttons */
  apply = [[NSButton alloc] initWithFrame:NSMakeRect(223,8,80,ButtonHeight)];
  AUTORELEASE(apply);
  [apply setTitle: _(@"Apply")];
  [apply setTarget: [self windowController]];
  [apply setAction: @selector(savePreferences:)];
  [[self contentView] addSubview: apply];
  
  cancel = [[NSButton alloc] initWithFrame:NSMakeRect(313,8,80,ButtonHeight)];
  AUTORELEASE(cancel);
  [cancel setTitle: _(@"Cancel")];
  [cancel setTarget: [self windowController]];
  [cancel setAction: @selector(cancelClicked:)];
  [[self contentView] addSubview:  cancel];
  
  ok = [[NSButton alloc] initWithFrame:NSMakeRect(403,8,60,ButtonHeight)];
  AUTORELEASE(ok);
  [ok setButtonType: NSMomentaryPushButton];
  [ok setKeyEquivalent: @"\r"];
  [ok setImagePosition: NSImageRight];
  [ok setImage: [NSImage imageNamed: @"common_ret"]];
  [ok setAlternateImage: [NSImage imageNamed: @"common_retH"]];
  [ok setTitle: _(@"OK")];
  [ok setTarget: [self windowController]];
  [ok setAction: @selector(saveAndClose:)];
  [[self contentView] addSubview: ok];
}


//
//
//
- (void) dealloc
{
  NSLog(@"PreferencesWindow: -dealloc");

  RELEASE(box);
  RELEASE(matrix);

  [super dealloc];
}


//
// access/mutation methods
//

- (NSMatrix *) matrix
{
  return matrix;
}

- (NSBox *) box
{
  return box;
}

@end
