/*
**  Utilities.m
**
**  Copyright (c) 2001, 2002
**
**  Jonathan B. Leffert <jonathan@leffert.net>
**  Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <AppKit/AppKit.h>

@class Address;
@class Message;
@class MimeBodyPart;
@class MimeMultipart;
@class MimeTypeManager;
@class NSView;
@class Part;

@interface Utilities: NSObject
{
}

+ (void) appendAddress: (Address *) theAddress
           toTextField: (NSTextField *) theTextField;

+ (NSAttributedString *) attributedStringFromContentForPart: (Part *) thePart
                                            mimeTypeManager: (MimeTypeManager *) theMimeTypeManager;

+ (NSAttributedString *) attributedStringFromHeadersForMessage: (Message *) theMessage
                                                showAllHeaders: (BOOL) aBOOL;

+ (NSAttributedString *) attributedStringWithString: (NSString *) theString
                                         attributes: (NSDictionary *) theAttributes;


+ (NSAttributedString *) bestRepresentationFromMultipartAlternative: (MimeMultipart *) theMimeMultipart;

+ (NSAttributedString *) bestRepresentationFromMultipartAppleDouble: (MimeMultipart *) theMimeMultipart
                                                    mimeTypeManager: (MimeTypeManager *) theMimeTypeManager;


+ (NSAttributedString *) formattedAttributedStringFromAttributedString: (NSAttributedString *) theAttributedString;


+ (NSString *) stringFromRecipients: (NSArray *) allRecipients
                               type: (int) recipientType;

+ (int) xCoordOfViewAfter: (NSView *) theView
		withSpace: (int) pixels;

+ (int) yCoordOfViewBelow: (NSView *) theView
		withSpace: (int) pixels
	       viewHeight: (int) height;

+ (NSRect) rectForEditWindow;
+ (NSRect) rectForMailWindow;

+ (void) saveRect: (NSRect) theRect
    forWindowName: (NSString *) theName;

+ (NSString *) encryptPassword: (NSString *) thePassword
                       withKey: (NSString *) theKey;
+ (NSString *) decryptPassword: (NSString *) thePassword
                       withKey: (NSString *) theKey;

+ (void) loadPersonalProfilesInPopUpButton: (NSPopUpButton *) thePopUpButton;

+ (void) loadTransportMethodsInPopUpButton: (NSPopUpButton *) thePopUpButton;

+ (NSString *) profileNameForItemTitle: (NSString *) theString;

+ (id) windowForFolderName: (NSString *) theName;

@end

NSString *GNUMailUserLibraryPath();
