/*
**  MailHeaderCell.h
**
**  Copyright (c) 2002, 2003
**
**  Author: Nicolas Roard <nicolas@roard.com>
**          Ludovic Marcotte <ludovic@Sophos.ca>
**          Francis Lachapelle <francis@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _GNUMail_H_MailHeaderCell
#define _GNUMail_H_MailHeaderCell

#import <AppKit/AppKit.h>

//
//
//
@interface NSBezierPath (RoundRect)
     
- (void) appendBezierPathWithRoundedRectangle: (NSRect) aRect
                                   withRadius: (float) radius;

@end


//
//
//
@interface MailHeaderCell : NSTextAttachmentCell
{
  NSAttributedString *originalAttributedString;
  NSColor *color;
  
  NSMutableArray *allViews;

  float width;
}

//
// access / mutation methods
//
- (float) height;
- (float) width;
- (void) resize: (id) sender;
- (void) setWidth: (float) theWidth;


//
// other methods
//
- (void) addView: (id) theView;
- (BOOL) containsView: (id) theView;

@end


//
// Private interface
//
@interface MailHeaderCell (Private)

- (NSAttributedString *) _fold;

@end

#endif // _GNUMail_H_MailHeaderCell
