/**
 * Copyright (C) 2010 by Gerardo Orellana <goaccess@prosoftcorp.com>
 * GoAccess - An ncurses apache weblog analyzer & interactive viewer
 * @version 0.1.2
 * Last Modified: Saturday, July 10, 2010
 * Path:  /parser.h
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * GoAccess is released under the GNU/GPL License.
 * Copy of the GNU General Public License is attached to this source 
 * distribution for its full text.
 *
 * Visit http://goaccess.prosoftcorp.com for new releases.
 */

#ifndef PARSER_H_INCLUDED
#define PARSER_H_INCLUDED

#ifndef COMMONS 
#include "commons.h"
#endif

int struct_cmp_by_hits(const void *a, const void *b);

int struct_cmp(const void *a, const void *b);

int parse_log(struct logger *logger, char *filename);

void generate_unique_visitors(WINDOW *main_win, struct stu_alloc_holder **sorted_alloc_holder, 
							  struct stu_alloc_all **sorted_alloc_all, struct logger *logger);

void generate_struct_data(GHashTable *hash_table, struct stu_alloc_holder **sorted_alloc_holder, 
						  struct stu_alloc_all **sorted_alloc_all, struct logger *logger, int module);

#endif
