/* alarm.c */

#include "main.h"
#include "goat.h"
#include "alarm.h"


/*************************************
  Function to create set alarm dialog
**************************************/

extern GtkWidget *set_alarm_dialog, *notify_menu, *date_menu, *ok_button,
          *cancel_button, *alarm_checkbutton, *message_entry,
          *sound_checkbutton, *date_edit, *sound_file_select, *sound_entry,
          *label3, *alarm_pixmap, *file_selector;
extern gchar *pixmapdir;
extern gboolean ampm;
extern Goat *alarm_active_goat;

void
alarm_dialog_create()
{
  GtkWidget *menuitem, *notify_menu_menu;
  GtkWidget *vbox2;
  GtkWidget *table1;
  GtkWidget *vbox3;
  GtkWidget *hseparator1;
  GtkWidget *hbox3;
  GtkWidget *hbox2;
  GtkWidget *hbox1, *date_menu_menu;
  gchar *fname;

  /* just create the whole setting an alarm dialog box */

  set_alarm_dialog = gtk_window_new (GTK_WINDOW_DIALOG);

  gtk_window_set_title (GTK_WINDOW (set_alarm_dialog), _("Set Alarm"));
  gtk_widget_realize(set_alarm_dialog);
  gdk_window_set_decorations(set_alarm_dialog->window,GDK_DECOR_ALL);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox2);
  gtk_container_add (GTK_CONTAINER (set_alarm_dialog), vbox2);

  table1 = gtk_table_new (4, 2, FALSE);
  gtk_widget_show (table1);
  gtk_box_pack_start (GTK_BOX (vbox2), table1, TRUE, TRUE, 0);

  hbox2 = gtk_hbox_new(FALSE,0);
  gtk_widget_show(hbox2);
  gtk_table_attach (GTK_TABLE (table1), hbox2, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 5, 5);


  sound_entry = gtk_entry_new(); 
  gtk_widget_show (sound_entry);
  gtk_box_pack_start(GTK_BOX(hbox2), sound_entry, TRUE, TRUE, 0);

  sound_file_select = gtk_button_new_with_label(_("Select File"));
  gtk_widget_show(sound_file_select);
  gtk_box_pack_start(GTK_BOX(hbox2), sound_file_select, TRUE, TRUE, 0);

  sound_checkbutton = gtk_check_button_new_with_label (_("Play sound"));
  gtk_widget_show (sound_checkbutton);
  gtk_table_attach (GTK_TABLE (table1), sound_checkbutton, 0, 1, 3, 4,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 5, 5);

  notify_menu = gtk_option_menu_new ();
  gtk_widget_show (notify_menu);
  gtk_table_attach (GTK_TABLE (table1), notify_menu, 0, 1, 2, 3,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 5, 5);
  notify_menu_menu = gtk_menu_new ();
  menuitem = gtk_menu_item_new_with_label (_("Pop up the note"));
  gtk_widget_show (menuitem);
  gtk_menu_append (GTK_MENU (notify_menu_menu), menuitem);
  menuitem = gtk_menu_item_new_with_label (_("Display a message"));
  gtk_widget_show (menuitem);
  gtk_menu_append (GTK_MENU (notify_menu_menu), menuitem);
  gtk_option_menu_set_menu (GTK_OPTION_MENU (notify_menu), notify_menu_menu);
  gtk_option_menu_set_history (GTK_OPTION_MENU (notify_menu), 1);

  message_entry = gtk_entry_new_with_max_length(40);
  gtk_widget_show (message_entry);
  gtk_table_attach (GTK_TABLE (table1), message_entry, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 5, 5);
  gtk_entry_set_text(GTK_ENTRY(message_entry), _("Alarm triggered!"));

  label3 = gtk_label_new (_("Remind me at..."));
  gtk_widget_show (label3);
  gtk_table_attach (GTK_TABLE (table1), label3, 0, 1, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 5, 5);

  hbox1 = gtk_hbox_new(FALSE,0);
  gtk_widget_show(hbox1);
  gtk_table_attach (GTK_TABLE (table1), hbox1, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 5, 5);

  date_edit = gnome_date_edit_new ((time_t) 0, TRUE, ampm);;
  gtk_widget_show (date_edit);
  gtk_box_pack_start(GTK_BOX(hbox1), date_edit, TRUE, TRUE, 0);

  date_menu = gtk_option_menu_new ();
  gtk_widget_show (date_menu);
  gtk_box_pack_start (GTK_BOX (hbox1), date_menu, TRUE, TRUE, 5);
  date_menu_menu = gtk_menu_new ();
  menuitem = gtk_menu_item_new_with_label (_("Just once"));
  gtk_widget_show (menuitem);
  gtk_menu_append (GTK_MENU (date_menu_menu), menuitem);
  menuitem = gtk_menu_item_new_with_label (_("Every day"));
  gtk_widget_show (menuitem);
  gtk_menu_append (GTK_MENU (date_menu_menu), menuitem);
  menuitem = gtk_menu_item_new_with_label (_("Every week"));
  gtk_widget_show (menuitem);
  gtk_menu_append (GTK_MENU (date_menu_menu), menuitem);
  menuitem = gtk_menu_item_new_with_label (_("Every month"));
  gtk_widget_show (menuitem);
  gtk_menu_append (GTK_MENU (date_menu_menu), menuitem);
  menuitem = gtk_menu_item_new_with_label (_("Every year"));
  gtk_widget_show (menuitem);
  gtk_menu_append (GTK_MENU (date_menu_menu), menuitem);

  gtk_option_menu_set_menu (GTK_OPTION_MENU (date_menu), date_menu_menu);

  fname = g_strdup_printf("%s%s",pixmapdir,"alarm.png");
  alarm_pixmap = gnome_pixmap_new_from_file(fname);
  g_free(fname);

  gtk_widget_show (alarm_pixmap);
  gtk_table_attach (GTK_TABLE (table1), alarm_pixmap, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 5, 5);


  alarm_checkbutton = gtk_check_button_new_with_label (_("alarm on?"));  
  gtk_widget_show (alarm_checkbutton);
  gtk_table_attach (GTK_TABLE (table1), alarm_checkbutton, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 5, 5);

  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox3);
  gtk_box_pack_start (GTK_BOX (vbox2), vbox3, TRUE, TRUE, 0);

  hseparator1 = gtk_hseparator_new ();
  gtk_widget_show (hseparator1);
  gtk_box_pack_start (GTK_BOX (vbox3), hseparator1, TRUE, TRUE, 5);

  hbox3 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox3);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox3, TRUE, TRUE, 5);

  ok_button = gnome_stock_button (GNOME_STOCK_BUTTON_OK);
  gtk_widget_show (ok_button);
  gtk_box_pack_start (GTK_BOX (hbox3), ok_button, TRUE, FALSE, 5);
  gtk_widget_set_usize (ok_button, 90, -2);

  cancel_button = gnome_stock_button (GNOME_STOCK_BUTTON_CANCEL);
  gtk_widget_show (cancel_button);
  gtk_box_pack_start (GTK_BOX (hbox3), cancel_button, TRUE, FALSE, 5);
  gtk_widget_set_usize (cancel_button, 90, -2);

  gtk_widget_show(set_alarm_dialog);
} 

void 
alarm_set(GtkWidget *widget, Goat **goat)
{
  GtkWidget *notify_menu_menu;

  g_assert((*goat) != NULL);
  alarm_active_goat = *goat;

  alarm_dialog_create();

  notify_menu_menu = gtk_option_menu_get_menu(GTK_OPTION_MENU(notify_menu));

  gtk_entry_set_text(GTK_ENTRY(message_entry),((*goat))->message);

  if ((*goat)->alarm_time == 0) {
    gnome_date_edit_set_time(GNOME_DATE_EDIT(date_edit),
                             time(NULL));
  }
  else {
    gnome_date_edit_set_time(GNOME_DATE_EDIT(date_edit),
                             (*goat)->alarm_time);
  }

  if ((*goat)->alarm) {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(alarm_checkbutton),
				 TRUE);
  }
  else {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(alarm_checkbutton),
				 FALSE);
  }

  if((*goat)->notify_message) {
    gtk_option_menu_set_history(GTK_OPTION_MENU(notify_menu),1);
  }
  else {
    gtk_option_menu_set_history(GTK_OPTION_MENU(notify_menu),0);
  }
    
  gtk_option_menu_set_history(GTK_OPTION_MENU(date_menu),(*goat)->alarm_repeat); 

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(sound_checkbutton),
                                                 (*goat)->play_sound);
  gtk_entry_set_text(GTK_ENTRY(sound_entry),(*goat)->sound_filename);      

  /* 'grey out' unwanted fiels.. */

  alarm_dialog_update(NULL, (*goat));

  gtk_signal_connect(GTK_OBJECT(notify_menu_menu), 
                     "selection_done",
                     GTK_SIGNAL_FUNC (alarm_notify_menu_changed), NULL);

  gtk_signal_connect(GTK_OBJECT(ok_button), "clicked",
                     GTK_SIGNAL_FUNC (alarm_ok_clicked), (*goat));

  gtk_signal_connect(GTK_OBJECT(cancel_button), "clicked",
                     GTK_SIGNAL_FUNC (alarm_cancel_clicked), (*goat));

  gtk_signal_connect(GTK_OBJECT(alarm_checkbutton), "toggled",
                     GTK_SIGNAL_FUNC (alarm_dialog_update), (*goat));

  gtk_signal_connect(GTK_OBJECT(sound_checkbutton), "toggled",
                     GTK_SIGNAL_FUNC (alarm_dialog_update), (*goat));

  gtk_signal_connect(GTK_OBJECT(sound_file_select), "clicked",
                     GTK_SIGNAL_FUNC (alarm_sound_select_file), (*goat));

  gtk_signal_connect(GTK_OBJECT(set_alarm_dialog), "destroy",
                     GTK_SIGNAL_FUNC (alarm_dialog_destroyed), (*goat));

  gtk_grab_add(set_alarm_dialog);
}

void 
alarm_ok_clicked(GtkWidget *widget, Goat *goat)
{
  GtkWidget *label;
  gchar *message, *text, *sound_filename;

  /* get the info about the alarm and put it into the goat struc */

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(alarm_checkbutton))) {

    if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(sound_checkbutton))) {
      goat->play_sound = TRUE;
      sound_filename = gtk_entry_get_text(GTK_ENTRY(sound_entry));
      goat->sound_filename = g_strdup_printf("%s",sound_filename);
    }
    else {
      goat->play_sound = FALSE;
    }

    label = GTK_BIN(notify_menu)->child;
    g_assert(label!=NULL);
    gtk_label_get (GTK_LABEL(label), &text);

    if (strcmp(text,_("Display a message")) == FALSE) {
      goat->notify_message = TRUE;
      message = gtk_entry_get_text(GTK_ENTRY(message_entry));
      goat->message = g_strdup_printf("%s",message);
    }
    else {
      goat->notify_message = FALSE;
    }
        
    label = GTK_BIN(date_menu)->child;
    g_assert(label!=NULL);
    gtk_label_get (GTK_LABEL(label), &text);


    if (strcmp(text,_("Just once")) == FALSE) goat->alarm_repeat = 0;
    if (strcmp(text,_("Every day")) == FALSE) goat->alarm_repeat = 1;
    if (strcmp(text,_("Every week")) == FALSE) goat->alarm_repeat = 2;
    if (strcmp(text,_("Every month")) == FALSE) goat->alarm_repeat = 3;
    if (strcmp(text,_("Every year")) == FALSE) goat->alarm_repeat = 4;

    goat->alarm_time = gnome_date_edit_get_date(GNOME_DATE_EDIT(date_edit));
    goat->alarm = TRUE;
  }
  else {
    goat->alarm = FALSE;
  }
  
  gtk_grab_remove(set_alarm_dialog);
  gtk_widget_destroy(set_alarm_dialog);
}

void 
alarm_cancel_clicked(GtkWidget *widget, Goat *goat)
{
  gtk_grab_remove(set_alarm_dialog);
  gtk_widget_destroy(set_alarm_dialog);
}

void
alarm_checkbutton_toggled()
{
  /* greys out fields that aren't required */
  
  if(!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(alarm_checkbutton))) {
    gtk_widget_set_sensitive(message_entry, FALSE);
    gtk_widget_set_sensitive(date_edit, FALSE);
    gtk_widget_set_sensitive(sound_checkbutton, FALSE);
    gtk_widget_set_sensitive(sound_entry, FALSE);
    gtk_widget_set_sensitive(sound_file_select, FALSE);;
    gtk_widget_set_sensitive(notify_menu, FALSE);
    gtk_widget_set_sensitive(label3, FALSE);
    gtk_widget_set_sensitive(date_menu, FALSE);
  }
  else {
    gtk_widget_set_sensitive(date_edit, TRUE);
    gtk_widget_set_sensitive(sound_checkbutton, TRUE);
    gtk_widget_set_sensitive(notify_menu, TRUE);
    gtk_widget_set_sensitive(label3, TRUE);
    gtk_widget_set_sensitive(date_menu, TRUE);
  }
}

void
alarm_sound_checkbutton_toggled()
{
  /* greys out fields that aren't required */

  if(!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(sound_checkbutton))) {
    gtk_widget_set_sensitive(sound_entry, FALSE);
    gtk_widget_set_sensitive(sound_file_select, FALSE);
  }
  else {
    gtk_widget_set_sensitive(sound_entry, TRUE);
    gtk_widget_set_sensitive(sound_file_select, TRUE);
  }
}

void
alarm_notify_menu_changed()
{  
  GtkWidget *label;
  gchar *text;

  /*greys/ungreys the message entry */

  label = GTK_BIN(notify_menu)->child;
  gtk_label_get (GTK_LABEL(label), &text);

  if (strcmp(text,_("Display a message")) == FALSE) {
    gtk_widget_set_sensitive(message_entry, TRUE);
  }
  else {
    gtk_widget_set_sensitive(message_entry, FALSE);
  }
}

void
alarm_dialog_update(GtkWidget *widget, Goat *goat)
{
  alarm_notify_menu_changed();
  alarm_sound_checkbutton_toggled();
  alarm_checkbutton_toggled();
}

void 
alarm_sound_select_file(GtkWidget *widget, Goat *goat)
{
  gtk_grab_remove(set_alarm_dialog);
  main_create_file_selector(sound_entry);
  gtk_grab_add(file_selector);
}

void
alarm_dialog_destroyed(GtkWidget *widget, Goat *goat)
{
  alarm_active_goat = NULL;
}
