typedef struct _Goat
{
  GtkWidget *note;
  GtkWidget *eventbox1;
  GtkWidget *eventbox2;
  GtkWidget *eventbox3;
  GtkWidget *eventbox4;
  GtkWidget *content;
  GtkWidget *cross;
  GdkFont *font;
  GdkColor *fg;
  GdkColor *bg;
  GdkColor *bg_topbar;
  GtkStyle *style;
  GtkStyle *styletop;
  gchar *font_name;
  gboolean dragging;
  gint height;
  gint width;
  gchar *message;
  gboolean alarm;
  time_t alarm_time;
  gboolean notify_message;
  gint x;
  gint y;
  gboolean lowered;
  gboolean play_sound;
  gchar *sound_filename;
  gint colour;
  gboolean sticky;
  gboolean floating;
  gboolean shaded;
  gint alarm_repeat;
  GtkWidget *title;
  gboolean hidden;
  gboolean changed;
  struct _Goat *next;
} Goat;

void goat_create (gint x,gint y, gint height, gint width,
                  gchar *message, gboolean alarm, time_t alarm_time,
                  gboolean notify_message, gboolean play_sound,
                  gchar *sound_filename, gchar *text, gint colour,
                  gchar *font_name, gboolean lowered, gboolean sticky,
                  gboolean floating, gboolean shaded, gint alarm_repeat,
                  gchar *title, gboolean hidden);
void goat_note_real(GtkWidget *widget, Goat *goat);
void goat_note_realize(GtkWidget *widget, Goat *goat);
void goat_content_realize(GtkWidget *widget, Goat *goat);
void goat_eventbox1_realize(GtkWidget *widget, Goat *goat);
void goat_eventbox2_realize(GtkWidget *widget, Goat *goat);
void goat_eventbox3_realize(GtkWidget *widget, Goat *goat);
gint
goat_topbar_pressed (GtkWidget *widget, GdkEventButton *event, Goat *goat);
gint
goat_button_released (GtkWidget *widget, GdkEventButton *event, Goat *goat);
gint
goat_mouse_moved (GtkWidget *widget, GdkEventMotion *event, Goat *goat);
gint 
goat_cross_pressed(GtkWidget *widget, GdkEventButton *event, Goat *goat);
gint
goat_resize_pressed(GtkWidget *widget, GdkEventButton *event, Goat *goat);
gint
goat_key_pressed(GtkWidget *widget, GdkEventKey *event, Goat *goat);
gint
goat_selection_insert(GtkWidget *widget, GdkEventSelection *event, Goat *goat);

void 
goat_new(GtkWidget *widget);
void
goat_fit_to_text(GtkWidget *widget, Goat **goat);
void
goat_print_text(GtkWidget *widget, Goat **goat);
void
goat_mail_text(GtkWidget *widget, Goat **goat);
void
goat_clear_text(GtkWidget *widget, Goat **goat);
void
goat_set_title(GtkWidget *widget, Goat **goat);
void
goat_insert_time(GtkWidget *widget, Goat **goat);
void
goat_insert_date(GtkWidget *widget, Goat **goat);
void
goat_insert_calendar(GtkWidget *widget, Goat **goat);
void
goat_insert_fortune(GtkWidget *widget, Goat **goat);
void
goat_change_colour(GtkWidget *widget, Goat **goat);
void
goat_change_font(GtkWidget *widget, Goat **goat);
void 
goat_sticky(GtkWidget *widget, Goat **goat);
void
goat_floating(GtkWidget *widget, Goat **goat);
void 
goat_shaded(GtkWidget *widget, Goat **goat);
void
goat_raise(GtkWidget *widget, Goat **goat);
void
goat_lower(GtkWidget *widget, Goat **goat);
void
goat_hide(GtkWidget *widget, Goat **goat);
void
goat_delete(GtkWidget *widget, Goat **goat);

Goat *
goat_check_alarm (Goat *goat);
GTime 
goat_repeat_alarm(gint repeat,GTime thetime);
void 
goat_popup(Goat *goat);
void 
goat_recreate(Goat *goat);
void
goat_play_sound(Goat *goat);

void
goat_show(GtkWidget *widget, Goat **goat);
void
goat_set_size(gint height, gint width, Goat *goat);
void
goat_save(Goat *goat, gchar *section);
void
goat_delete_from_list(Goat *goat);
void
goat_shade(Goat *goat, gboolean shade);
void
goat_change_title(gchar *new_title, Goat *goat);
void
goat_scroll_down(Goat *goat);
void
mail_ok_clicked(GtkWidget *widget, Goat *goat);
gchar *
goat_text_to_temp_file(Goat *goat);
void 
mail_dialog_create(Goat *goat);
void
goat_realloc_pixmap(Goat *goat);

void
goat_unshade_note(GtkWidget *widget, Goat **goat);
void
goat_shade_note(GtkWidget *widget, Goat **goat);
gint 
goat_pointer_left(GtkWidget *widget, GdkEventCrossing *event,
		       Goat *goat);
gint
goat_pointer_enter(GtkWidget *widget, GdkEventProximity *event,
                   Goat *goat);
void
goat_send_ipmsg(GtkWidget *widget, Goat **goat);
void
ipmsg_ok_clicked(GtkWidget *widget, Goat *goat);
void
ipmsg_dialog_create(Goat *goat);
void 
goat_drag_received(GtkWidget *widget, GdkDragContext *context,
                        gint x, gint y, GtkSelectionData *data,
		   guint info, guint time, Goat *goat);
void 
goat_insert_file(Goat *goat, gchar *filename);
