indexing

	description:

		"Eiffel syntax errors"

	library:    "Gobo Eiffel Tools Library"
	author:     "Eric Bezault <ericb@gobosoft.com>"
	copyright:  "Copyright (c) 1999-2000, Eric Bezault and others"
	license:    "Eiffel Forum Freeware License v1 (see forum.txt)"
	date:       "$Date: 2000/11/05 15:06:42 $"
	revision:   "$Revision: 1.2 $"

class ET_SYNTAX_ERROR

inherit

	ET_ERROR

creation

	make

feature {NONE} -- Initialization

	make (a_position: ET_POSITION) is
			-- Create a new Eiffel syntax error at position `a_position'.
		require
			a_position_not_void: a_position /= Void
		do
			!! parameters.make (1, 1)
			parameters.put (a_position.out, 1)
		end

feature -- Access

	default_template: STRING is
			-- Default template used to built the error message
		once
			Result := "Syntax error.%N$1%N"
		end

	code: STRING is
			-- Error code
		once
			Result := "SERR"
		end

invariant

	-- dollar0: $0 = program name
	-- dollar1: $1 = position

end -- class ET_SYNTAX_ERROR
