indexing

	description:

		"Xace mounted libraries"

	library: "Gobo Eiffel Tools Library"
	copyright: "Copyright (c) 2002, Eric Bezault and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/02/07 13:07:53 $"
	revision: "$Revision: 1.2 $"

class ET_XACE_MOUNTED_LIBRARY

creation

	make

feature {NONE} -- Initialization

	make (a_pathname: like pathname; a_library: like library; a_position: like position) is
			-- Create a new mounted library.
		require
			a_pathname_not_void: a_pathname /= Void
			a_library_not_void: a_library /= Void
			a_position_not_void: a_position /= Void
		do
			pathname := a_pathname
			library := a_library
			position := a_position
		ensure
			pathname_set: pathname = a_pathname
			library_set: library = a_library
			position_set: position = a_position
		end

feature -- Status report

	is_root: BOOLEAN
			-- Is current library mounted directly to the top level
			-- system or library?

feature -- Status setting

	set_root (b: BOOLEAN) is
			-- Set `is_root' to `b'.
		do
			is_root := b
		ensure
			root_set: is_root = b
		end

feature -- Access

	pathname: STRING
			-- Name of Xace file containing
			-- the library to be mounted

	library: ET_XACE_LIBRARY
			-- Mounted library

	library_prefix: STRING
			-- Prefix to be applied to the names of the
			-- clusters of the current mounted library

	position: XM_POSITION
			-- Position in Xace file
			-- (needed to report errors)

feature -- Setting

	set_library_prefix (a_prefix: like library_prefix) is
			-- Set `library_prefix' to `a_prefix'.
		do
			library_prefix := a_prefix
		ensure
			library_prefix_set: library_prefix = a_prefix
		end

invariant

	pathname_not_void: pathname /= Void
	library_not_void: library /= Void
	position_not_void: position /= Void

end
