/*
This is a Optical-Character-Recognition program
Copyright (C) 2000-2007  Joerg Schulenburg

   The character codes in this file are Copyright (c) 1991-1999 Unicode, Inc.
   All Rights reserved.

   This file is provided as-is by Unicode, Inc. (The Unicode Consortium).
   No claims are made as to fitness for any particular purpose.  No
   warranties of any kind are expressed or implied.  The recipient
   agrees to determine applicability of information provided.  If this
   file has been provided on optical media by Unicode, Inc., the sole
   remedy for any claim will be exchange of defective media within 90
   days of receipt.

   Unicode, Inc. hereby grants the right to freely use the information
   supplied in this file in the creation of products supporting the
   Unicode Standard, and to make copies of this file in any form for
   internal or external distribution as long as this notice remains
   attached.

For the rest of the file, the following applies:

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 see README for EMAIL-address
 */
 
/*
    Only the codes judged necessary by the developers are present in this
    file. It conforms with MES-1. You'll find also Greek characters, 
    mathematical symbols and some extra symbols.
    
    Use the following regular expression to help add new codes from the
    Unicode data files: ([\w\s]*);([\w\s]*);[^\n]*
*/

#ifndef G_UNICODE_H
#define G_UNICODE_H

#include <stddef.h>

enum format {
	ISO8859_1, TeX, HTML, XML, SGML, UTF8, ASCII
};
typedef enum format FORMAT;

/*
 * Prototypes
 */
wchar_t compose(wchar_t main, wchar_t modifier);
const char *decode(wchar_t c, FORMAT type);

/*
 * Unicode codes
 */

/* E000-F8FF are for private use. We'll reserve E000-E0FF by now. */
/* the next line isnt proper, but was the easiest way to fix a problem */
#ifndef UNKNOWN
#define UNKNOWN								0xE000
#endif
#define PICTURE								0xE001
#define HEADER_FILE							0xE010

/* most codes 0x00-0x1F are not needed, but we provide them anyway. U0000 had
   the name changed from NULL to UNICODE_NULL to avoid conflicts. */
#define UNICODE_NULL							0x0000
#define START_OF_HEADING						0x0001
#define START_OF_TEXT							0x0002
#define END_OF_TEXT							0x0003
#define END_OF_TRANSMISSION						0x0004
#define ENQUIRY								0x0005
#define ACKNOWLEDGE							0x0006
#define BELL								0x0007
#define BACKSPACE							0x0008
#define HORIZONTAL_TABULATION						0x0009
#define LINE_FEED							0x000A
#define VERTICAL_TABULATION						0x000B
#define FORM_FEED							0x000C
#define CARRIAGE_RETURN							0x000D
#define SHIFT_OUT							0x000E
#define SHIFT_IN							0x000F
#define DATA_LINK_ESCAPE						0x0010
#define DEVICE_CONTROL_ONE						0x0011
#define DEVICE_CONTROL_TWO						0x0012
#define DEVICE_CONTROL_THREE						0x0013
#define DEVICE_CONTROL_FOUR						0x0014
#define NEGATIVE_ACKNOWLEDGE						0x0015
#define SYNCHRONOUS_IDLE						0x0016
#define END_OF_TRANSMISSION_BLOCK					0x0017
#define CANCEL								0x0018
#define END_OF_MEDIUM							0x0019
#define SUBSTITUTE							0x001A
#define ESCAPE								0x001B
#define FILE_SEPARATOR							0x001C
#define GROUP_SEPARATOR							0x001D
#define RECORD_SEPARATOR						0x001E
#define UNIT_SEPARATOR							0x001F

/* ASCII */
#define SPACE								0x0020
#define EXCLAMATION_MARK						0x0021
#define QUOTATION_MARK							0x0022
#define NUMBER_SIGN							0x0023
#define DOLLAR_SIGN							0x0024
#define PERCENT_SIGN							0x0025
#define AMPERSAND							0x0026
#define APOSTROPHE							0x0027
#define LEFT_PARENTHESIS						0x0028
#define RIGHT_PARENTHESIS						0x0029
#define ASTERISK							0x002A
#define PLUS_SIGN							0x002B
#define COMMA								0x002C
#define HYPHEN_MINUS							0x002D
#define FULL_STOP							0x002E
#define SOLIDUS								0x002F
#define DIGIT_ZERO							0x0030
#define DIGIT_ONE							0x0031
#define DIGIT_TWO							0x0032
#define DIGIT_THREE							0x0033
#define DIGIT_FOUR							0x0034
#define DIGIT_FIVE							0x0035
#define DIGIT_SIX							0x0036
#define DIGIT_SEVEN							0x0037
#define DIGIT_EIGHT							0x0038
#define DIGIT_NINE							0x0039
#define COLON								0x003A
#define SEMICOLON							0x003B
#define LESS_THAN_SIGN							0x003C
#define EQUALS_SIGN							0x003D
#define GREATER_THAN_SIGN						0x003E
#define QUESTION_MARK							0x003F
#define COMMERCIAL_AT							0x0040
#define LATIN_CAPITAL_LETTER_A						0x0041
#define LATIN_CAPITAL_LETTER_B  					0x0042
#define LATIN_CAPITAL_LETTER_C  					0x0043
#define LATIN_CAPITAL_LETTER_D  					0x0044
#define LATIN_CAPITAL_LETTER_E  					0x0045
#define LATIN_CAPITAL_LETTER_F  					0x0046
#define LATIN_CAPITAL_LETTER_G  					0x0047
#define LATIN_CAPITAL_LETTER_H  					0x0048
#define LATIN_CAPITAL_LETTER_I  					0x0049
#define LATIN_CAPITAL_LETTER_J  					0x004A
#define LATIN_CAPITAL_LETTER_K  					0x004B
#define LATIN_CAPITAL_LETTER_L  					0x004C
#define LATIN_CAPITAL_LETTER_M  					0x004D
#define LATIN_CAPITAL_LETTER_N  					0x004E
#define LATIN_CAPITAL_LETTER_O  					0x004F
#define LATIN_CAPITAL_LETTER_P  					0x0050
#define LATIN_CAPITAL_LETTER_Q  					0x0051
#define LATIN_CAPITAL_LETTER_R  					0x0052
#define LATIN_CAPITAL_LETTER_S  					0x0053
#define LATIN_CAPITAL_LETTER_T  					0x0054
#define LATIN_CAPITAL_LETTER_U  					0x0055
#define LATIN_CAPITAL_LETTER_V  					0x0056
#define LATIN_CAPITAL_LETTER_W  					0x0057
#define LATIN_CAPITAL_LETTER_X  					0x0058
#define LATIN_CAPITAL_LETTER_Y  					0x0059
#define LATIN_CAPITAL_LETTER_Z  					0x005A
#define LEFT_SQUARE_BRACKET						0x005B
#define REVERSE_SOLIDUS							0x005C
#define RIGHT_SQUARE_BRACKET						0x005D
#define CIRCUMFLEX_ACCENT						0x005E
#define LOW_LINE							0x005F
#define GRAVE_ACCENT							0x0060
#define LATIN_SMALL_LETTER_A		    				0x0061
#define LATIN_SMALL_LETTER_B		    				0x0062
#define LATIN_SMALL_LETTER_C		    				0x0063
#define LATIN_SMALL_LETTER_D		    				0x0064
#define LATIN_SMALL_LETTER_E		    				0x0065
#define LATIN_SMALL_LETTER_F		    				0x0066
#define LATIN_SMALL_LETTER_G		    				0x0067
#define LATIN_SMALL_LETTER_H		    				0x0068
#define LATIN_SMALL_LETTER_I		    				0x0069
#define LATIN_SMALL_LETTER_J		    				0x006A
#define LATIN_SMALL_LETTER_K		    				0x006B
#define LATIN_SMALL_LETTER_L		    				0x006C
#define LATIN_SMALL_LETTER_M		    				0x006D
#define LATIN_SMALL_LETTER_N		    				0x006E
#define LATIN_SMALL_LETTER_O		    				0x006F
#define LATIN_SMALL_LETTER_P		    				0x0070
#define LATIN_SMALL_LETTER_Q		    				0x0071
#define LATIN_SMALL_LETTER_R		    				0x0072
#define LATIN_SMALL_LETTER_S		    				0x0073
#define LATIN_SMALL_LETTER_T		    				0x0074
#define LATIN_SMALL_LETTER_U		    				0x0075
#define LATIN_SMALL_LETTER_V		    				0x0076
#define LATIN_SMALL_LETTER_W		    				0x0077
#define LATIN_SMALL_LETTER_X		    				0x0078
#define LATIN_SMALL_LETTER_Y		    				0x0079
#define LATIN_SMALL_LETTER_Z		    				0x007A
#define LEFT_CURLY_BRACKET						0x007B
#define VERTICAL_LINE							0x007C
#define RIGHT_CURLY_BRACKET						0x007D
#define TILDE								0x007E

/* codes 0x7F-0xBF are not needed */
#define NO_BREAK_SPACE							0x00A0
#define INVERTED_EXCLAMATION_MARK					0x00A1
#define CENT_SIGN							0x00A2
#define POUND_SIGN							0x00A3
#define CURRENCY_SIGN							0x00A4
#define YEN_SIGN							0x00A5
#define BROKEN_BAR							0x00A6
#define SECTION_SIGN							0x00A7
#define DIAERESIS							0x00A8
#define COPYRIGHT_SIGN							0x00A9
#define FEMININE_ORDINAL_INDICATOR					0x00AA
#define LEFT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK			0x00AB
#define NOT_SIGN							0x00AC
#define SOFT_HYPHEN							0x00AD
#define REGISTERED_SIGN							0x00AE
#define MACRON								0x00AF
#define DEGREE_SIGN							0x00B0
#define PLUS_MINUS_SIGN							0x00B1
#define SUPERSCRIPT_TWO							0x00B2
#define SUPERSCRIPT_THREE						0x00B3
#define ACUTE_ACCENT							0x00B4
#define MICRO_SIGN							0x00B5
#define PILCROW_SIGN							0x00B6
#define MIDDLE_DOT							0x00B7
#define CEDILLA								0x00B8
#define SUPERSCRIPT_ONE							0x00B9
#define MASCULINE_ORDINAL_INDICATOR					0x00BA
#define RIGHT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK			0x00BB
#define VULGAR_FRACTION_ONE_QUARTER					0x00BC
#define VULGAR_FRACTION_ONE_HALF					0x00BD
#define VULGAR_FRACTION_THREE_QUARTERS					0x00BE
#define INVERTED_QUESTION_MARK						0x00BF
#define LATIN_CAPITAL_LETTER_A_WITH_GRAVE				0x00C0
#define LATIN_CAPITAL_LETTER_A_WITH_ACUTE				0x00C1
#define LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX				0x00C2
#define LATIN_CAPITAL_LETTER_A_WITH_TILDE				0x00C3
#define LATIN_CAPITAL_LETTER_A_WITH_DIAERESIS				0x00C4
#define LATIN_CAPITAL_LETTER_A_WITH_RING_ABOVE				0x00C5
#define LATIN_CAPITAL_LETTER_AE						0x00C6
#define LATIN_CAPITAL_LETTER_C_WITH_CEDILLA				0x00C7
#define LATIN_CAPITAL_LETTER_E_WITH_GRAVE				0x00C8
#define LATIN_CAPITAL_LETTER_E_WITH_ACUTE				0x00C9
#define LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX				0x00CA
#define LATIN_CAPITAL_LETTER_E_WITH_DIAERESIS				0x00CB
#define LATIN_CAPITAL_LETTER_I_WITH_GRAVE				0x00CC
#define LATIN_CAPITAL_LETTER_I_WITH_ACUTE				0x00CD
#define LATIN_CAPITAL_LETTER_I_WITH_CIRCUMFLEX				0x00CE
#define LATIN_CAPITAL_LETTER_I_WITH_DIAERESIS				0x00CF
#define LATIN_CAPITAL_LETTER_ETH					0x00D0
#define LATIN_CAPITAL_LETTER_N_WITH_TILDE				0x00D1
#define LATIN_CAPITAL_LETTER_O_WITH_GRAVE				0x00D2
#define LATIN_CAPITAL_LETTER_O_WITH_ACUTE				0x00D3
#define LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX				0x00D4
#define LATIN_CAPITAL_LETTER_O_WITH_TILDE				0x00D5
#define LATIN_CAPITAL_LETTER_O_WITH_DIAERESIS				0x00D6
#define MULTIPLICATION_SIGN						0x00D7
#define LATIN_CAPITAL_LETTER_O_WITH_STROKE				0x00D8
#define LATIN_CAPITAL_LETTER_U_WITH_GRAVE				0x00D9
#define LATIN_CAPITAL_LETTER_U_WITH_ACUTE				0x00DA
#define LATIN_CAPITAL_LETTER_U_WITH_CIRCUMFLEX				0x00DB
#define LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS				0x00DC
#define LATIN_CAPITAL_LETTER_Y_WITH_ACUTE				0x00DD
#define LATIN_CAPITAL_LETTER_THORN					0x00DE
#define LATIN_SMALL_LETTER_SHARP_S					0x00DF
#define LATIN_SMALL_LETTER_A_WITH_GRAVE					0x00E0
#define LATIN_SMALL_LETTER_A_WITH_ACUTE					0x00E1
#define LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX				0x00E2
#define LATIN_SMALL_LETTER_A_WITH_TILDE					0x00E3
#define LATIN_SMALL_LETTER_A_WITH_DIAERESIS				0x00E4
#define LATIN_SMALL_LETTER_A_WITH_RING_ABOVE				0x00E5
#define LATIN_SMALL_LETTER_AE						0x00E6
#define LATIN_SMALL_LETTER_C_WITH_CEDILLA				0x00E7
#define LATIN_SMALL_LETTER_E_WITH_GRAVE					0x00E8
#define LATIN_SMALL_LETTER_E_WITH_ACUTE					0x00E9
#define LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX				0x00EA
#define LATIN_SMALL_LETTER_E_WITH_DIAERESIS				0x00EB
#define LATIN_SMALL_LETTER_I_WITH_GRAVE					0x00EC
#define LATIN_SMALL_LETTER_I_WITH_ACUTE					0x00ED
#define LATIN_SMALL_LETTER_I_WITH_CIRCUMFLEX				0x00EE
#define LATIN_SMALL_LETTER_I_WITH_DIAERESIS				0x00EF
#define LATIN_SMALL_LETTER_ETH						0x00F0
#define LATIN_SMALL_LETTER_N_WITH_TILDE					0x00F1
#define LATIN_SMALL_LETTER_O_WITH_GRAVE					0x00F2
#define LATIN_SMALL_LETTER_O_WITH_ACUTE					0x00F3
#define LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX				0x00F4
#define LATIN_SMALL_LETTER_O_WITH_TILDE					0x00F5
#define LATIN_SMALL_LETTER_O_WITH_DIAERESIS				0x00F6
#define DIVISION_SIGN							0x00F7
#define LATIN_SMALL_LETTER_O_WITH_STROKE				0x00F8
#define LATIN_SMALL_LETTER_U_WITH_GRAVE					0x00F9
#define LATIN_SMALL_LETTER_U_WITH_ACUTE					0x00FA
#define LATIN_SMALL_LETTER_U_WITH_CIRCUMFLEX				0x00FB
#define LATIN_SMALL_LETTER_U_WITH_DIAERESIS				0x00FC
#define LATIN_SMALL_LETTER_Y_WITH_ACUTE					0x00FD
#define LATIN_SMALL_LETTER_THORN					0x00FE
#define LATIN_SMALL_LETTER_Y_WITH_DIAERESIS				0x00FF

/* latin extended-A */
#define LATIN_CAPITAL_LETTER_A_WITH_MACRON				0x0100
#define LATIN_SMALL_LETTER_A_WITH_MACRON				0x0101
#define LATIN_CAPITAL_LETTER_A_WITH_BREVE				0x0102
#define LATIN_SMALL_LETTER_A_WITH_BREVE					0x0103
#define LATIN_CAPITAL_LETTER_A_WITH_OGONEK				0x0104
#define LATIN_SMALL_LETTER_A_WITH_OGONEK				0x0105
#define LATIN_CAPITAL_LETTER_C_WITH_ACUTE				0x0106
#define LATIN_SMALL_LETTER_C_WITH_ACUTE					0x0107
#define LATIN_CAPITAL_LETTER_C_WITH_CIRCUMFLEX				0x0108
#define LATIN_SMALL_LETTER_C_WITH_CIRCUMFLEX				0x0109
#define LATIN_CAPITAL_LETTER_C_WITH_DOT_ABOVE				0x010A
#define LATIN_SMALL_LETTER_C_WITH_DOT_ABOVE				0x010B
#define LATIN_CAPITAL_LETTER_C_WITH_CARON				0x010C
#define LATIN_SMALL_LETTER_C_WITH_CARON					0x010D
#define LATIN_CAPITAL_LETTER_D_WITH_CARON				0x010E
#define LATIN_SMALL_LETTER_D_WITH_CARON					0x010F
#define LATIN_CAPITAL_LETTER_D_WITH_STROKE				0x0110
#define LATIN_SMALL_LETTER_D_WITH_STROKE				0x0111
#define LATIN_CAPITAL_LETTER_E_WITH_MACRON				0x0112
#define LATIN_SMALL_LETTER_E_WITH_MACRON				0x0113
#define LATIN_CAPITAL_LETTER_E_WITH_BREVE				0x0114
#define LATIN_SMALL_LETTER_E_WITH_BREVE					0x0115
#define LATIN_CAPITAL_LETTER_E_WITH_DOT_ABOVE				0x0116
#define LATIN_SMALL_LETTER_E_WITH_DOT_ABOVE				0x0117
#define LATIN_CAPITAL_LETTER_E_WITH_OGONEK				0x0118
#define LATIN_SMALL_LETTER_E_WITH_OGONEK				0x0119
#define LATIN_CAPITAL_LETTER_E_WITH_CARON				0x011A
#define LATIN_SMALL_LETTER_E_WITH_CARON					0x011B
#define LATIN_CAPITAL_LETTER_G_WITH_CIRCUMFLEX				0x011C
#define LATIN_SMALL_LETTER_G_WITH_CIRCUMFLEX				0x011D
#define LATIN_CAPITAL_LETTER_G_WITH_BREVE				0x011E
#define LATIN_SMALL_LETTER_G_WITH_BREVE					0x011F
#define LATIN_CAPITAL_LETTER_G_WITH_DOT_ABOVE				0x0120
#define LATIN_SMALL_LETTER_G_WITH_DOT_ABOVE				0x0121
#define LATIN_CAPITAL_LETTER_G_WITH_CEDILLA				0x0122
#define LATIN_SMALL_LETTER_G_WITH_CEDILLA				0x0123
#define LATIN_CAPITAL_LETTER_H_WITH_CIRCUMFLEX				0x0124
#define LATIN_SMALL_LETTER_H_WITH_CIRCUMFLEX				0x0125
#define LATIN_CAPITAL_LETTER_H_WITH_STROKE				0x0126
#define LATIN_SMALL_LETTER_H_WITH_STROKE				0x0127
#define LATIN_CAPITAL_LETTER_I_WITH_TILDE				0x0128
#define LATIN_SMALL_LETTER_I_WITH_TILDE					0x0129
#define LATIN_CAPITAL_LETTER_I_WITH_MACRON				0x012A
#define LATIN_SMALL_LETTER_I_WITH_MACRON				0x012B
#define LATIN_CAPITAL_LETTER_I_WITH_BREVE				0x012C
#define LATIN_SMALL_LETTER_I_WITH_BREVE					0x012D
#define LATIN_CAPITAL_LETTER_I_WITH_OGONEK				0x012E
#define LATIN_SMALL_LETTER_I_WITH_OGONEK				0x012F
#define LATIN_CAPITAL_LETTER_I_WITH_DOT_ABOVE				0x0130
#define LATIN_SMALL_LETTER_DOTLESS_I					0x0131
#define LATIN_CAPITAL_LIGATURE_IJ					0x0132
#define LATIN_SMALL_LIGATURE_IJ						0x0133
#define LATIN_CAPITAL_LETTER_J_WITH_CIRCUMFLEX				0x0134
#define LATIN_SMALL_LETTER_J_WITH_CIRCUMFLEX				0x0135
#define LATIN_CAPITAL_LETTER_K_WITH_CEDILLA				0x0136
#define LATIN_SMALL_LETTER_K_WITH_CEDILLA				0x0137
#define LATIN_SMALL_LETTER_KRA						0x0138
#define LATIN_CAPITAL_LETTER_L_WITH_ACUTE				0x0139
#define LATIN_SMALL_LETTER_L_WITH_ACUTE					0x013A
#define LATIN_CAPITAL_LETTER_L_WITH_CEDILLA				0x013B
#define LATIN_SMALL_LETTER_L_WITH_CEDILLA				0x013C
#define LATIN_CAPITAL_LETTER_L_WITH_CARON				0x013D
#define LATIN_SMALL_LETTER_L_WITH_CARON					0x013E
#define LATIN_CAPITAL_LETTER_L_WITH_MIDDLE_DOT				0x013F
#define LATIN_SMALL_LETTER_L_WITH_MIDDLE_DOT				0x0140
#define LATIN_CAPITAL_LETTER_L_WITH_STROKE				0x0141
#define LATIN_SMALL_LETTER_L_WITH_STROKE				0x0142
#define LATIN_CAPITAL_LETTER_N_WITH_ACUTE				0x0143
#define LATIN_SMALL_LETTER_N_WITH_ACUTE					0x0144
#define LATIN_CAPITAL_LETTER_N_WITH_CEDILLA				0x0145
#define LATIN_SMALL_LETTER_N_WITH_CEDILLA				0x0146
#define LATIN_CAPITAL_LETTER_N_WITH_CARON				0x0147
#define LATIN_SMALL_LETTER_N_WITH_CARON					0x0148
#define LATIN_SMALL_LETTER_N_PRECEDED_BY_APOSTROPHE			0x0149
#define LATIN_CAPITAL_LETTER_ENG					0x014A
#define LATIN_SMALL_LETTER_ENG						0x014B
#define LATIN_CAPITAL_LETTER_O_WITH_MACRON				0x014C
#define LATIN_SMALL_LETTER_O_WITH_MACRON				0x014D
#define LATIN_CAPITAL_LETTER_O_WITH_BREVE				0x014E
#define LATIN_SMALL_LETTER_O_WITH_BREVE					0x014F
#define LATIN_CAPITAL_LETTER_O_WITH_DOUBLE_ACUTE			0x0150
#define LATIN_SMALL_LETTER_O_WITH_DOUBLE_ACUTE				0x0151
#define LATIN_CAPITAL_LIGATURE_OE					0x0152
#define LATIN_SMALL_LIGATURE_OE						0x0153
#define LATIN_CAPITAL_LETTER_R_WITH_ACUTE				0x0154
#define LATIN_SMALL_LETTER_R_WITH_ACUTE					0x0155
#define LATIN_CAPITAL_LETTER_R_WITH_CEDILLA				0x0156
#define LATIN_SMALL_LETTER_R_WITH_CEDILLA				0x0157
#define LATIN_CAPITAL_LETTER_R_WITH_CARON				0x0158
#define LATIN_SMALL_LETTER_R_WITH_CARON					0x0159
#define LATIN_CAPITAL_LETTER_S_WITH_ACUTE				0x015A
#define LATIN_SMALL_LETTER_S_WITH_ACUTE					0x015B
#define LATIN_CAPITAL_LETTER_S_WITH_CIRCUMFLEX				0x015C
#define LATIN_SMALL_LETTER_S_WITH_CIRCUMFLEX				0x015D
#define LATIN_CAPITAL_LETTER_S_WITH_CEDILLA				0x015E
#define LATIN_SMALL_LETTER_S_WITH_CEDILLA				0x015F
#define LATIN_CAPITAL_LETTER_S_WITH_CARON				0x0160
#define LATIN_SMALL_LETTER_S_WITH_CARON					0x0161
#define LATIN_CAPITAL_LETTER_T_WITH_CEDILLA				0x0162
#define LATIN_SMALL_LETTER_T_WITH_CEDILLA				0x0163
#define LATIN_CAPITAL_LETTER_T_WITH_CARON				0x0164
#define LATIN_SMALL_LETTER_T_WITH_CARON					0x0165
#define LATIN_CAPITAL_LETTER_T_WITH_STROKE				0x0166
#define LATIN_SMALL_LETTER_T_WITH_STROKE				0x0167
#define LATIN_CAPITAL_LETTER_U_WITH_TILDE				0x0168
#define LATIN_SMALL_LETTER_U_WITH_TILDE					0x0169
#define LATIN_CAPITAL_LETTER_U_WITH_MACRON				0x016A
#define LATIN_SMALL_LETTER_U_WITH_MACRON				0x016B
#define LATIN_CAPITAL_LETTER_U_WITH_BREVE				0x016C
#define LATIN_SMALL_LETTER_U_WITH_BREVE					0x016D
#define LATIN_CAPITAL_LETTER_U_WITH_RING_ABOVE				0x016E
#define LATIN_SMALL_LETTER_U_WITH_RING_ABOVE				0x016F
#define LATIN_CAPITAL_LETTER_U_WITH_DOUBLE_ACUTE			0x0170
#define LATIN_SMALL_LETTER_U_WITH_DOUBLE_ACUTE				0x0171
#define LATIN_CAPITAL_LETTER_U_WITH_OGONEK				0x0172
#define LATIN_SMALL_LETTER_U_WITH_OGONEK				0x0173
#define LATIN_CAPITAL_LETTER_W_WITH_CIRCUMFLEX				0x0174
#define LATIN_SMALL_LETTER_W_WITH_CIRCUMFLEX				0x0175
#define LATIN_CAPITAL_LETTER_Y_WITH_CIRCUMFLEX				0x0176
#define LATIN_SMALL_LETTER_Y_WITH_CIRCUMFLEX				0x0177
#define LATIN_CAPITAL_LETTER_Y_WITH_DIAERESIS				0x0178
#define LATIN_CAPITAL_LETTER_Z_WITH_ACUTE				0x0179
#define LATIN_SMALL_LETTER_Z_WITH_ACUTE					0x017A
#define LATIN_CAPITAL_LETTER_Z_WITH_DOT_ABOVE				0x017B
#define LATIN_SMALL_LETTER_Z_WITH_DOT_ABOVE				0x017C
#define LATIN_CAPITAL_LETTER_Z_WITH_CARON				0x017D
#define LATIN_SMALL_LETTER_Z_WITH_CARON					0x017E
#define LATIN_SMALL_LETTER_LONG_S					0x017F

/* latin extended B */
#define LATIN_SMALL_LETTER_B_WITH_STROKE				0x0180
#define LATIN_CAPITAL_LETTER_B_WITH_HOOK				0x0181
#define LATIN_CAPITAL_LETTER_B_WITH_TOPBAR				0x0182
#define LATIN_SMALL_LETTER_B_WITH_TOPBAR				0x0183
#define LATIN_CAPITAL_LETTER_TONE_SIX					0x0184
#define LATIN_SMALL_LETTER_TONE_SIX					0x0185
#define LATIN_CAPITAL_LETTER_OPEN_O					0x0186
#define LATIN_CAPITAL_LETTER_C_WITH_HOOK				0x0187
#define LATIN_SMALL_LETTER_C_WITH_HOOK					0x0188
#define LATIN_CAPITAL_LETTER_AFRICAN_D					0x0189
#define LATIN_CAPITAL_LETTER_D_WITH_HOOK				0x018A
#define LATIN_CAPITAL_LETTER_D_WITH_TOPBAR				0x018B
#define LATIN_SMALL_LETTER_D_WITH_TOPBAR				0x018C
#define LATIN_SMALL_LETTER_TURNED_DELTA					0x018D
#define LATIN_CAPITAL_LETTER_REVERSED_E					0x018E
#define LATIN_CAPITAL_LETTER_SCHWA					0x018F
#define LATIN_CAPITAL_LETTER_OPEN_E					0x0190
#define LATIN_CAPITAL_LETTER_F_WITH_HOOK				0x0191
#define LATIN_SMALL_LETTER_F_WITH_HOOK					0x0192
#define LATIN_CAPITAL_LETTER_G_WITH_HOOK				0x0193
#define LATIN_CAPITAL_LETTER_GAMMA					0x0194
#define LATIN_SMALL_LETTER_HV						0x0195
#define LATIN_CAPITAL_LETTER_IOTA					0x0196
#define LATIN_CAPITAL_LETTER_I_WITH_STROKE				0x0197
#define LATIN_CAPITAL_LETTER_K_WITH_HOOK				0x0198
#define LATIN_SMALL_LETTER_K_WITH_HOOK					0x0199
#define LATIN_SMALL_LETTER_L_WITH_BAR					0x019A
#define LATIN_SMALL_LETTER_LAMBDA_WITH_STROKE				0x019B
#define LATIN_CAPITAL_LETTER_TURNED_M					0x019C
#define LATIN_CAPITAL_LETTER_N_WITH_LEFT_HOOK				0x019D
#define LATIN_SMALL_LETTER_N_WITH_LONG_RIGHT_LEG			0x019E
#define LATIN_CAPITAL_LETTER_O_WITH_MIDDLE_TILDE			0x019F
#define LATIN_CAPITAL_LETTER_O_WITH_HORN				0x01A0
#define LATIN_SMALL_LETTER_O_WITH_HORN					0x01A1
#define LATIN_CAPITAL_LETTER_OI						0x01A2
#define LATIN_SMALL_LETTER_OI						0x01A3
#define LATIN_CAPITAL_LETTER_P_WITH_HOOK				0x01A4
#define LATIN_SMALL_LETTER_P_WITH_HOOK					0x01A5
#define LATIN_LETTER_YR							0x01A6
#define LATIN_CAPITAL_LETTER_TONE_TWO					0x01A7
#define LATIN_SMALL_LETTER_TONE_TWO					0x01A8
#define LATIN_CAPITAL_LETTER_ESH					0x01A9
#define LATIN_LETTER_REVERSED_ESH_LOOP					0x01AA
#define LATIN_SMALL_LETTER_T_WITH_PALATAL_HOOK				0x01AB
#define LATIN_CAPITAL_LETTER_T_WITH_HOOK				0x01AC
#define LATIN_SMALL_LETTER_T_WITH_HOOK					0x01AD
#define LATIN_CAPITAL_LETTER_T_WITH_RETROFLEX_HOOK			0x01AE
#define LATIN_CAPITAL_LETTER_U_WITH_HORN				0x01AF
#define LATIN_SMALL_LETTER_U_WITH_HORN					0x01B0
#define LATIN_CAPITAL_LETTER_UPSILON					0x01B1
#define LATIN_CAPITAL_LETTER_V_WITH_HOOK				0x01B2
#define LATIN_CAPITAL_LETTER_Y_WITH_HOOK				0x01B3
#define LATIN_SMALL_LETTER_Y_WITH_HOOK					0x01B4
#define LATIN_CAPITAL_LETTER_Z_WITH_STROKE				0x01B5
#define LATIN_SMALL_LETTER_Z_WITH_STROKE				0x01B6
#define LATIN_CAPITAL_LETTER_EZH					0x01B7
#define LATIN_CAPITAL_LETTER_EZH_REVERSED				0x01B8
#define LATIN_SMALL_LETTER_EZH_REVERSED					0x01B9
#define LATIN_SMALL_LETTER_EZH_WITH_TAIL				0x01BA
#define LATIN_LETTER_TWO_WITH_STROKE					0x01BB
#define LATIN_CAPITAL_LETTER_TONE_FIVE					0x01BC
#define LATIN_SMALL_LETTER_TONE_FIVE					0x01BD
#define LATIN_LETTER_INVERTED_GLOTTAL_STOP_WITH_STROKE			0x01BE
#define LATIN_LETTER_WYNN						0x01BF
#define LATIN_LETTER_DENTAL_CLICK					0x01C0
#define LATIN_LETTER_LATERAL_CLICK					0x01C1
#define LATIN_LETTER_ALVEOLAR_CLICK					0x01C2
#define LATIN_LETTER_RETROFLEX_CLICK					0x01C3
#define LATIN_CAPITAL_LETTER_DZ_WITH_CARON				0x01C4
#define LATIN_CAPITAL_LETTER_D_WITH_SMALL_LETTER_Z_WITH_CARON		0x01C5
#define LATIN_SMALL_LETTER_DZ_WITH_CARON				0x01C6
#define LATIN_CAPITAL_LETTER_LJ						0x01C7
#define LATIN_CAPITAL_LETTER_L_WITH_SMALL_LETTER_J			0x01C8
#define LATIN_SMALL_LETTER_LJ						0x01C9
#define LATIN_CAPITAL_LETTER_NJ						0x01CA
#define LATIN_CAPITAL_LETTER_N_WITH_SMALL_LETTER_J			0x01CB
#define LATIN_SMALL_LETTER_NJ						0x01CC
#define LATIN_CAPITAL_LETTER_A_WITH_CARON				0x01CD
#define LATIN_SMALL_LETTER_A_WITH_CARON					0x01CE
#define LATIN_CAPITAL_LETTER_I_WITH_CARON				0x01CF
#define LATIN_SMALL_LETTER_I_WITH_CARON					0x01D0
#define LATIN_CAPITAL_LETTER_O_WITH_CARON				0x01D1
#define LATIN_SMALL_LETTER_O_WITH_CARON					0x01D2
#define LATIN_CAPITAL_LETTER_U_WITH_CARON				0x01D3
#define LATIN_SMALL_LETTER_U_WITH_CARON					0x01D4
#define LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS_AND_MACRON		0x01D5
#define LATIN_SMALL_LETTER_U_WITH_DIAERESIS_AND_MACRON			0x01D6
#define LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS_AND_ACUTE			0x01D7
#define LATIN_SMALL_LETTER_U_WITH_DIAERESIS_AND_ACUTE			0x01D8
#define LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS_AND_CARON			0x01D9
#define LATIN_SMALL_LETTER_U_WITH_DIAERESIS_AND_CARON			0x01DA
#define LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS_AND_GRAVE			0x01DB
#define LATIN_SMALL_LETTER_U_WITH_DIAERESIS_AND_GRAVE			0x01DC
#define LATIN_SMALL_LETTER_TURNED_E					0x01DD
#define LATIN_CAPITAL_LETTER_A_WITH_DIAERESIS_AND_MACRON		0x01DE
#define LATIN_SMALL_LETTER_A_WITH_DIAERESIS_AND_MACRON			0x01DF
#define LATIN_CAPITAL_LETTER_A_WITH_DOT_ABOVE_AND_MACRON		0x01E0
#define LATIN_SMALL_LETTER_A_WITH_DOT_ABOVE_AND_MACRON			0x01E1
#define LATIN_CAPITAL_LETTER_AE_WITH_MACRON				0x01E2
#define LATIN_SMALL_LETTER_AE_WITH_MACRON				0x01E3
#define LATIN_CAPITAL_LETTER_G_WITH_STROKE				0x01E4
#define LATIN_SMALL_LETTER_G_WITH_STROKE				0x01E5
#define LATIN_CAPITAL_LETTER_G_WITH_CARON				0x01E6
#define LATIN_SMALL_LETTER_G_WITH_CARON					0x01E7
#define LATIN_CAPITAL_LETTER_K_WITH_CARON				0x01E8
#define LATIN_SMALL_LETTER_K_WITH_CARON					0x01E9
#define LATIN_CAPITAL_LETTER_O_WITH_OGONEK				0x01EA
#define LATIN_SMALL_LETTER_O_WITH_OGONEK				0x01EB
#define LATIN_CAPITAL_LETTER_O_WITH_OGONEK_AND_MACRON			0x01EC
#define LATIN_SMALL_LETTER_O_WITH_OGONEK_AND_MACRON			0x01ED
#define LATIN_CAPITAL_LETTER_EZH_WITH_CARON				0x01EE
#define LATIN_SMALL_LETTER_EZH_WITH_CARON				0x01EF
#define LATIN_SMALL_LETTER_J_WITH_CARON					0x01F0
#define LATIN_CAPITAL_LETTER_DZ						0x01F1
#define LATIN_CAPITAL_LETTER_D_WITH_SMALL_LETTER_Z			0x01F2
#define LATIN_SMALL_LETTER_DZ						0x01F3
#define LATIN_CAPITAL_LETTER_G_WITH_ACUTE				0x01F4
#define LATIN_SMALL_LETTER_G_WITH_ACUTE					0x01F5
#define LATIN_CAPITAL_LETTER_HWAIR					0x01F6
#define LATIN_CAPITAL_LETTER_WYNN					0x01F7
#define LATIN_CAPITAL_LETTER_N_WITH_GRAVE				0x01F8
#define LATIN_SMALL_LETTER_N_WITH_GRAVE					0x01F9
#define LATIN_CAPITAL_LETTER_A_WITH_RING_ABOVE_AND_ACUTE		0x01FA
#define LATIN_SMALL_LETTER_A_WITH_RING_ABOVE_AND_ACUTE			0x01FB
#define LATIN_CAPITAL_LETTER_AE_WITH_ACUTE				0x01FC
#define LATIN_SMALL_LETTER_AE_WITH_ACUTE				0x01FD
#define LATIN_CAPITAL_LETTER_O_WITH_STROKE_AND_ACUTE			0x01FE
#define LATIN_SMALL_LETTER_O_WITH_STROKE_AND_ACUTE			0x01FF
#define LATIN_CAPITAL_LETTER_A_WITH_DOUBLE_GRAVE			0x0200
#define LATIN_SMALL_LETTER_A_WITH_DOUBLE_GRAVE				0x0201
#define LATIN_CAPITAL_LETTER_A_WITH_INVERTED_BREVE			0x0202
#define LATIN_SMALL_LETTER_A_WITH_INVERTED_BREVE			0x0203
#define LATIN_CAPITAL_LETTER_E_WITH_DOUBLE_GRAVE			0x0204
#define LATIN_SMALL_LETTER_E_WITH_DOUBLE_GRAVE				0x0205
#define LATIN_CAPITAL_LETTER_E_WITH_INVERTED_BREVE			0x0206
#define LATIN_SMALL_LETTER_E_WITH_INVERTED_BREVE			0x0207
#define LATIN_CAPITAL_LETTER_I_WITH_DOUBLE_GRAVE			0x0208
#define LATIN_SMALL_LETTER_I_WITH_DOUBLE_GRAVE				0x0209
#define LATIN_CAPITAL_LETTER_I_WITH_INVERTED_BREVE			0x020A
#define LATIN_SMALL_LETTER_I_WITH_INVERTED_BREVE			0x020B
#define LATIN_CAPITAL_LETTER_O_WITH_DOUBLE_GRAVE			0x020C
#define LATIN_SMALL_LETTER_O_WITH_DOUBLE_GRAVE				0x020D
#define LATIN_CAPITAL_LETTER_O_WITH_INVERTED_BREVE			0x020E
#define LATIN_SMALL_LETTER_O_WITH_INVERTED_BREVE			0x020F
#define LATIN_CAPITAL_LETTER_R_WITH_DOUBLE_GRAVE			0x0210
#define LATIN_SMALL_LETTER_R_WITH_DOUBLE_GRAVE				0x0211
#define LATIN_CAPITAL_LETTER_R_WITH_INVERTED_BREVE			0x0212
#define LATIN_SMALL_LETTER_R_WITH_INVERTED_BREVE			0x0213
#define LATIN_CAPITAL_LETTER_U_WITH_DOUBLE_GRAVE			0x0214
#define LATIN_SMALL_LETTER_U_WITH_DOUBLE_GRAVE				0x0215
#define LATIN_CAPITAL_LETTER_U_WITH_INVERTED_BREVE			0x0216
#define LATIN_SMALL_LETTER_U_WITH_INVERTED_BREVE			0x0217
#define LATIN_CAPITAL_LETTER_S_WITH_COMMA_BELOW				0x0218
#define LATIN_SMALL_LETTER_S_WITH_COMMA_BELOW				0x0219
#define LATIN_CAPITAL_LETTER_T_WITH_COMMA_BELOW				0x021A
#define LATIN_SMALL_LETTER_T_WITH_COMMA_BELOW				0x021B
#define LATIN_CAPITAL_LETTER_YOGH					0x021C
#define LATIN_SMALL_LETTER_YOGH						0x021D
#define LATIN_CAPITAL_LETTER_H_WITH_CARON				0x021E
#define LATIN_SMALL_LETTER_H_WITH_CARON					0x021F
#define LATIN_CAPITAL_LETTER_OU						0x0222
#define LATIN_SMALL_LETTER_OU						0x0223
#define LATIN_CAPITAL_LETTER_Z_WITH_HOOK				0x0224
#define LATIN_SMALL_LETTER_Z_WITH_HOOK					0x0225
#define LATIN_CAPITAL_LETTER_A_WITH_DOT_ABOVE				0x0226
#define LATIN_SMALL_LETTER_A_WITH_DOT_ABOVE				0x0227
#define LATIN_CAPITAL_LETTER_E_WITH_CEDILLA				0x0228
#define LATIN_SMALL_LETTER_E_WITH_CEDILLA				0x0229
#define LATIN_CAPITAL_LETTER_O_WITH_DIAERESIS_AND_MACRON		0x022A
#define LATIN_SMALL_LETTER_O_WITH_DIAERESIS_AND_MACRON			0x022B
#define LATIN_CAPITAL_LETTER_O_WITH_TILDE_AND_MACRON			0x022C
#define LATIN_SMALL_LETTER_O_WITH_TILDE_AND_MACRON			0x022D
#define LATIN_CAPITAL_LETTER_O_WITH_DOT_ABOVE				0x022E
#define LATIN_SMALL_LETTER_O_WITH_DOT_ABOVE				0x022F
#define LATIN_CAPITAL_LETTER_O_WITH_DOT_ABOVE_AND_MACRON		0x0230
#define LATIN_SMALL_LETTER_O_WITH_DOT_ABOVE_AND_MACRON			0x0231
#define LATIN_CAPITAL_LETTER_Y_WITH_MACRON				0x0232
#define LATIN_SMALL_LETTER_Y_WITH_MACRON				0x0233

/* IPA extensions */
#define LATIN_SMALL_LETTER_TURNED_A					0x0250
#define LATIN_SMALL_LETTER_ALPHA					0x0251
#define LATIN_SMALL_LETTER_TURNED_ALPHA					0x0252
#define LATIN_SMALL_LETTER_B_WITH_HOOK					0x0253
#define LATIN_SMALL_LETTER_OPEN_O					0x0254
#define LATIN_SMALL_LETTER_C_WITH_CURL					0x0255
#define LATIN_SMALL_LETTER_D_WITH_TAIL					0x0256
#define LATIN_SMALL_LETTER_D_WITH_HOOK					0x0257
#define LATIN_SMALL_LETTER_REVERSED_E					0x0258
#define LATIN_SMALL_LETTER_SCHWA					0x0259
#define LATIN_SMALL_LETTER_SCHWA_WITH_HOOK				0x025A
#define LATIN_SMALL_LETTER_OPEN_E					0x025B
#define LATIN_SMALL_LETTER_REVERSED_OPEN_E				0x025C
#define LATIN_SMALL_LETTER_REVERSED_OPEN_E_WITH_HOOK			0x025D
#define LATIN_SMALL_LETTER_CLOSED_REVERSED_OPEN_E			0x025E
#define LATIN_SMALL_LETTER_DOTLESS_J_WITH_STROKE			0x025F
#define LATIN_SMALL_LETTER_G_WITH_HOOK					0x0260
#define LATIN_SMALL_LETTER_SCRIPT_G					0x0261
#define LATIN_LETTER_SMALL_CAPITAL_G					0x0262
#define LATIN_SMALL_LETTER_GAMMA					0x0263
#define LATIN_SMALL_LETTER_RAMS_HORN					0x0264
#define LATIN_SMALL_LETTER_TURNED_H					0x0265
#define LATIN_SMALL_LETTER_H_WITH_HOOK					0x0266
#define LATIN_SMALL_LETTER_HENG_WITH_HOOK				0x0267
#define LATIN_SMALL_LETTER_I_WITH_STROKE				0x0268
#define LATIN_SMALL_LETTER_IOTA						0x0269
#define LATIN_LETTER_SMALL_CAPITAL_I					0x026A
#define LATIN_SMALL_LETTER_L_WITH_MIDDLE_TILDE				0x026B
#define LATIN_SMALL_LETTER_L_WITH_BELT					0x026C
#define LATIN_SMALL_LETTER_L_WITH_RETROFLEX_HOOK			0x026D
#define LATIN_SMALL_LETTER_LEZH						0x026E
#define LATIN_SMALL_LETTER_TURNED_M					0x026F
#define LATIN_SMALL_LETTER_TURNED_M_WITH_LONG_LEG			0x0270
#define LATIN_SMALL_LETTER_M_WITH_HOOK					0x0271
#define LATIN_SMALL_LETTER_N_WITH_LEFT_HOOK				0x0272
#define LATIN_SMALL_LETTER_N_WITH_RETROFLEX_HOOK			0x0273
#define LATIN_LETTER_SMALL_CAPITAL_N					0x0274
#define LATIN_SMALL_LETTER_BARRED_O					0x0275
#define LATIN_LETTER_SMALL_CAPITAL_OE					0x0276
#define LATIN_SMALL_LETTER_CLOSED_OMEGA					0x0277
#define LATIN_SMALL_LETTER_PHI						0x0278
#define LATIN_SMALL_LETTER_TURNED_R					0x0279
#define LATIN_SMALL_LETTER_TURNED_R_WITH_LONG_LEG			0x027A
#define LATIN_SMALL_LETTER_TURNED_R_WITH_HOOK				0x027B
#define LATIN_SMALL_LETTER_R_WITH_LONG_LEG				0x027C
#define LATIN_SMALL_LETTER_R_WITH_TAIL					0x027D
#define LATIN_SMALL_LETTER_R_WITH_FISHHOOK				0x027E
#define LATIN_SMALL_LETTER_REVERSED_R_WITH_FISHHOOK			0x027F
#define LATIN_LETTER_SMALL_CAPITAL_R					0x0280
#define LATIN_LETTER_SMALL_CAPITAL_INVERTED_R				0x0281
#define LATIN_SMALL_LETTER_S_WITH_HOOK					0x0282
#define LATIN_SMALL_LETTER_ESH						0x0283
#define LATIN_SMALL_LETTER_DOTLESS_J_WITH_STROKE_AND_HOOK		0x0284
#define LATIN_SMALL_LETTER_SQUAT_REVERSED_ESH				0x0285
#define LATIN_SMALL_LETTER_ESH_WITH_CURL				0x0286
#define LATIN_SMALL_LETTER_TURNED_T					0x0287
#define LATIN_SMALL_LETTER_T_WITH_RETROFLEX_HOOK			0x0288
#define LATIN_SMALL_LETTER_U_BAR					0x0289
#define LATIN_SMALL_LETTER_UPSILON					0x028A
#define LATIN_SMALL_LETTER_V_WITH_HOOK					0x028B
#define LATIN_SMALL_LETTER_TURNED_V					0x028C
#define LATIN_SMALL_LETTER_TURNED_W					0x028D
#define LATIN_SMALL_LETTER_TURNED_Y					0x028E
#define LATIN_LETTER_SMALL_CAPITAL_Y					0x028F
#define LATIN_SMALL_LETTER_Z_WITH_RETROFLEX_HOOK			0x0290
#define LATIN_SMALL_LETTER_Z_WITH_CURL					0x0291
#define LATIN_SMALL_LETTER_EZH						0x0292
#define LATIN_SMALL_LETTER_EZH_WITH_CURL				0x0293
#define LATIN_LETTER_GLOTTAL_STOP					0x0294
#define LATIN_LETTER_PHARYNGEAL_VOICED_FRICATIVE			0x0295
#define LATIN_LETTER_INVERTED_GLOTTAL_STOP				0x0296
#define LATIN_LETTER_STRETCHED_C					0x0297
#define LATIN_LETTER_BILABIAL_CLICK					0x0298
#define LATIN_LETTER_SMALL_CAPITAL_B					0x0299
#define LATIN_SMALL_LETTER_CLOSED_OPEN_E				0x029A
#define LATIN_LETTER_SMALL_CAPITAL_G_WITH_HOOK				0x029B
#define LATIN_LETTER_SMALL_CAPITAL_H					0x029C
#define LATIN_SMALL_LETTER_J_WITH_CROSSED_TAIL				0x029D
#define LATIN_SMALL_LETTER_TURNED_K					0x029E
#define LATIN_LETTER_SMALL_CAPITAL_L					0x029F
#define LATIN_SMALL_LETTER_Q_WITH_HOOK					0x02A0
#define LATIN_LETTER_GLOTTAL_STOP_WITH_STROKE				0x02A1
#define LATIN_LETTER_REVERSED_GLOTTAL_STOP_WITH_STROKE			0x02A2
#define LATIN_SMALL_LETTER_DZ_DIGRAPH					0x02A3
#define LATIN_SMALL_LETTER_DEZH_DIGRAPH					0x02A4
#define LATIN_SMALL_LETTER_DZ_DIGRAPH_WITH_CURL				0x02A5
#define LATIN_SMALL_LETTER_TS_DIGRAPH					0x02A6
#define LATIN_SMALL_LETTER_TESH_DIGRAPH					0x02A7
#define LATIN_SMALL_LETTER_TC_DIGRAPH_WITH_CURL				0x02A8
#define LATIN_SMALL_LETTER_FENG_DIGRAPH					0x02A9
#define LATIN_SMALL_LETTER_LS_DIGRAPH					0x02AA
#define LATIN_SMALL_LETTER_LZ_DIGRAPH					0x02AB
#define LATIN_LETTER_BILABIAL_PERCUSSIVE				0x02AC
#define LATIN_LETTER_BIDENTAL_PERCUSSIVE				0x02AD

/* spacing modifier letters */
#define MODIFIER_LETTER_SMALL_H						0x02B0
#define MODIFIER_LETTER_SMALL_H_WITH_HOOK				0x02B1
#define MODIFIER_LETTER_SMALL_J						0x02B2
#define MODIFIER_LETTER_SMALL_R						0x02B3
#define MODIFIER_LETTER_SMALL_TURNED_R					0x02B4
#define MODIFIER_LETTER_SMALL_TURNED_R_WITH_HOOK			0x02B5
#define MODIFIER_LETTER_SMALL_CAPITAL_INVERTED_R			0x02B6
#define MODIFIER_LETTER_SMALL_W						0x02B7
#define MODIFIER_LETTER_SMALL_Y						0x02B8
#define MODIFIER_LETTER_PRIME						0x02B9
#define MODIFIER_LETTER_DOUBLE_PRIME					0x02BA
#define MODIFIER_LETTER_TURNED_COMMA					0x02BB
#define MODIFIER_LETTER_APOSTROPHE					0x02BC
#define MODIFIER_LETTER_REVERSED_COMMA					0x02BD
#define MODIFIER_LETTER_RIGHT_HALF_RING					0x02BE
#define MODIFIER_LETTER_LEFT_HALF_RING					0x02BF
#define MODIFIER_LETTER_GLOTTAL_STOP					0x02C0
#define MODIFIER_LETTER_REVERSED_GLOTTAL_STOP				0x02C1
#define MODIFIER_LETTER_LEFT_ARROWHEAD					0x02C2
#define MODIFIER_LETTER_RIGHT_ARROWHEAD					0x02C3
#define MODIFIER_LETTER_UP_ARROWHEAD					0x02C4
#define MODIFIER_LETTER_DOWN_ARROWHEAD					0x02C5
#define MODIFIER_LETTER_CIRCUMFLEX_ACCENT				0x02C6
#define CARON								0x02C7
#define MODIFIER_LETTER_VERTICAL_LINE					0x02C8
#define MODIFIER_LETTER_MACRON						0x02C9
#define MODIFIER_LETTER_ACUTE_ACCENT					0x02CA
#define MODIFIER_LETTER_GRAVE_ACCENT					0x02CB
#define MODIFIER_LETTER_LOW_VERTICAL_LINE				0x02CC
#define MODIFIER_LETTER_LOW_MACRON					0x02CD
#define MODIFIER_LETTER_LOW_GRAVE_ACCENT				0x02CE
#define MODIFIER_LETTER_LOW_ACUTE_ACCENT				0x02CF
#define MODIFIER_LETTER_TRIANGULAR_COLON				0x02D0
#define MODIFIER_LETTER_HALF_TRIANGULAR_COLON				0x02D1
#define MODIFIER_LETTER_CENTRED_RIGHT_HALF_RING				0x02D2
#define MODIFIER_LETTER_CENTRED_LEFT_HALF_RING				0x02D3
#define MODIFIER_LETTER_UP_TACK						0x02D4
#define MODIFIER_LETTER_DOWN_TACK					0x02D5
#define MODIFIER_LETTER_PLUS_SIGN					0x02D6
#define MODIFIER_LETTER_MINUS_SIGN					0x02D7
#define BREVE								0x02D8
#define DOT_ABOVE							0x02D9
#define RING_ABOVE							0x02DA
#define OGONEK								0x02DB
#define SMALL_TILDE							0x02DC
#define DOUBLE_ACUTE_ACCENT						0x02DD
#define MODIFIER_LETTER_RHOTIC_HOOK					0x02DE
#define MODIFIER_LETTER_CROSS_ACCENT					0x02DF
#define MODIFIER_LETTER_SMALL_GAMMA					0x02E0
#define MODIFIER_LETTER_SMALL_L						0x02E1
#define MODIFIER_LETTER_SMALL_S						0x02E2
#define MODIFIER_LETTER_SMALL_X						0x02E3
#define MODIFIER_LETTER_SMALL_REVERSED_GLOTTAL_STOP			0x02E4
#define MODIFIER_LETTER_EXTRA_HIGH_TONE_BAR				0x02E5
#define MODIFIER_LETTER_HIGH_TONE_BAR					0x02E6
#define MODIFIER_LETTER_MID_TONE_BAR					0x02E7
#define MODIFIER_LETTER_LOW_TONE_BAR					0x02E8
#define MODIFIER_LETTER_EXTRA_LOW_TONE_BAR				0x02E9
#define MODIFIER_LETTER_YIN_DEPARTING_TONE_MARK				0x02EA
#define MODIFIER_LETTER_YANG_DEPARTING_TONE_MARK			0x02EB
#define MODIFIER_LETTER_VOICING						0x02EC
#define MODIFIER_LETTER_UNASPIRATED					0x02ED
#define MODIFIER_LETTER_DOUBLE_APOSTROPHE				0x02EE

/* combining diacritical marks */
#define COMBINING_GRAVE_ACCENT						0x0300
#define COMBINING_ACUTE_ACCENT						0x0301
#define COMBINING_CIRCUMFLEX_ACCENT					0x0302
#define COMBINING_TILDE							0x0303
#define COMBINING_MACRON						0x0304
#define COMBINING_OVERLINE						0x0305
#define COMBINING_BREVE							0x0306
#define COMBINING_DOT_ABOVE						0x0307
#define COMBINING_DIAERESIS						0x0308
#define COMBINING_HOOK_ABOVE						0x0309
#define COMBINING_RING_ABOVE						0x030A
#define COMBINING_DOUBLE_ACUTE_ACCENT					0x030B
#define COMBINING_CARON							0x030C
#define COMBINING_VERTICAL_LINE_ABOVE					0x030D
#define COMBINING_DOUBLE_VERTICAL_LINE_ABOVE				0x030E
#define COMBINING_DOUBLE_GRAVE_ACCENT					0x030F
#define COMBINING_CANDRABINDU						0x0310
#define COMBINING_INVERTED_BREVE					0x0311
#define COMBINING_TURNED_COMMA_ABOVE					0x0312
#define COMBINING_COMMA_ABOVE						0x0313
#define COMBINING_REVERSED_COMMA_ABOVE					0x0314
#define COMBINING_COMMA_ABOVE_RIGHT					0x0315
#define COMBINING_GRAVE_ACCENT_BELOW					0x0316
#define COMBINING_ACUTE_ACCENT_BELOW					0x0317
#define COMBINING_LEFT_TACK_BELOW					0x0318
#define COMBINING_RIGHT_TACK_BELOW					0x0319
#define COMBINING_LEFT_ANGLE_ABOVE					0x031A
#define COMBINING_HORN							0x031B
#define COMBINING_LEFT_HALF_RING_BELOW					0x031C
#define COMBINING_UP_TACK_BELOW						0x031D
#define COMBINING_DOWN_TACK_BELOW					0x031E
#define COMBINING_PLUS_SIGN_BELOW					0x031F
#define COMBINING_MINUS_SIGN_BELOW					0x0320
#define COMBINING_PALATALIZED_HOOK_BELOW				0x0321
#define COMBINING_RETROFLEX_HOOK_BELOW					0x0322
#define COMBINING_DOT_BELOW						0x0323
#define COMBINING_DIAERESIS_BELOW					0x0324
#define COMBINING_RING_BELOW						0x0325
#define COMBINING_COMMA_BELOW						0x0326
#define COMBINING_CEDILLA						0x0327
#define COMBINING_OGONEK						0x0328
#define COMBINING_VERTICAL_LINE_BELOW					0x0329
#define COMBINING_BRIDGE_BELOW						0x032A
#define COMBINING_INVERTED_DOUBLE_ARCH_BELOW				0x032B
#define COMBINING_CARON_BELOW						0x032C
#define COMBINING_CIRCUMFLEX_ACCENT_BELOW				0x032D
#define COMBINING_BREVE_BELOW						0x032E
#define COMBINING_INVERTED_BREVE_BELOW					0x032F
#define COMBINING_TILDE_BELOW						0x0330
#define COMBINING_MACRON_BELOW						0x0331
#define COMBINING_LOW_LINE						0x0332
#define COMBINING_DOUBLE_LOW_LINE					0x0333
#define COMBINING_TILDE_OVERLAY						0x0334
#define COMBINING_SHORT_STROKE_OVERLAY					0x0335
#define COMBINING_LONG_STROKE_OVERLAY					0x0336
#define COMBINING_SHORT_SOLIDUS_OVERLAY					0x0337
#define COMBINING_LONG_SOLIDUS_OVERLAY					0x0338
#define COMBINING_RIGHT_HALF_RING_BELOW					0x0339
#define COMBINING_INVERTED_BRIDGE_BELOW					0x033A
#define COMBINING_SQUARE_BELOW						0x033B
#define COMBINING_SEAGULL_BELOW						0x033C
#define COMBINING_X_ABOVE						0x033D
#define COMBINING_VERTICAL_TILDE					0x033E
#define COMBINING_DOUBLE_OVERLINE					0x033F
#define COMBINING_GRAVE_TONE_MARK					0x0340
#define COMBINING_ACUTE_TONE_MARK					0x0341
#define COMBINING_GREEK_PERISPOMENI					0x0342
#define COMBINING_GREEK_KORONIS						0x0343
#define COMBINING_GREEK_DIALYTIKA_TONOS					0x0344
#define COMBINING_GREEK_YPOGEGRAMMENI					0x0345
#define COMBINING_BRIDGE_ABOVE						0x0346
#define COMBINING_EQUALS_SIGN_BELOW					0x0347
#define COMBINING_DOUBLE_VERTICAL_LINE_BELOW				0x0348
#define COMBINING_LEFT_ANGLE_BELOW					0x0349
#define COMBINING_NOT_TILDE_ABOVE					0x034A
#define COMBINING_HOMOTHETIC_ABOVE					0x034B
#define COMBINING_ALMOST_EQUAL_TO_ABOVE					0x034C
#define COMBINING_LEFT_RIGHT_ARROW_BELOW				0x034D
#define COMBINING_UPWARDS_ARROW_BELOW					0x034E
#define COMBINING_DOUBLE_TILDE						0x0360
#define COMBINING_DOUBLE_INVERTED_BREVE					0x0361
#define COMBINING_DOUBLE_RIGHTWARDS_ARROW_BELOW				0x0362

/* greek letters */
#define GREEK_NUMERAL_SIGN						0x0374
#define GREEK_LOWER_NUMERAL_SIGN					0x0375
#define GREEK_YPOGEGRAMMENI						0x037A
#define GREEK_QUESTION_MARK						0x037E
#define GREEK_TONOS							0x0384
#define GREEK_DIALYTIKA_TONOS						0x0385
#define GREEK_CAPITAL_LETTER_ALPHA_WITH_TONOS				0x0386
#define GREEK_ANO_TELEIA						0x0387
#define GREEK_CAPITAL_LETTER_EPSILON_WITH_TONOS				0x0388
#define GREEK_CAPITAL_LETTER_ETA_WITH_TONOS				0x0389
#define GREEK_CAPITAL_LETTER_IOTA_WITH_TONOS				0x038A
#define GREEK_CAPITAL_LETTER_OMICRON_WITH_TONOS				0x038C
#define GREEK_CAPITAL_LETTER_UPSILON_WITH_TONOS				0x038E
#define GREEK_CAPITAL_LETTER_OMEGA_WITH_TONOS				0x038F
#define GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA_AND_TONOS		0x0390
#define GREEK_CAPITAL_LETTER_ALPHA					0x0391
#define GREEK_CAPITAL_LETTER_BETA					0x0392
#define GREEK_CAPITAL_LETTER_GAMMA					0x0393
#define GREEK_CAPITAL_LETTER_DELTA					0x0394
#define GREEK_CAPITAL_LETTER_EPSILON					0x0395
#define GREEK_CAPITAL_LETTER_ZETA					0x0396
#define GREEK_CAPITAL_LETTER_ETA					0x0397
#define GREEK_CAPITAL_LETTER_THETA					0x0398
#define GREEK_CAPITAL_LETTER_IOTA					0x0399
#define GREEK_CAPITAL_LETTER_KAPPA					0x039A
#define GREEK_CAPITAL_LETTER_LAMDA					0x039B
#define GREEK_CAPITAL_LETTER_MU						0x039C
#define GREEK_CAPITAL_LETTER_NU						0x039D
#define GREEK_CAPITAL_LETTER_XI						0x039E
#define GREEK_CAPITAL_LETTER_OMICRON					0x039F
#define GREEK_CAPITAL_LETTER_PI						0x03A0
#define GREEK_CAPITAL_LETTER_RHO					0x03A1
#define GREEK_CAPITAL_LETTER_SIGMA					0x03A3
#define GREEK_CAPITAL_LETTER_TAU					0x03A4
#define GREEK_CAPITAL_LETTER_UPSILON					0x03A5
#define GREEK_CAPITAL_LETTER_PHI					0x03A6
#define GREEK_CAPITAL_LETTER_CHI					0x03A7
#define GREEK_CAPITAL_LETTER_PSI					0x03A8
#define GREEK_CAPITAL_LETTER_OMEGA					0x03A9
#define GREEK_CAPITAL_LETTER_IOTA_WITH_DIALYTIKA			0x03AA
#define GREEK_CAPITAL_LETTER_UPSILON_WITH_DIALYTIKA			0x03AB
#define GREEK_SMALL_LETTER_ALPHA_WITH_TONOS				0x03AC
#define GREEK_SMALL_LETTER_EPSILON_WITH_TONOS				0x03AD
#define GREEK_SMALL_LETTER_ETA_WITH_TONOS				0x03AE
#define GREEK_SMALL_LETTER_IOTA_WITH_TONOS				0x03AF
#define GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA_AND_TONOS		0x03B0
#define GREEK_SMALL_LETTER_ALPHA					0x03B1
#define GREEK_SMALL_LETTER_BETA						0x03B2
#define GREEK_SMALL_LETTER_GAMMA					0x03B3
#define GREEK_SMALL_LETTER_DELTA					0x03B4
#define GREEK_SMALL_LETTER_EPSILON					0x03B5
#define GREEK_SMALL_LETTER_ZETA						0x03B6
#define GREEK_SMALL_LETTER_ETA						0x03B7
#define GREEK_SMALL_LETTER_THETA					0x03B8
#define GREEK_SMALL_LETTER_IOTA						0x03B9
#define GREEK_SMALL_LETTER_KAPPA					0x03BA
#define GREEK_SMALL_LETTER_LAMDA					0x03BB
#define GREEK_SMALL_LETTER_MU						0x03BC
#define GREEK_SMALL_LETTER_NU						0x03BD
#define GREEK_SMALL_LETTER_XI						0x03BE
#define GREEK_SMALL_LETTER_OMICRON					0x03BF
#define GREEK_SMALL_LETTER_PI						0x03C0
#define GREEK_SMALL_LETTER_RHO						0x03C1
#define GREEK_SMALL_LETTER_FINAL_SIGMA					0x03C2
#define GREEK_SMALL_LETTER_SIGMA					0x03C3
#define GREEK_SMALL_LETTER_TAU						0x03C4
#define GREEK_SMALL_LETTER_UPSILON					0x03C5
#define GREEK_SMALL_LETTER_PHI						0x03C6
#define GREEK_SMALL_LETTER_CHI						0x03C7
#define GREEK_SMALL_LETTER_PSI						0x03C8
#define GREEK_SMALL_LETTER_OMEGA					0x03C9
#define GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA				0x03CA
#define GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA			0x03CB
#define GREEK_SMALL_LETTER_OMICRON_WITH_TONOS				0x03CC
#define GREEK_SMALL_LETTER_UPSILON_WITH_TONOS				0x03CD
#define GREEK_SMALL_LETTER_OMEGA_WITH_TONOS				0x03CE
#define GREEK_BETA_SYMBOL						0x03D0
#define GREEK_THETA_SYMBOL						0x03D1
#define GREEK_UPSILON_WITH_HOOK_SYMBOL					0x03D2
#define GREEK_UPSILON_WITH_ACUTE_AND_HOOK_SYMBOL			0x03D3
#define GREEK_UPSILON_WITH_DIAERESIS_AND_HOOK_SYMBOL			0x03D4
#define GREEK_PHI_SYMBOL						0x03D5
#define GREEK_PI_SYMBOL							0x03D6
#define GREEK_KAI_SYMBOL						0x03D7
#define GREEK_LETTER_STIGMA						0x03DA
#define GREEK_SMALL_LETTER_STIGMA					0x03DB
#define GREEK_LETTER_DIGAMMA						0x03DC
#define GREEK_SMALL_LETTER_DIGAMMA					0x03DD
#define GREEK_LETTER_KOPPA						0x03DE
#define GREEK_SMALL_LETTER_KOPPA					0x03DF
#define GREEK_LETTER_SAMPI						0x03E0
#define GREEK_SMALL_LETTER_SAMPI					0x03E1

/* general punctuation (partial) */
#define HYPHEN								0x2010
#define NON_BREAKING_HYPHEN						0x2011
#define FIGURE_DASH							0x2012
#define EN_DASH								0x2013
#define EM_DASH								0x2014
#define HORIZONTAL_BAR							0x2015
#define LEFT_SINGLE_QUOTATION_MARK					0x2018
#define RIGHT_SINGLE_QUOTATION_MARK					0x2019
#define SINGLE_LOW_9_QUOTATION_MARK					0x201A
#define SINGLE_HIGH_REVERSED_9_QUOTATION_MARK				0x201B
#define LEFT_DOUBLE_QUOTATION_MARK					0x201C
#define RIGHT_DOUBLE_QUOTATION_MARK					0x201D
#define DOUBLE_LOW_9_QUOTATION_MARK					0x201E
#define DOUBLE_HIGH_REVERSED_9_QUOTATION_MARK				0x201F
#define DAGGER								0x2020
#define DOUBLE_DAGGER							0x2021
#define BULLET								0x2022
#define TRIANGULAR_BULLET						0x2023
#define HYPHENATION_POINT						0x2027
#define HORIZONTAL_ELLIPSIS						0x2026
#define PER_MILLE_SIGN							0x2030
#define SINGLE_LEFT_POINTING_ANGLE_QUOTATION_MARK			0x2039
#define SINGLE_RIGHT_POINTING_ANGLE_QUOTATION_MARK			0x203A
#define EURO_CURRENCY_SIGN                                              0x20AC

/* mathematical operators */
#define FOR_ALL								0x2200
#define COMPLEMENT							0x2201
#define PARTIAL_DIFFERENTIAL						0x2202
#define THERE_EXISTS							0x2203
#define THERE_DOES_NOT_EXIST						0x2204
#define EMPTY_SET							0x2205
#define INCREMENT							0x2206
#define NABLA								0x2207
#define ELEMENT_OF							0x2208
#define NOT_AN_ELEMENT_OF						0x2209
#define SMALL_ELEMENT_OF						0x220A
#define CONTAINS_AS_MEMBER						0x220B
#define DOES_NOT_CONTAIN_AS_MEMBER					0x220C
#define SMALL_CONTAINS_AS_MEMBER					0x220D
#define END_OF_PROOF							0x220E
#define N_ARY_PRODUCT							0x220F
#define N_ARY_COPRODUCT							0x2210
#define N_ARY_SUMMATION							0x2211
#define MINUS_SIGN							0x2212
#define MINUS_OR_PLUS_SIGN						0x2213
#define DOT_PLUS							0x2214
#define DIVISION_SLASH							0x2215
#define SET_MINUS							0x2216
#define ASTERISK_OPERATOR						0x2217
#define RING_OPERATOR							0x2218
#define BULLET_OPERATOR							0x2219
#define SQUARE_ROOT							0x221A
#define CUBE_ROOT							0x221B
#define FOURTH_ROOT							0x221C
#define PROPORTIONAL_TO							0x221D
/* INFINITY conflicts with math.h */
#define INFINITY							0x221E
#define RIGHT_ANGLE							0x221F
#define ANGLE								0x2220
#define MEASURED_ANGLE							0x2221
#define SPHERICAL_ANGLE							0x2222
#define DIVIDES								0x2223
#define DOES_NOT_DIVIDE							0x2224
#define PARALLEL_TO							0x2225
#define NOT_PARALLEL_TO							0x2226
#define LOGICAL_AND							0x2227
#define LOGICAL_OR							0x2228
#define INTERSECTION							0x2229
#define UNION								0x222A
#define INTEGRAL							0x222B
#define DOUBLE_INTEGRAL							0x222C
#define TRIPLE_INTEGRAL							0x222D
#define CONTOUR_INTEGRAL						0x222E
#define SURFACE_INTEGRAL						0x222F
#define VOLUME_INTEGRAL							0x2230
#define CLOCKWISE_INTEGRAL						0x2231
#define CLOCKWISE_CONTOUR_INTEGRAL					0x2232
#define ANTICLOCKWISE_CONTOUR_INTEGRAL					0x2233
#define THEREFORE							0x2234
#define BECAUSE								0x2235
#define RATIO								0x2236
#define PROPORTION							0x2237
#define DOT_MINUS							0x2238
#define EXCESS								0x2239
#define GEOMETRIC_PROPORTION						0x223A
#define HOMOTHETIC							0x223B
#define TILDE_OPERATOR							0x223C
#define REVERSED_TILDE							0x223D
#define INVERTED_LAZY_S							0x223E
#define SINE_WAVE							0x223F
#define WREATH_PRODUCT							0x2240
#define NOT_TILDE							0x2241
#define MINUS_TILDE							0x2242
#define ASYMPTOTICALLY_EQUAL_TO						0x2243
#define NOT_ASYMPTOTICALLY_EQUAL_TO					0x2244
#define APPROXIMATELY_EQUAL_TO						0x2245
#define APPROXIMATELY_BUT_NOT_ACTUALLY_EQUAL_TO				0x2246
#define NEITHER_APPROXIMATELY_NOR_ACTUALLY_EQUAL_TO			0x2247
#define ALMOST_EQUAL_TO							0x2248
#define NOT_ALMOST_EQUAL_TO						0x2249
#define ALMOST_EQUAL_OR_EQUAL_TO					0x224A
#define TRIPLE_TILDE							0x224B
#define ALL_EQUAL_TO							0x224C
#define EQUIVALENT_TO							0x224D
#define GEOMETRICALLY_EQUIVALENT_TO					0x224E
#define DIFFERENCE_BETWEEN						0x224F
#define APPROACHES_THE_LIMIT						0x2250
#define GEOMETRICALLY_EQUAL_TO						0x2251
#define APPROXIMATELY_EQUAL_TO_OR_THE_IMAGE_OF				0x2252
#define IMAGE_OF_OR_APPROXIMATELY_EQUAL_TO				0x2253
#define COLON_EQUALS							0x2254
#define EQUALS_COLON							0x2255
#define RING_IN_EQUAL_TO						0x2256
#define RING_EQUAL_TO							0x2257
#define CORRESPONDS_TO							0x2258
#define ESTIMATES							0x2259
#define EQUIANGULAR_TO							0x225A
#define STAR_EQUALS							0x225B
#define DELTA_EQUAL_TO							0x225C
#define EQUAL_TO_BY_DEFINITION						0x225D
#define MEASURED_BY							0x225E
#define QUESTIONED_EQUAL_TO						0x225F
#define NOT_EQUAL_TO							0x2260
#define IDENTICAL_TO							0x2261
#define NOT_IDENTICAL_TO						0x2262
#define STRICTLY_EQUIVALENT_TO						0x2263
#define LESS_THAN_OR_EQUAL_TO						0x2264
#define GREATER_THAN_OR_EQUAL_TO					0x2265
#define LESS_THAN_OVER_EQUAL_TO						0x2266
#define GREATER_THAN_OVER_EQUAL_TO					0x2267
#define LESS_THAN_BUT_NOT_EQUAL_TO					0x2268
#define GREATER_THAN_BUT_NOT_EQUAL_TO					0x2269
#define MUCH_LESS_THAN							0x226A
#define MUCH_GREATER_THAN						0x226B
#define BETWEEN								0x226C
#define NOT_EQUIVALENT_TO						0x226D
#define NOT_LESS_THAN							0x226E
#define NOT_GREATER_THAN						0x226F
#define NEITHER_LESS_THAN_NOR_EQUAL_TO					0x2270
#define NEITHER_GREATER_THAN_NOR_EQUAL_TO				0x2271
#define LESS_THAN_OR_EQUIVALENT_TO					0x2272
#define GREATER_THAN_OR_EQUIVALENT_TO					0x2273
#define NEITHER_LESS_THAN_NOR_EQUIVALENT_TO				0x2274
#define NEITHER_GREATER_THAN_NOR_EQUIVALENT_TO				0x2275
#define LESS_THAN_OR_GREATER_THAN					0x2276
#define GREATER_THAN_OR_LESS_THAN					0x2277
#define NEITHER_LESS_THAN_NOR_GREATER_THAN				0x2278
#define NEITHER_GREATER_THAN_NOR_LESS_THAN				0x2279
#define PRECEDES							0x227A
#define SUCCEEDS							0x227B
#define PRECEDES_OR_EQUAL_TO						0x227C
#define SUCCEEDS_OR_EQUAL_TO						0x227D
#define PRECEDES_OR_EQUIVALENT_TO					0x227E
#define SUCCEEDS_OR_EQUIVALENT_TO					0x227F
#define DOES_NOT_PRECEDE						0x2280
#define DOES_NOT_SUCCEED						0x2281
#define SUBSET_OF							0x2282
#define SUPERSET_OF							0x2283
#define NOT_A_SUBSET_OF							0x2284
#define NOT_A_SUPERSET_OF						0x2285
#define SUBSET_OF_OR_EQUAL_TO						0x2286
#define SUPERSET_OF_OR_EQUAL_TO						0x2287
#define NEITHER_A_SUBSET_OF_NOR_EQUAL_TO				0x2288
#define NEITHER_A_SUPERSET_OF_NOR_EQUAL_TO				0x2289
#define SUBSET_OF_WITH_NOT_EQUAL_TO					0x228A
#define SUPERSET_OF_WITH_NOT_EQUAL_TO					0x228B
#define MULTISET							0x228C
#define MULTISET_MULTIPLICATION						0x228D
#define MULTISET_UNION							0x228E
#define SQUARE_IMAGE_OF							0x228F
#define SQUARE_ORIGINAL_OF						0x2290
#define SQUARE_IMAGE_OF_OR_EQUAL_TO					0x2291
#define SQUARE_ORIGINAL_OF_OR_EQUAL_TO					0x2292
#define SQUARE_CAP							0x2293
#define SQUARE_CUP							0x2294
#define CIRCLED_PLUS							0x2295
#define CIRCLED_MINUS							0x2296
#define CIRCLED_TIMES							0x2297
#define CIRCLED_DIVISION_SLASH						0x2298
#define CIRCLED_DOT_OPERATOR						0x2299
#define CIRCLED_RING_OPERATOR						0x229A
#define CIRCLED_ASTERISK_OPERATOR					0x229B
#define CIRCLED_EQUALS							0x229C
#define CIRCLED_DASH							0x229D
#define SQUARED_PLUS							0x229E
#define SQUARED_MINUS							0x229F
#define SQUARED_TIMES							0x22A0
#define SQUARED_DOT_OPERATOR						0x22A1
#define RIGHT_TACK							0x22A2
#define LEFT_TACK							0x22A3
#define DOWN_TACK							0x22A4
#define UP_TACK								0x22A5
#define ASSERTION							0x22A6
#define MODELS								0x22A7
#define TRUE								0x22A8
#define FORCES								0x22A9
#define TRIPLE_VERTICAL_BAR_RIGHT_TURNSTILE				0x22AA
#define DOUBLE_VERTICAL_BAR_DOUBLE_RIGHT_TURNSTILE			0x22AB
#define DOES_NOT_PROVE							0x22AC
#define NOT_TRUE							0x22AD
#define DOES_NOT_FORCE							0x22AE
#define NEGATED_DOUBLE_VERTICAL_BAR_DOUBLE_RIGHT_TURNSTILE		0x22AF
#define PRECEDES_UNDER_RELATION						0x22B0
#define SUCCEEDS_UNDER_RELATION						0x22B1
#define NORMAL_SUBGROUP_OF						0x22B2
#define CONTAINS_AS_NORMAL_SUBGROUP					0x22B3
#define NORMAL_SUBGROUP_OF_OR_EQUAL_TO					0x22B4
#define CONTAINS_AS_NORMAL_SUBGROUP_OR_EQUAL_TO				0x22B5
#define ORIGINAL_OF							0x22B6
#define IMAGE_OF							0x22B7
#define MULTIMAP							0x22B8
#define HERMITIAN_CONJUGATE_MATRIX					0x22B9
#define INTERCALATE							0x22BA
#define XOR								0x22BB
#define NAND								0x22BC
#define NOR								0x22BD
#define RIGHT_ANGLE_WITH_ARC						0x22BE
#define RIGHT_TRIANGLE							0x22BF
#define N_ARY_LOGICAL_AND						0x22C0
#define N_ARY_LOGICAL_OR						0x22C1
#define N_ARY_INTERSECTION						0x22C2
#define N_ARY_UNION							0x22C3
#define DIAMOND_OPERATOR						0x22C4
#define DOT_OPERATOR							0x22C5
#define STAR_OPERATOR							0x22C6
#define DIVISION_TIMES							0x22C7
#define BOWTIE								0x22C8
#define LEFT_NORMAL_FACTOR_SEMIDIRECT_PRODUCT				0x22C9
#define RIGHT_NORMAL_FACTOR_SEMIDIRECT_PRODUCT				0x22CA
#define LEFT_SEMIDIRECT_PRODUCT						0x22CB
#define RIGHT_SEMIDIRECT_PRODUCT					0x22CC
#define REVERSED_TILDE_EQUALS						0x22CD
#define CURLY_LOGICAL_OR						0x22CE
#define CURLY_LOGICAL_AND						0x22CF
#define DOUBLE_SUBSET							0x22D0
#define DOUBLE_SUPERSET							0x22D1
#define DOUBLE_INTERSECTION						0x22D2
#define DOUBLE_UNION							0x22D3
#define PITCHFORK							0x22D4
#define EQUAL_AND_PARALLEL_TO						0x22D5
#define LESS_THAN_WITH_DOT						0x22D6
#define GREATER_THAN_WITH_DOT						0x22D7
#define VERY_MUCH_LESS_THAN						0x22D8
#define VERY_MUCH_GREATER_THAN						0x22D9
#define LESS_THAN_EQUAL_TO_OR_GREATER_THAN				0x22DA
#define GREATER_THAN_EQUAL_TO_OR_LESS_THAN				0x22DB
#define EQUAL_TO_OR_LESS_THAN						0x22DC
#define EQUAL_TO_OR_GREATER_THAN					0x22DD
#define EQUAL_TO_OR_PRECEDES						0x22DE
#define EQUAL_TO_OR_SUCCEEDS						0x22DF
#define DOES_NOT_PRECEDE_OR_EQUAL					0x22E0
#define DOES_NOT_SUCCEED_OR_EQUAL					0x22E1
#define NOT_SQUARE_IMAGE_OF_OR_EQUAL_TO					0x22E2
#define NOT_SQUARE_ORIGINAL_OF_OR_EQUAL_TO				0x22E3
#define SQUARE_IMAGE_OF_OR_NOT_EQUAL_TO					0x22E4
#define SQUARE_ORIGINAL_OF_OR_NOT_EQUAL_TO				0x22E5
#define LESS_THAN_BUT_NOT_EQUIVALENT_TO					0x22E6
#define GREATER_THAN_BUT_NOT_EQUIVALENT_TO				0x22E7
#define PRECEDES_BUT_NOT_EQUIVALENT_TO					0x22E8
#define SUCCEEDS_BUT_NOT_EQUIVALENT_TO					0x22E9
#define NOT_NORMAL_SUBGROUP_OF						0x22EA
#define DOES_NOT_CONTAIN_AS_NORMAL_SUBGROUP				0x22EB
#define NOT_NORMAL_SUBGROUP_OF_OR_EQUAL_TO				0x22EC
#define DOES_NOT_CONTAIN_AS_NORMAL_SUBGROUP_OR_EQUAL			0x22ED
#define VERTICAL_ELLIPSIS						0x22EE
#define MIDLINE_HORIZONTAL_ELLIPSIS					0x22EF
#define UP_RIGHT_DIAGONAL_ELLIPSIS					0x22F0
#define DOWN_RIGHT_DIAGONAL_ELLIPSIS					0x22F1

/* Optical Character Recognition in Unicode (see wikipedia/OCR)
 * range: 0x2440-0x245F
 */
#define OCR_Hook                         0x2440
#define OCR_Chair                        0x2441
#define OCR_Fork                         0x2442
#define OCR_Inverted_Fork                0x2443
#define OCR_Belt_Buckle                  0x2444
#define OCR_Bow_Tie                      0x2445

/* the following 4 MICR chars (magnetic ink character recognition)
 * They look like:  |:  ,|'  ||'  |||  (known also as MICR-A,B,C,D)
 */
#define OCR_Branch_Bank_Identification   0x2446
#define OCR_Amount_Of_Check              0x2447
#define OCR_Customer_Account_Number      0x2448
#define OCR_Dash                         0x2449

#define OCR_Double_Backslash             0x244A

/* latin ligatures */
#define LATIN_SMALL_LIGATURE_FF						0xFB00
#define LATIN_SMALL_LIGATURE_FI						0xFB01
#define LATIN_SMALL_LIGATURE_FL						0xFB02
#define LATIN_SMALL_LIGATURE_FFI					0xFB03
#define LATIN_SMALL_LIGATURE_FFL					0xFB04
#define LATIN_SMALL_LIGATURE_LONG_S_T					0xFB05
#define LATIN_SMALL_LIGATURE_ST						0xFB06

#endif
