// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/cloud/billing/v1/cloud_billing.proto
// DO NOT EDIT!

/*
Package google_cloud_billing_v1 is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/genproto/googleapis/cloud/billing/v1/cloud_billing.proto

It has these top-level messages:
	BillingAccount
	ProjectBillingInfo
	GetBillingAccountRequest
	ListBillingAccountsRequest
	ListBillingAccountsResponse
	ListProjectBillingInfoRequest
	ListProjectBillingInfoResponse
	GetProjectBillingInfoRequest
	UpdateProjectBillingInfoRequest
*/
package google_cloud_billing_v1 // import "google.golang.org/genproto/googleapis/cloud/billing/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// A billing account in [Google Cloud
// Console](https://console.cloud.google.com/). You can assign a billing account
// to one or more projects.
type BillingAccount struct {
	// The resource name of the billing account. The resource name has the form
	// `billingAccounts/{billing_account_id}`. For example,
	// `billingAccounts/012345-567890-ABCDEF` would be the resource name for
	// billing account `012345-567890-ABCDEF`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// True if the billing account is open, and will therefore be charged for any
	// usage on associated projects. False if the billing account is closed, and
	// therefore projects associated with it will be unable to use paid services.
	Open bool `protobuf:"varint,2,opt,name=open" json:"open,omitempty"`
	// The display name given to the billing account, such as `My Billing
	// Account`. This name is displayed in the Google Cloud Console.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
}

func (m *BillingAccount) Reset()                    { *m = BillingAccount{} }
func (m *BillingAccount) String() string            { return proto.CompactTextString(m) }
func (*BillingAccount) ProtoMessage()               {}
func (*BillingAccount) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// Encapsulation of billing information for a Cloud Console project. A project
// has at most one associated billing account at a time (but a billing account
// can be assigned to multiple projects).
type ProjectBillingInfo struct {
	// The resource name for the `ProjectBillingInfo`; has the form
	// `projects/{project_id}/billingInfo`. For example, the resource name for the
	// billing information for project `tokyo-rain-123` would be
	// `projects/tokyo-rain-123/billingInfo`. This field is read-only.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The ID of the project that this `ProjectBillingInfo` represents, such as
	// `tokyo-rain-123`. This is a convenience field so that you don't need to
	// parse the `name` field to obtain a project ID. This field is read-only.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The resource name of the billing account associated with the project, if
	// any. For example, `billingAccounts/012345-567890-ABCDEF`.
	BillingAccountName string `protobuf:"bytes,3,opt,name=billing_account_name,json=billingAccountName" json:"billing_account_name,omitempty"`
	// True if the project is associated with an open billing account, to which
	// usage on the project is charged. False if the project is associated with a
	// closed billing account, or no billing account at all, and therefore cannot
	// use paid services. This field is read-only.
	BillingEnabled bool `protobuf:"varint,4,opt,name=billing_enabled,json=billingEnabled" json:"billing_enabled,omitempty"`
}

func (m *ProjectBillingInfo) Reset()                    { *m = ProjectBillingInfo{} }
func (m *ProjectBillingInfo) String() string            { return proto.CompactTextString(m) }
func (*ProjectBillingInfo) ProtoMessage()               {}
func (*ProjectBillingInfo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// Request message for `GetBillingAccount`.
type GetBillingAccountRequest struct {
	// The resource name of the billing account to retrieve. For example,
	// `billingAccounts/012345-567890-ABCDEF`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetBillingAccountRequest) Reset()                    { *m = GetBillingAccountRequest{} }
func (m *GetBillingAccountRequest) String() string            { return proto.CompactTextString(m) }
func (*GetBillingAccountRequest) ProtoMessage()               {}
func (*GetBillingAccountRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

// Request message for `ListBillingAccounts`.
type ListBillingAccountsRequest struct {
	// Requested page size. The maximum page size is 100; this is also the
	// default.
	PageSize int32 `protobuf:"varint,1,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// A token identifying a page of results to return. This should be a
	// `next_page_token` value returned from a previous `ListBillingAccounts`
	// call. If unspecified, the first page of results is returned.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListBillingAccountsRequest) Reset()                    { *m = ListBillingAccountsRequest{} }
func (m *ListBillingAccountsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListBillingAccountsRequest) ProtoMessage()               {}
func (*ListBillingAccountsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

// Response message for `ListBillingAccounts`.
type ListBillingAccountsResponse struct {
	// A list of billing accounts.
	BillingAccounts []*BillingAccount `protobuf:"bytes,1,rep,name=billing_accounts,json=billingAccounts" json:"billing_accounts,omitempty"`
	// A token to retrieve the next page of results. To retrieve the next page,
	// call `ListBillingAccounts` again with the `page_token` field set to this
	// value. This field is empty if there are no more results to retrieve.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListBillingAccountsResponse) Reset()                    { *m = ListBillingAccountsResponse{} }
func (m *ListBillingAccountsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListBillingAccountsResponse) ProtoMessage()               {}
func (*ListBillingAccountsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *ListBillingAccountsResponse) GetBillingAccounts() []*BillingAccount {
	if m != nil {
		return m.BillingAccounts
	}
	return nil
}

// Request message for `ListProjectBillingInfo`.
type ListProjectBillingInfoRequest struct {
	// The resource name of the billing account associated with the projects that
	// you want to list. For example, `billingAccounts/012345-567890-ABCDEF`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Requested page size. The maximum page size is 100; this is also the
	// default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// A token identifying a page of results to be returned. This should be a
	// `next_page_token` value returned from a previous `ListProjectBillingInfo`
	// call. If unspecified, the first page of results is returned.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListProjectBillingInfoRequest) Reset()                    { *m = ListProjectBillingInfoRequest{} }
func (m *ListProjectBillingInfoRequest) String() string            { return proto.CompactTextString(m) }
func (*ListProjectBillingInfoRequest) ProtoMessage()               {}
func (*ListProjectBillingInfoRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

// Request message for `ListProjectBillingInfoResponse`.
type ListProjectBillingInfoResponse struct {
	// A list of `ProjectBillingInfo` resources representing the projects
	// associated with the billing account.
	ProjectBillingInfo []*ProjectBillingInfo `protobuf:"bytes,1,rep,name=project_billing_info,json=projectBillingInfo" json:"project_billing_info,omitempty"`
	// A token to retrieve the next page of results. To retrieve the next page,
	// call `ListProjectBillingInfo` again with the `page_token` field set to this
	// value. This field is empty if there are no more results to retrieve.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListProjectBillingInfoResponse) Reset()                    { *m = ListProjectBillingInfoResponse{} }
func (m *ListProjectBillingInfoResponse) String() string            { return proto.CompactTextString(m) }
func (*ListProjectBillingInfoResponse) ProtoMessage()               {}
func (*ListProjectBillingInfoResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *ListProjectBillingInfoResponse) GetProjectBillingInfo() []*ProjectBillingInfo {
	if m != nil {
		return m.ProjectBillingInfo
	}
	return nil
}

// Request message for `GetProjectBillingInfo`.
type GetProjectBillingInfoRequest struct {
	// The resource name of the project for which billing information is
	// retrieved. For example, `projects/tokyo-rain-123`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetProjectBillingInfoRequest) Reset()                    { *m = GetProjectBillingInfoRequest{} }
func (m *GetProjectBillingInfoRequest) String() string            { return proto.CompactTextString(m) }
func (*GetProjectBillingInfoRequest) ProtoMessage()               {}
func (*GetProjectBillingInfoRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

// Request message for `UpdateProjectBillingInfo`.
type UpdateProjectBillingInfoRequest struct {
	// The resource name of the project associated with the billing information
	// that you want to update. For example, `projects/tokyo-rain-123`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The new billing information for the project. Read-only fields are ignored;
	// thus, you may leave empty all fields except `billing_account_name`.
	ProjectBillingInfo *ProjectBillingInfo `protobuf:"bytes,2,opt,name=project_billing_info,json=projectBillingInfo" json:"project_billing_info,omitempty"`
}

func (m *UpdateProjectBillingInfoRequest) Reset()                    { *m = UpdateProjectBillingInfoRequest{} }
func (m *UpdateProjectBillingInfoRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateProjectBillingInfoRequest) ProtoMessage()               {}
func (*UpdateProjectBillingInfoRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *UpdateProjectBillingInfoRequest) GetProjectBillingInfo() *ProjectBillingInfo {
	if m != nil {
		return m.ProjectBillingInfo
	}
	return nil
}

func init() {
	proto.RegisterType((*BillingAccount)(nil), "google.cloud.billing.v1.BillingAccount")
	proto.RegisterType((*ProjectBillingInfo)(nil), "google.cloud.billing.v1.ProjectBillingInfo")
	proto.RegisterType((*GetBillingAccountRequest)(nil), "google.cloud.billing.v1.GetBillingAccountRequest")
	proto.RegisterType((*ListBillingAccountsRequest)(nil), "google.cloud.billing.v1.ListBillingAccountsRequest")
	proto.RegisterType((*ListBillingAccountsResponse)(nil), "google.cloud.billing.v1.ListBillingAccountsResponse")
	proto.RegisterType((*ListProjectBillingInfoRequest)(nil), "google.cloud.billing.v1.ListProjectBillingInfoRequest")
	proto.RegisterType((*ListProjectBillingInfoResponse)(nil), "google.cloud.billing.v1.ListProjectBillingInfoResponse")
	proto.RegisterType((*GetProjectBillingInfoRequest)(nil), "google.cloud.billing.v1.GetProjectBillingInfoRequest")
	proto.RegisterType((*UpdateProjectBillingInfoRequest)(nil), "google.cloud.billing.v1.UpdateProjectBillingInfoRequest")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for CloudBilling service

type CloudBillingClient interface {
	// Gets information about a billing account. The current authenticated user
	// must be an [owner of the billing
	// account](https://support.google.com/cloud/answer/4430947).
	GetBillingAccount(ctx context.Context, in *GetBillingAccountRequest, opts ...grpc.CallOption) (*BillingAccount, error)
	// Lists the billing accounts that the current authenticated user
	// [owns](https://support.google.com/cloud/answer/4430947).
	ListBillingAccounts(ctx context.Context, in *ListBillingAccountsRequest, opts ...grpc.CallOption) (*ListBillingAccountsResponse, error)
	// Lists the projects associated with a billing account. The current
	// authenticated user must be an [owner of the billing
	// account](https://support.google.com/cloud/answer/4430947).
	ListProjectBillingInfo(ctx context.Context, in *ListProjectBillingInfoRequest, opts ...grpc.CallOption) (*ListProjectBillingInfoResponse, error)
	// Gets the billing information for a project. The current authenticated user
	// must have [permission to view the
	// project](https://cloud.google.com/docs/permissions-overview#h.bgs0oxofvnoo
	// ).
	GetProjectBillingInfo(ctx context.Context, in *GetProjectBillingInfoRequest, opts ...grpc.CallOption) (*ProjectBillingInfo, error)
	// Sets or updates the billing account associated with a project. You specify
	// the new billing account by setting the `billing_account_name` in the
	// `ProjectBillingInfo` resource to the resource name of a billing account.
	// Associating a project with an open billing account enables billing on the
	// project and allows charges for resource usage. If the project already had a
	// billing account, this method changes the billing account used for resource
	// usage charges.
	//
	// *Note:* Incurred charges that have not yet been reported in the transaction
	// history of the Google Cloud Console may be billed to the new billing
	// account, even if the charge occurred before the new billing account was
	// assigned to the project.
	//
	// The current authenticated user must have ownership privileges for both the
	// [project](https://cloud.google.com/docs/permissions-overview#h.bgs0oxofvnoo
	// ) and the [billing
	// account](https://support.google.com/cloud/answer/4430947).
	//
	// You can disable billing on the project by setting the
	// `billing_account_name` field to empty. This action disassociates the
	// current billing account from the project. Any billable activity of your
	// in-use services will stop, and your application could stop functioning as
	// expected. Any unbilled charges to date will be billed to the previously
	// associated account. The current authenticated user must be either an owner
	// of the project or an owner of the billing account for the project.
	//
	// Note that associating a project with a *closed* billing account will have
	// much the same effect as disabling billing on the project: any paid
	// resources used by the project will be shut down. Thus, unless you wish to
	// disable billing, you should always call this method with the name of an
	// *open* billing account.
	UpdateProjectBillingInfo(ctx context.Context, in *UpdateProjectBillingInfoRequest, opts ...grpc.CallOption) (*ProjectBillingInfo, error)
}

type cloudBillingClient struct {
	cc *grpc.ClientConn
}

func NewCloudBillingClient(cc *grpc.ClientConn) CloudBillingClient {
	return &cloudBillingClient{cc}
}

func (c *cloudBillingClient) GetBillingAccount(ctx context.Context, in *GetBillingAccountRequest, opts ...grpc.CallOption) (*BillingAccount, error) {
	out := new(BillingAccount)
	err := grpc.Invoke(ctx, "/google.cloud.billing.v1.CloudBilling/GetBillingAccount", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBillingClient) ListBillingAccounts(ctx context.Context, in *ListBillingAccountsRequest, opts ...grpc.CallOption) (*ListBillingAccountsResponse, error) {
	out := new(ListBillingAccountsResponse)
	err := grpc.Invoke(ctx, "/google.cloud.billing.v1.CloudBilling/ListBillingAccounts", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBillingClient) ListProjectBillingInfo(ctx context.Context, in *ListProjectBillingInfoRequest, opts ...grpc.CallOption) (*ListProjectBillingInfoResponse, error) {
	out := new(ListProjectBillingInfoResponse)
	err := grpc.Invoke(ctx, "/google.cloud.billing.v1.CloudBilling/ListProjectBillingInfo", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBillingClient) GetProjectBillingInfo(ctx context.Context, in *GetProjectBillingInfoRequest, opts ...grpc.CallOption) (*ProjectBillingInfo, error) {
	out := new(ProjectBillingInfo)
	err := grpc.Invoke(ctx, "/google.cloud.billing.v1.CloudBilling/GetProjectBillingInfo", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBillingClient) UpdateProjectBillingInfo(ctx context.Context, in *UpdateProjectBillingInfoRequest, opts ...grpc.CallOption) (*ProjectBillingInfo, error) {
	out := new(ProjectBillingInfo)
	err := grpc.Invoke(ctx, "/google.cloud.billing.v1.CloudBilling/UpdateProjectBillingInfo", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for CloudBilling service

type CloudBillingServer interface {
	// Gets information about a billing account. The current authenticated user
	// must be an [owner of the billing
	// account](https://support.google.com/cloud/answer/4430947).
	GetBillingAccount(context.Context, *GetBillingAccountRequest) (*BillingAccount, error)
	// Lists the billing accounts that the current authenticated user
	// [owns](https://support.google.com/cloud/answer/4430947).
	ListBillingAccounts(context.Context, *ListBillingAccountsRequest) (*ListBillingAccountsResponse, error)
	// Lists the projects associated with a billing account. The current
	// authenticated user must be an [owner of the billing
	// account](https://support.google.com/cloud/answer/4430947).
	ListProjectBillingInfo(context.Context, *ListProjectBillingInfoRequest) (*ListProjectBillingInfoResponse, error)
	// Gets the billing information for a project. The current authenticated user
	// must have [permission to view the
	// project](https://cloud.google.com/docs/permissions-overview#h.bgs0oxofvnoo
	// ).
	GetProjectBillingInfo(context.Context, *GetProjectBillingInfoRequest) (*ProjectBillingInfo, error)
	// Sets or updates the billing account associated with a project. You specify
	// the new billing account by setting the `billing_account_name` in the
	// `ProjectBillingInfo` resource to the resource name of a billing account.
	// Associating a project with an open billing account enables billing on the
	// project and allows charges for resource usage. If the project already had a
	// billing account, this method changes the billing account used for resource
	// usage charges.
	//
	// *Note:* Incurred charges that have not yet been reported in the transaction
	// history of the Google Cloud Console may be billed to the new billing
	// account, even if the charge occurred before the new billing account was
	// assigned to the project.
	//
	// The current authenticated user must have ownership privileges for both the
	// [project](https://cloud.google.com/docs/permissions-overview#h.bgs0oxofvnoo
	// ) and the [billing
	// account](https://support.google.com/cloud/answer/4430947).
	//
	// You can disable billing on the project by setting the
	// `billing_account_name` field to empty. This action disassociates the
	// current billing account from the project. Any billable activity of your
	// in-use services will stop, and your application could stop functioning as
	// expected. Any unbilled charges to date will be billed to the previously
	// associated account. The current authenticated user must be either an owner
	// of the project or an owner of the billing account for the project.
	//
	// Note that associating a project with a *closed* billing account will have
	// much the same effect as disabling billing on the project: any paid
	// resources used by the project will be shut down. Thus, unless you wish to
	// disable billing, you should always call this method with the name of an
	// *open* billing account.
	UpdateProjectBillingInfo(context.Context, *UpdateProjectBillingInfoRequest) (*ProjectBillingInfo, error)
}

func RegisterCloudBillingServer(s *grpc.Server, srv CloudBillingServer) {
	s.RegisterService(&_CloudBilling_serviceDesc, srv)
}

func _CloudBilling_GetBillingAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBillingAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBillingServer).GetBillingAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.billing.v1.CloudBilling/GetBillingAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBillingServer).GetBillingAccount(ctx, req.(*GetBillingAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBilling_ListBillingAccounts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBillingAccountsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBillingServer).ListBillingAccounts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.billing.v1.CloudBilling/ListBillingAccounts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBillingServer).ListBillingAccounts(ctx, req.(*ListBillingAccountsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBilling_ListProjectBillingInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProjectBillingInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBillingServer).ListProjectBillingInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.billing.v1.CloudBilling/ListProjectBillingInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBillingServer).ListProjectBillingInfo(ctx, req.(*ListProjectBillingInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBilling_GetProjectBillingInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProjectBillingInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBillingServer).GetProjectBillingInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.billing.v1.CloudBilling/GetProjectBillingInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBillingServer).GetProjectBillingInfo(ctx, req.(*GetProjectBillingInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBilling_UpdateProjectBillingInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateProjectBillingInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBillingServer).UpdateProjectBillingInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.billing.v1.CloudBilling/UpdateProjectBillingInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBillingServer).UpdateProjectBillingInfo(ctx, req.(*UpdateProjectBillingInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CloudBilling_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.billing.v1.CloudBilling",
	HandlerType: (*CloudBillingServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetBillingAccount",
			Handler:    _CloudBilling_GetBillingAccount_Handler,
		},
		{
			MethodName: "ListBillingAccounts",
			Handler:    _CloudBilling_ListBillingAccounts_Handler,
		},
		{
			MethodName: "ListProjectBillingInfo",
			Handler:    _CloudBilling_ListProjectBillingInfo_Handler,
		},
		{
			MethodName: "GetProjectBillingInfo",
			Handler:    _CloudBilling_GetProjectBillingInfo_Handler,
		},
		{
			MethodName: "UpdateProjectBillingInfo",
			Handler:    _CloudBilling_UpdateProjectBillingInfo_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google.golang.org/genproto/googleapis/cloud/billing/v1/cloud_billing.proto",
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/cloud/billing/v1/cloud_billing.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 670 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xa4, 0x55, 0xdf, 0x4e, 0xd4, 0x4e,
	0x14, 0xce, 0x00, 0x3f, 0xc2, 0x1e, 0xf8, 0x81, 0x0c, 0xa0, 0x9b, 0x5d, 0x40, 0xa8, 0x7f, 0x40,
	0x8d, 0xad, 0x2c, 0xfe, 0x4f, 0x8c, 0x11, 0x63, 0x08, 0xc6, 0x98, 0xcd, 0xaa, 0x89, 0x89, 0x31,
	0x9b, 0xd9, 0xee, 0xd0, 0x8c, 0x96, 0x99, 0xba, 0x53, 0x88, 0x62, 0xbc, 0xf1, 0x15, 0xd4, 0x0b,
	0x2f, 0xbc, 0xf1, 0x42, 0x5f, 0xc1, 0x6b, 0x5f, 0xc1, 0x57, 0xf0, 0xde, 0x57, 0x30, 0x33, 0x9d,
	0x2a, 0xdb, 0xed, 0x2c, 0xdb, 0x78, 0xd7, 0x7c, 0x33, 0xe7, 0x7c, 0xdf, 0xf9, 0xfa, 0x9d, 0x16,
	0xee, 0x06, 0x42, 0x04, 0x21, 0x75, 0x03, 0x11, 0x12, 0x1e, 0xb8, 0xa2, 0x13, 0x78, 0x01, 0xe5,
	0x51, 0x47, 0xc4, 0xc2, 0x4b, 0x8e, 0x48, 0xc4, 0xa4, 0xe7, 0x87, 0x62, 0xb7, 0xed, 0xb5, 0x58,
	0x18, 0x32, 0x1e, 0x78, 0x7b, 0x6b, 0x09, 0xd0, 0x34, 0x80, 0xab, 0xef, 0xe3, 0x63, 0xa6, 0x97,
	0x3e, 0x73, 0xd3, 0xb3, 0xbd, 0xb5, 0xca, 0xd6, 0x60, 0x24, 0x24, 0x62, 0x9e, 0xa4, 0x9d, 0x3d,
	0xe6, 0x53, 0x5f, 0xf0, 0x6d, 0x16, 0x78, 0x84, 0x73, 0x11, 0x93, 0x98, 0x09, 0x2e, 0x13, 0x0e,
	0xe7, 0x09, 0x4c, 0x6e, 0x24, 0x8d, 0x6f, 0xf9, 0xbe, 0xd8, 0xe5, 0x31, 0xc6, 0x30, 0xc2, 0xc9,
	0x0e, 0x2d, 0xa3, 0x25, 0xb4, 0x5a, 0x6a, 0xe8, 0x67, 0x85, 0x89, 0x88, 0xf2, 0xf2, 0xd0, 0x12,
	0x5a, 0x1d, 0x6b, 0xe8, 0x67, 0xbc, 0x0c, 0x13, 0x6d, 0x26, 0xa3, 0x90, 0xbc, 0x6a, 0xea, 0xfb,
	0xc3, 0xfa, 0xfe, 0xb8, 0xc1, 0xee, 0x93, 0x1d, 0xea, 0x7c, 0x46, 0x80, 0xeb, 0x1d, 0xf1, 0x8c,
	0xfa, 0xb1, 0x21, 0xd9, 0xe2, 0xdb, 0x22, 0x97, 0x61, 0x01, 0x20, 0x4a, 0x6e, 0x36, 0x59, 0x5b,
	0xf3, 0x94, 0x1a, 0x25, 0x83, 0x6c, 0xb5, 0xf1, 0x05, 0x98, 0x35, 0xf3, 0x37, 0x49, 0xa2, 0xf3,
	0x20, 0x29, 0x6e, 0x75, 0x8d, 0xa0, 0xb8, 0xf1, 0x0a, 0x4c, 0xa5, 0x15, 0x94, 0x93, 0x56, 0x48,
	0xdb, 0xe5, 0x11, 0xad, 0x7e, 0xd2, 0xc0, 0x77, 0x12, 0xd4, 0x71, 0xa1, 0xbc, 0x49, 0xe3, 0x6e,
	0x13, 0x1a, 0xf4, 0xc5, 0x2e, 0x95, 0xb9, 0x5e, 0x38, 0x8f, 0xa1, 0x72, 0x8f, 0xc9, 0x4c, 0x81,
	0x4c, 0x2b, 0xaa, 0x50, 0x8a, 0x48, 0x40, 0x9b, 0x92, 0xed, 0x27, 0x65, 0xff, 0x35, 0xc6, 0x14,
	0xf0, 0x80, 0xed, 0x27, 0x43, 0xaa, 0xc3, 0x58, 0x3c, 0x37, 0x66, 0xaa, 0x21, 0x49, 0x40, 0x1f,
	0x2a, 0xc0, 0xf9, 0x88, 0xa0, 0x9a, 0xdb, 0x5a, 0x46, 0x82, 0x4b, 0x8a, 0x1b, 0x70, 0x24, 0x63,
	0x82, 0x2c, 0xa3, 0xa5, 0xe1, 0xd5, 0xf1, 0xda, 0x8a, 0x6b, 0x89, 0x8a, 0x9b, 0x99, 0x6b, 0xaa,
	0xdb, 0x29, 0x89, 0x4f, 0xc3, 0x14, 0xa7, 0x2f, 0xe3, 0x66, 0x8f, 0xae, 0xff, 0x15, 0x5c, 0xff,
	0xa3, 0x4d, 0xc0, 0x82, 0x92, 0xd6, 0xfb, 0x36, 0xfb, 0x58, 0xd5, 0x6d, 0xc6, 0x50, 0x5f, 0x33,
	0x86, 0xb3, 0x66, 0x7c, 0x45, 0xb0, 0x68, 0x63, 0x34, 0x7e, 0x3c, 0x85, 0xd9, 0x34, 0x33, 0xa9,
	0x2f, 0x8c, 0x6f, 0x0b, 0xe3, 0xc9, 0x39, 0xab, 0x27, 0x39, 0x2d, 0x71, 0xd4, 0x1b, 0xd3, 0x41,
	0xad, 0xa9, 0xc1, 0xfc, 0x26, 0x2d, 0xe6, 0x8c, 0xf3, 0x1e, 0xc1, 0xf1, 0x47, 0x51, 0x9b, 0xc4,
	0xb4, 0x98, 0xa3, 0xb6, 0x91, 0x95, 0xb0, 0x7f, 0x1f, 0xb9, 0xf6, 0x6b, 0x14, 0x26, 0x6e, 0xab,
	0x5a, 0x03, 0xe2, 0x0f, 0x08, 0xa6, 0x7b, 0xb6, 0x03, 0xaf, 0x59, 0x79, 0x6c, 0x9b, 0x54, 0x19,
	0x34, 0xa1, 0xce, 0xc9, 0xb7, 0x3f, 0x7e, 0xbe, 0x1b, 0x5a, 0xc4, 0xf3, 0xea, 0xab, 0xf8, 0x5a,
	0x0d, 0x7d, 0x23, 0x93, 0x59, 0xef, 0xec, 0x1b, 0xfc, 0x09, 0xc1, 0x4c, 0xce, 0xaa, 0xe0, 0x75,
	0x2b, 0x8d, 0x7d, 0x67, 0x2b, 0x17, 0x8b, 0x15, 0x25, 0xe9, 0x73, 0xaa, 0x5a, 0xe8, 0x1c, 0x9e,
	0x51, 0x42, 0xb3, 0x6b, 0xf5, 0x0d, 0xc1, 0xd1, 0xfc, 0xf4, 0xe2, 0xcb, 0x7d, 0xd9, 0xac, 0x71,
	0xa8, 0x5c, 0x29, 0x5c, 0x67, 0x84, 0x9e, 0xd7, 0x42, 0x57, 0xf0, 0xa9, 0x7e, 0x8e, 0x7a, 0x26,
	0x0d, 0x12, 0x7f, 0x41, 0x30, 0x97, 0x9b, 0x67, 0x7c, 0xa9, 0xdf, 0x6b, 0xb7, 0x0b, 0x2f, 0x92,
	0x4a, 0xe7, 0x8c, 0x16, 0x7b, 0x02, 0x2f, 0xff, 0x15, 0x9b, 0x2a, 0x53, 0x2a, 0x5b, 0x07, 0xe4,
	0x7c, 0x47, 0x50, 0xb6, 0xed, 0x10, 0xbe, 0x6a, 0x25, 0x3d, 0x64, 0xed, 0x8a, 0xc9, 0xbd, 0xa9,
	0xe5, 0x5e, 0xab, 0x1c, 0x2e, 0xf7, 0x7a, 0xee, 0xe2, 0x6e, 0xd4, 0xa0, 0xea, 0x8b, 0x1d, 0x1b,
	0xe5, 0xc6, 0xf4, 0xc1, 0x6d, 0xac, 0xab, 0x3f, 0x76, 0x1d, 0xb5, 0x46, 0xf5, 0xaf, 0x7b, 0xfd,
	0x77, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa6, 0xd6, 0xd7, 0x61, 0x6c, 0x08, 0x00, 0x00,
}
