%define buildver 0.8.9
%define specrel 1

# CVS versions are pre-releases and must be treated differently than "real"
# releases, because otherwise we end up with a version "xyzCVS", which rpm
# thinks is "newer" than a version "xyz", although in fact it's the other way
# around. The fix for this is to strip off the "CVS" from the version number
# and use it in the "release" field instead.
%define rawversion %(echo "%{buildver}" | %{__sed} -e 's@CVS$@@')
%define cvsrelease %(echo "%{buildver}" | %{__sed} -e 's@^.*CVS$@CVS@')
%define releasever %(if [ "%{cvsrelease}" = "CVS" ]; then echo "0.CVS.%{specrel}"; else echo "%{specrel}"; fi)

Summary:	Fetch mail out of your Hotmail or MSN account
Name:		gotmail
Epoch:		1
Version:	%{rawversion}
Release:	%{releasever}
License:	GPL
Group:		Applications/Internet
URL:		http://sourceforge.net/projects/gotmail/
BuildArch:	noarch
Source:		http://dl.sf.net/gotmail/gotmail-%{buildver}.tar.bz2
Requires:	perl >= 5, curl >= 7.9.8
BuildRoot:	%{_tmppath}/%{name}-%{buildver}-%{release}-root

%description
This is Gotmail, a perl script to fetch mail out of your Hotmail
or MSN account. This is especially useful if you want to move from
Hotmail into one of the other free mail services - one command can
do it all. Gotmail also supports getting any new mail only from your
Hotmail or MSN account - perfect for using a Hotmail account as a
redirect address into another account.

%prep
%setup -q -n gotmail-%{buildver}

%build
%{__make}

%install
[ "%{buildroot}" != "/" -a -n "%{buildroot}" ] && %{__rm} -rf "%{buildroot}"
%{__make} install DESTDIR="%{buildroot}" \
	BINDIR=%{_bindir} \
	MANDIR=%{_mandir} \
	MANCOMPRESS= \
	INSTALL=%{__install}

%clean
[ "%{buildroot}" != "/" -a -n "%{buildroot}" ] && %{__rm} -rf "%{buildroot}"

%files
%defattr(-,root,root,0755)
%doc COPYING ChangeLog README sample.gotmailrc NEWS PRESSRELEASE gotmail4evolution
%{_bindir}/gotmail
%{_mandir}/man1/gotmail.1*

%changelog
* Fri Sep  9 2005 Paul Howarth <paul@city-fan.org> 0.8.7-1
- build from bzipped source
- include PRESSRELEASE

* Thu Aug 11 2005 Paul Howarth <paul@city-fan.org> 0.8.5-1
- add hooks for auto-specfile-editing in "make rpm", including sensible
  handling of CVS versions
- TODO no longer included

* Fri Jun 24 2005 Paul Howarth <paul@city-fan.org> 0.8.4-2
- initial version to bundle with upstream
