# tests/test_choice.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.bot import Bot
from gozerbot.generic import stringinlist, waitforqueue
from gozerbot.plugins import plugins
import unittest, Queue

plugins.reload('gozerplugs.plugs', 'choice')

class test_choice(unittest.TestCase):
    b = Bot()
    b.userhosts['test'] = 'test@test'

    def test_choice(self):
        result = self.b.test('choice')
        self.assert_(stringinlist('space seperated list', result))

    def test_choice2(self):
        result = self.b.test('choice a b')
        self.assert_('a' in result[0] or 'b' in result[0])

    def test_choice3(self):
        q = Queue.Queue()
        q.put('a')
        q.put('b')
        q.put(None)
        result = self.b.test('choice', kw = {'inqueue': q })
        self.assert_('a' in result[0] or 'b' in result[0])
