# tests/test_convert.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.bot import Bot
from gozerbot.generic import stringinlist
from gozerbot.plugins import plugins
import unittest

plugins.reload('gozerplugs.plugs', 'convert')

class test_convert(unittest.TestCase):
    b = Bot()
    b.userhosts['test'] = 'test@test'

    def test_convertlist(self):
        result = self.b.test('convert-list')
        self.assert_(stringinlist('celciustofahrenheit', result))

    def test_convert(self):
        result = self.b.test('convert')
        self.assert_(stringinlist('convert <num> <unit> to <unit>', result))

    def test_convert2(self):
        result = self.b.test('convert 1')
        self.assert_(stringinlist('convert <num> <unit> to <unit>', result))

    def test_convert3(self):
        result = self.b.test('convert 1 celcius')
        self.assert_(stringinlist('convert <num> <unit> to <unit>', result))

    def test_convert4(self):
        result = self.b.test('convert 1 celcius fahrenheit')
        self.assert_(stringinlist('convert <num> <unit> to <unit>', result))

    def test_convert5(self):
        result = self.b.test('convert 1 celcius to mekker')
        self.assert_(stringinlist("sorry can't", result))

    def test_convert6(self):
        result = self.b.test('convert 100 fahrenheit to celcius')
        self.assert_(stringinlist("37.7777723", result))
