# tests/test_grep.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.bot import Bot
from gozerbot.generic import stringinlist, waitforqueue
from gozerbot.plugins import plugins
import unittest, Queue

plugins.reload('gozerplugs.plugs', 'grep')

class test_grep(unittest.TestCase):
    b = Bot()
    b.userhosts['test'] = 'test@test'

    def test_grep(self):
        result = self.b.test('grep')
        self.assert_(stringinlist('use grep', result))

    def test_grep2(self):
        q = Queue.Queue()
        q.put('b')
        q.put(None)
        result = self.b.test('grep', kw = {'inqueue': q })
        self.assert_(stringinlist('grep <txt>', result))

    def test_grep3(self):
        q = Queue.Queue()
        q.put(None)
        result = self.b.test('grep a', kw = {'inqueue': q })
        self.assert_(stringinlist('no data', result))

    def test_grep4(self):
        q = Queue.Queue()
        q.put('a')
        q.put('b')
        q.put(None)
        result = self.b.test('grep a', kw = {'inqueue': q })
        self.assert_(stringinlist('a', result))

    def test_grep5(self):
        q = Queue.Queue()
        q.put('A')
        q.put('B')
        q.put(None)
        result = self.b.test('grep -i a', kw = {'inqueue': q })
        self.assert_(stringinlist('A', result))

    def test_grep6(self):
        q = Queue.Queue()
        q.put('A')
        q.put('B')
        q.put(None)
        result = self.b.test('grep -v A', kw = {'inqueue': q })
        self.assert_(stringinlist('B', result))

    def test_grep7(self):
        q = Queue.Queue()
        q.put('A')
        q.put('B')
        q.put(None)
        result = self.b.test('grep -r .*', kw = {'inqueue': q })
        self.assert_(stringinlist('B', result))
