# tests/test_karma.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.bot import Bot
from gozerbot.generic import stringinlist, waitforqueue
from gozerbot.plugins import plugins
import unittest, Queue

plugins.reload('gozerplugs.plugs', 'karma')

def limiter(bot, ievent):
    return 1


class test_karma(unittest.TestCase):
    b = Bot()
    b.userhosts['test'] = 'test@test'

    def setUp(self):
        import gozerplugs.plugs.karma as k
        k.ratelimit = limiter

    def test_karmaget(self):
        result = self.b.test('karma-get')
        self.assert_(stringinlist('<item>', result))

    def test_karmaget2(self):
        self.b.test('mekker++')
        result = self.b.test('karma-get mekker')
        self.b.test('mekker--')
        self.assert_(stringinlist('has karma', result))

    def test_karmaget3(self):
        result = self.b.test('karma-get blala55la')
        self.assert_(stringinlist('no karma yet', result))

    def test_karmadel(self):
        result = self.b.test('karma-del')
        self.assert_(stringinlist('<item>', result))

    def test_karmadel2(self):
        self.b.test('mekker++')
        result = self.b.test('karma-del mekker')
        self.assert_(stringinlist('deleted', result))

    def test_karmadel3(self):
        self.b.test('karma-del mekker')
        result = self.b.test('karma-del mekker')
        self.assert_(stringinlist("can't delete", result))

    def test_karmaup(self):
        result = self.b.test('mekker++')
        self.assert_(stringinlist("is now", result))

    def test_karmaup2(self):
        result = self.b.test('mekker++ # miep')
        self.assert_(stringinlist("is now", result))

    def test_karmadown(self):
        result = self.b.test('mekker--')
        self.assert_(stringinlist("is now", result))

    def test_karmadown2(self):
        result = self.b.test('mekker-- # miep')
        self.assert_(stringinlist("is now", result))

    def test_karmawhyup(self):
        result = self.b.test('karma-whyup')
        self.assert_(stringinlist("<item>", result))

    def test_karmawhyup2(self):
        self.b.test('mekker++ # test')
        result = self.b.test('karma-whyup mekker')
        self.assert_(stringinlist("test", result))

    def test_karmawhyup3(self):
        result = self.b.test('karma-whyup mekerblala44la')
        self.assert_(stringinlist("no reason", result))

    def test_karmawhydown(self):
        result = self.b.test('karma-whydown')
        self.assert_(stringinlist("<item>", result))

    def test_karmawhydown2(self):
        self.b.test('mekker-- # test')
        result = self.b.test('karma-whydown mekker')
        self.assert_(stringinlist("test", result))

    def test_karmawhydown3(self):
        result = self.b.test('karma-whydown mekerb33lalala')
        self.assert_(stringinlist("no reason", result))

    def test_karmagood(self):
        self.b.test('blabla++')
        result = self.b.test('karma-good')
        self.assert_(stringinlist('blabla', result))

    def test_karmabad(self):
        self.b.test('mekkerbla--')
        result = self.b.test('karma-bad')
        self.assert_(stringinlist('mekkerbla', result))

    def test_karmawhoup(self):
        result = self.b.test('karma-whoup')
        self.assert_(stringinlist("<item>", result))

    def test_karmawhoup2(self):
        self.b.test('mekker++ # test')
        result = self.b.test('karma-whoup mekker')
        self.assert_(stringinlist("test", result))

    def test_karmawhydown3(self):
        result = self.b.test('karma-whoup mekerb22lalala')
        self.assert_(stringinlist("no whokarmaup", result))

    def test_karmawhodown(self):
        result = self.b.test('karma-whodown')
        self.assert_(stringinlist("<item>", result))

    def test_karmawhodown2(self):
        self.b.test('mekker-- # test')
        result = self.b.test('karma-whodown mekker')
        self.assert_(stringinlist("test", result))

    def test_karmawhydown3(self):
        result = self.b.test('karma-whodown me11kerblalala')
        self.assert_(stringinlist("no whokarmadown", result))

    def test_karmasearch(self):
        result = self.b.test('karma-search')
        self.assert_(stringinlist('<txt>', result))

    def test_karmasearch2(self):
        result = self.b.test('karma-search mek')
        self.assert_(stringinlist('mekker', result))

    def test_karmasearch3(self):
        result = self.b.test('karma-search mekblalala')
        self.assert_(stringinlist('no karma items', result))

    def test_karmawhatup(self):
        result = self.b.test('karma-whatup')
        self.assert_(stringinlist('<nick>', result))

    def test_karmawhatup2(self):
        result = self.b.test('karma-whatup test')
        self.assert_(stringinlist('mekker', result))

    def test_karmawhatup3(self):
        result = self.b.test('karma-whatup testblalala')
        self.assert_(stringinlist('no karma items upped', result))

    def test_karmawhatdown(self):
        result = self.b.test('karma-whatdown')
        self.assert_(stringinlist('<nick>', result))

    def test_karmawhatdown2(self):
        result = self.b.test('karma-whatup test')
        self.assert_(stringinlist('mekker', result))

    def test_karmawhatdown3(self):
        result = self.b.test('karma-whatdown testblalala')
        self.assert_(stringinlist('no karma items downed', result))
