# tests/test_rss.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.bot import Bot
from gozerbot.generic import stringinlist, waitforqueue
from gozerbot.plugins import plugins
import unittest, Queue

plugins.reload('gozerplugs.plugs', 'rss')

class test_rss(unittest.TestCase):
    b = Bot('testbot', ['test@test', ])
    b.userhosts['test'] = 'test@test'

    def test_rssadd(self):
        result = self.b.test('rss-add dev http://core.gozerbot.org/hg/gozerdev?cl=tip;style=rss')
        self.b.test('rss-del dev')
        self.assert_(stringinlist('added', result))

    def test_rssadd2(self):
        result = self.b.test('rss-add dev')
        self.assert_(stringinlist('<name> <url>', result))

    def test_rssdel(self):
        self.b.test('rss-add dev http://core.gozerbot.org/hg/gozerdev?cl=tip;style=rss')
        result = self.b.test('rss-del dev')
        self.assert_(stringinlist('deleted', result))

    def test_rssdel2(self):
        result = self.b.test('rss-del dev2')
        self.assert_(stringinlist('no dev2 rss item', result))

    def test_rsswatch(self):
        result = self.b.test('rss-watch')
        self.assert_(stringinlist('<name>', result))

    def test_rsswatch2(self):
        result = self.b.test('rss-watch dev bla')
        self.assert_(stringinlist('needs to be in seconds', result))

    def test_rsswatch3(self):
        self.b.test('rss-add dev http://core.gozerbot.org/hg/gozerdev?cl=tip;style=rss')
        result = self.b.test('rss-watch dev')
        self.b.test('rss-stopwatch dev')
        self.b.test('rss-del dev')
        self.assert_(stringinlist('started', result))

    def test_rsswatch4(self):
        self.b.test('rss-add dev http://core.gozerbot.org/hg/gozerdev?cl=tip;style=rss')
        self.b.test('rss-watch dev')
        result = self.b.test('rss-watch dev')
        self.b.test('rss-stopwatch dev')
        self.b.test('rss-del dev')
        self.assert_(stringinlist('already', result))

    def test_rssaddchannel(self):
        self.b.test('rss-add dev http://core.gozerbot.org/hg/gozerdev?cl=tip;style=rss')
        self.b.test('rss-watch dev')
        result = self.b.test('rss-addchannel dev dunker@jabber.xs4all.nl')
        self.b.test('rss-del dev')
        self.assert_(stringinlist('added', result))

    def test_rsschannels(self):
        self.b.test('rss-add dev http://core.gozerbot.org/hg/gozerdev?cl=tip;style=rss')
        self.b.test('rss-watch dev')
        self.b.test('rss-addchannel dev dunker@jabber.xs4all.nl')
        result = self.b.test('rss-channels dev')
        self.b.test('rss-del dev')
        self.assert_(stringinlist('dunker', result))

    def test_rssdelchannel(self):
        self.b.test('rss-add dev http://core.gozerbot.org/hg/gozerdev?cl=tip;style=rss')
        self.b.test('rss-watch dev')
        self.b.test('rss-addchannel dev dunker@jabber.xs4all.nl')
        result = self.b.test('rss-delchannel dev dunker@jabber.xs4all.nl')
        self.b.test('rss-del dev')
        self.assert_(stringinlist('removed', result))

    def test_rssadditem(self):
        self.b.test('rss-add dev http://core.gozerbot.org/hg/gozerdev?cl=tip;style=rss')
        self.b.test('rss-watch dev')
        result = self.b.test('rss-additem dev link')
        self.b.test('rss-del dev')
        self.assert_(stringinlist('added', result))

    def test_rssdelitem(self):
        self.b.test('rss-add dev http://core.gozerbot.org/hg/gozerdev?cl=tip;style=rss')
        self.b.test('rss-watch dev')
        self.b.test('rss-additem dev link')
        result = self.b.test('rss-delitem dev link')
        self.b.test('rss-del dev')
        self.assert_(stringinlist("removed", result))

    def test_rssaddmarkup(self):
        self.b.test('rss-add dev http://core.gozerbot.org/hg/gozerdev?cl=tip;style=rss')
        self.b.test('rss-watch dev')
        result = self.b.test('rss-addmarkup dev noseperator 1')
        self.b.test('rss-del dev')
        self.assert_(stringinlist("added", result))

    def test_rssdelmarkup(self):
        self.b.test('rss-add dev http://core.gozerbot.org/hg/gozerdev?cl=tip;style=rss')
        self.b.test('rss-watch dev')
        self.b.test('rss-addmarkup dev noseperator')
        result = self.b.test('rss-delmarkup dev noseperator')
        self.b.test('rss-del dev')
        self.assert_(stringinlist("removed", result))

    def test_rssstart(self):
        self.b.test('rss-add dev http://core.gozerbot.org/hg/gozerdev?cl=tip;style=rss')
        self.b.test('rss-watch dev')
        result = self.b.test('rss-start dev')
        self.b.test('rss-del dev')
        self.assert_(stringinlist("started", result))

    def test_rssstop(self):
        self.b.test('rss-add dev http://core.gozerbot.org/hg/gozerdev?cl=tip;style=rss')
        self.b.test('rss-watch dev')
        self.b.test('rss-start dev')
        result = self.b.test('rss-stop dev')
        self.b.test('rss-del dev')
        self.assert_(stringinlist("stopped", result))

    def test_rssstopwatch(self):
        self.b.test('rss-add dev http://core.gozerbot.org/hg/gozerdev?cl=tip;style=rss')
        self.b.test('rss-watch dev')
        result = self.b.test('rss-stopwatch dev')
        self.b.test('rss-del dev')
        self.assert_(stringinlist("stopped", result))

    def test_rsssleeptime(self):
        self.b.test('rss-add dev http://core.gozerbot.org/hg/gozerdev?cl=tip;style=rss')
        self.b.test('rss-watch dev 60')
        result = self.b.test('rss-sleeptime dev')
        self.b.test('rss-del dev')
        self.assert_(stringinlist("60", result))

    def test_rsssetsleeptime(self):
        self.b.test('rss-add dev http://core.gozerbot.org/hg/gozerdev?cl=tip;style=rss')
        self.b.test('rss-watch dev 60')
        result = self.b.test('rss-setsleeptime dev 120')
        self.b.test('rss-del dev')
        self.assert_(stringinlist("set", result))

    def test_rssget(self):
        self.b.test('rss-add dev http://core.gozerbot.org/hg/gozerdev?cl=tip;style=rss')
        result = self.b.test('rss-get dev')
        self.b.test('rss-del dev')
        self.assert_(stringinlist("o", result))

    def test_rsslist(self):
        self.b.test('rss-add dev http://core.gozerbot.org/hg/gozerdev?cl=tip;style=rss')
        result = self.b.test('rss-list')
        self.b.test('rss-del dev')
        self.assert_(stringinlist("dev", result))

    def test_rssurl(self):
        self.b.test('rss-add dev http://core.gozerbot.org/hg/gozerdev?cl=tip;style=rss')
        result = self.b.test('rss-url dev')
        self.b.test('rss-del dev')
        self.assert_(stringinlist("core.gozerbot.org", result))

    def test_rssrunning(self):
        self.b.test('rss-add dev http://core.gozerbot.org/hg/gozerdev?cl=tip;style=rss')
        self.b.test('rss-watch dev 60')
        result = self.b.test('rss-running')
        self.b.test('rss-del dev')
        self.assert_(stringinlist("dev", result))

    def test_rssitemslist(self):
        self.b.test('rss-add dev http://core.gozerbot.org/hg/gozerdev?cl=tip;style=rss')
        self.b.test('rss-watch dev 60')
        result = self.b.test('rss-itemslist dev')
        self.b.test('rss-del dev')
        self.assert_(stringinlist("title", result))

    def test_rssscan(self):
        self.b.test('rss-add dev http://core.gozerbot.org/hg/gozerdev?cl=tip;style=rss')
        result = self.b.test('rss-scan dev')
        self.b.test('rss-del dev')
        self.assert_(stringinlist("title", result))

    def test_rsssync(self):
        self.b.test('rss-add dev http://core.gozerbot.org/hg/gozerdev?cl=tip;style=rss')
        result = self.b.test('rss-sync dev')
        self.b.test('rss-del dev')
        self.assert_(stringinlist("synced", result))

    def test_rssfeeds(self):
        self.b.test('rss-add dev http://core.gozerbot.org/hg/gozerdev?cl=tip;style=rss')
        self.b.test('rss-watch dev')
        self.b.test('rss-start dev')
        result = self.b.test('rss-feeds')
        self.b.test('rss-del dev')
        self.assert_(stringinlist("dev", result))

    def test_rsslink(self):
        self.b.test('rss-add dev http://core.gozerbot.org/hg/gozerdev?cl=tip;style=rss')
        self.b.test('rss-get dev')
        result = self.b.test('rss-link dev o')
        self.b.test('rss-del dev')
        self.assert_(stringinlist("o", result))

    def test_rssdecription(self):
        self.b.test('rss-add dev http://core.gozerbot.org/hg/gozerdev?cl=tip;style=rss')
        self.b.test('rss-get dev')
        result = self.b.test('rss-description dev o')
        self.b.test('rss-del dev')
        self.assert_(stringinlist("o", result))

    def test_rsssearch(self):
        self.b.test('rss-add dev http://core.gozerbot.org/hg/gozerdev?cl=tip;style=rss')
        self.b.test('rss-get dev')
        result = self.b.test('rss-search o')
        self.b.test('rss-del dev')
        self.assert_(result)

    def test_rssall(self):
        self.b.test('rss-add dev http://core.gozerbot.org/hg/gozerdev?cl=tip;style=rss')
        self.b.test('rss-get dev')
        result = self.b.test('rss-all dev')
        self.b.test('rss-del dev')
        self.assert_(result)

    def test_rssdump(self):
        self.b.test('rss-add dev http://core.gozerbot.org/hg/gozerdev?cl=tip;style=rss')
        self.b.test('rss-get dev')
        result = self.b.test('rss-dump dev')
        self.b.test('rss-del dev')
        self.assert_(result)
