/*
 * GPG Keys 
 * ckeyserver.h
 * (c) 2001 Peter Mathiasson <peter@mathiasson.nu>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation
 */

#ifndef __CKEYSERVER_H__
#define __CKEYSERVER_H__

#include <qobject.h>

class QString;
class QSocket;

class CKeyServer : public QObject
{
    Q_OBJECT

public:
    CKeyServer( QObject *parent = 0 );

    void search( QString searchString );    
    void getKey( QString keyID );
    void sendKey( QString keyData );

    int entriesFound;
    enum {
        Idle,
        Connecting,
        Sending,
        Waiting,
        Recieving
    };

public slots:
    void socketError();
    void socketConnected();
    void socketRead();
    void socketDone();

signals:
    void statusChange( int newStatus );
    void connectionFailed();
    void requestTimedout();

    void searchDone();
    void itemFound( QString type, QString name, QString date, QString keyID );

    void getDone( QString key );
    void sendDone();


private:
    void checkConfig();
    void socketReadSearch();
    QString removeHTMLTags( const QString string );
    void socketReadGet();
    const QString urlEncode( const QString data );
    void socketReadSend();

    QSocket *socket;
    QString server;
    QString searchCommand;
    int port;
    int requestTimeout;
    QString request;
    int operation;

    QString data;

};

#endif // __CKEYSERVER_H__

