/***************************************************************************
                          gpc_query.h  -  description
                             -------------------
    begin                : Wed May 17 2000
    copyright            : (C) 2000 by Thierry Florac
    email                : tflorac@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GPC_QUERY_H
#define GPC_QUERY_H

#include <gnome.h>

#include "pg_connection.h"
#include "pg_query.h"


typedef enum {
  GPC_FILM_ID = 0,
  GPC_FILM_PATHNAME,
  GPC_FILM_KIND,
  GPC_FILM_NUMBER,
  GPC_FILM_MAKER,
  GPC_FILM_MODEL,
  GPC_FILM_ISO,
  GPC_FILM_SIZE,
  GPC_FILM_PERIOD,
  GPC_FILM_DESCRIPTION,
  GPC_FILM_KEYWORD,
  GPC_CAMERA_MAKER,
  GPC_CAMERA_MODEL,
  GPC_IMAGE_ID,
  GPC_IMAGE_FILENAME,
  GPC_IMAGE_WIDTH,
  GPC_IMAGE_HEIGHT,
  GPC_IMAGE_MIME_TYPE,
  GPC_IMAGE_NUMBER,
  GPC_IMAGE_SPEED,
  GPC_IMAGE_LATITUDE,
  GPC_IMAGE_LONGITUDE,
  GPC_IMAGE_ELEVATION,
  GPC_IMAGE_DIRECTION,
  GPC_IMAGE_PITCH,
  GPC_IMAGE_ROLL,
  GPC_IMAGE_INTEREST_NOTE,
  GPC_IMAGE_QUALITY_NOTE,
  GPC_IMAGE_DESCRIPTION,
  GPC_IMAGE_KEYWORD,
  GPC_LENS_MAKER,
  GPC_LENS_MODEL,
  GPC_LENS_FOCAL_LENGTH,
  GPC_LENS_APERTURE,
  GPC_QUERY_END
} GpcQueryParam;

#define GPC_FILM_FIRST GPC_FILM_ID
#define GPC_FILM_LAST  GPC_CAMERA_MODEL

#define GPC_IMAGE_FIRST GPC_IMAGE_ID
#define GPC_IMAGE_LAST  GPC_LENS_APERTURE


static gchar *GpcQueryParamLib[GPC_QUERY_END] = {
  N_("Film -> ID"),
  N_("Film -> PathName"),
  N_("Film -> Kind"),
  N_("Film -> Number"),
  N_("Film -> Maker"),
  N_("Film -> Model"),
  N_("Film -> ISO"),
  N_("Film -> Size"),
  N_("Film -> Period"),
  N_("Film -> Description"),
  N_("Film -> Keyword"),
  N_("Camera -> Maker"),
  N_("Camera -> Model"),
  N_("Image -> ID"),
  N_("Image -> Filename"),
  N_("Image -> Width"),
  N_("Image -> Height"),
  N_("Image -> MIME type"),
  N_("Image -> Number"),
  N_("Image -> Speed"),
  N_("Image -> Latitude"),
  N_("Image -> Longitude"),
  N_("Image -> Elevation"),
  N_("Image -> Direction"),
  N_("Image -> Pitch"),
  N_("Image -> Roll"),
  N_("Image -> Interest note"),
  N_("Image -> Quality note"),
  N_("Image -> Description"),
  N_("Image -> Keyword"),
  N_("Lens -> Maker"),
  N_("Lens -> Model"),
  N_("Lens -> Focal length"),
  N_("Lens -> Aperture")
};


static gchar *GpcQueryParamField[GPC_QUERY_END] = {
  "FILM.ID",
  "FILM.PATHNAME",
  "FILM.KIND",
  "FILM.NUMBER",
  "FILM.MAKER",
  "FILM.MODEL",
  "FILM.ISO",
  "FILM.SIZE",
  "FILM.PERIOD",
  "FILM.DESCRIPTION",
  "FILM_KEY.CODE",
  "FILM.CAMERA_MAKER",
  "FILM.CAMERA_MODEL",
  "IMAGE.ID",
  "IMAGE.FILENAME",
  "IMAGE.WIDTH",
  "IMAGE.HEIGHT",
  "IMAGE.MIME_TYPE",
  "IMAGE.NUMBER",
  "IMAGE.SPEED",
  "IMAGE.LATITUDE",
  "IMAGE.LONGITUDE",
  "IMAGE.ELEVATION",
  "IMAGE.DIRECTION",
  "IMAGE.PITCH",
  "IMAGE.ROLL",
  "IMAGE.INTEREST_NOTE",
  "IMAGE.QUALITY_NOTE",
  "IMAGE.DESCRIPTION",
  "IMAGE_KEY.CODE",
  "IMAGE.LENS_MAKER",
  "IMAGE.LENS_MODEL",
  "IMAGE.FOCAL",
  "IMAGE.APERTURE"
};


#define GPC_QUERY_OPERATORS 7

static gchar *GpcQueryOperator[GPC_QUERY_OPERATORS] = {
  "=",
  "!=",
  "<",
  "<=",
  ">",
  ">=",
  "like"
};


pgQuery* gpc_query_get_films (pgConnection *connection);
pgQuery* gpc_query_get_images (pgConnection *connection, gint film_ID);


void
on_gpc_query_dialog_realize            (GtkWidget       *widget,
                                        gpointer         user_data);

void
on_gpc_query_dialog_apply              (GnomePropertyBox *gnomepropertybox,
                                        gint             arg1,
                                        gpointer         user_data);

void
on_query_field_combo_entry_changed     (GtkEditable     *editable,
                                        gpointer         user_data);

void
on_query_params_add_button_clicked     (GtkButton       *button,
                                        gpointer         user_data);

void
on_film_query_clist_select_row         (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data);

void
on_film_query_delete_button_clicked    (GtkButton       *button,
                                        gpointer         user_data);

void
on_film_query_clear_button_clicked     (GtkButton       *button,
                                        gpointer         user_data);

void
on_image_query_clist_select_row        (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data);

void
on_image_query_delete_button_clicked   (GtkButton       *button,
                                        gpointer         user_data);

void
on_image_query_clear_button_clicked    (GtkButton       *button,
                                        gpointer         user_data);

#endif

void
on_query_operator_toggled              (GtkToggleButton *togglebutton,
                                        gpointer         user_data);
