/* This file is part of gPHPEdit, a GNOME2 PHP Editor.

   Copyright © 2003-2004 Andy Jeffries
      andy@gphpedit.org
	  
   For more information or to find the latest release, visit our 
   website at http://www.gphpedit.org/

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.

   The GNU General Public License is contained in the file COPYING.*/
   

#include "main.h"
#include "gphpedit_ipc.h"

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <stdio.h>
#include <unistd.h>
#include <pwd.h>
#include <signal.h>

char homedir[256];
char socket_filename[1024];

gboolean can_open_socket()
{
	int sockfd;
	int len;
	struct sockaddr_un address;
	int result;
	
	sockfd = socket(AF_UNIX, SOCK_STREAM, 0);
	address.sun_family = AF_UNIX;
	strcpy(address.sun_path, socket_filename);
	len = sizeof(address);
	result = connect(sockfd, (struct sockaddr *)&address, len);

	if (result == -1) {
		return FALSE;
	}		
	close(sockfd);
	return TRUE;
}

gboolean check_for_ipc_files()
{
	uid_t current_uid;
	struct passwd *current_user_pw_details;
	GString *pidfile;
	GString *sockfile;
	FILE *pidfd;
	pid_t pid;
	gboolean socket_available;
	
	current_uid = getuid();
	current_user_pw_details = getpwuid(current_uid);
	
	strncpy(homedir, current_user_pw_details->pw_dir, 255);
	
	pidfile = g_string_new(homedir);
	pidfile = g_string_append(pidfile, "/.gphpedit/gphpedit.pid");
	pidfd = fopen(pidfile->str, "r");
	if (pidfd) {
		fread(&pid, sizeof(pid), 1, pidfd);
		fclose(pidfd);
		g_string_free(pidfile, TRUE);
		
		// Send a signal to see if the other process responds
		// If you're not a Unix programmer, kill doesn't actually kill
		// the other process - it just means send a signal
		if (kill(pid, SIGUSR1) != -1) {
			// OK, 'ping' signal returned
			sockfile = g_string_new(homedir);
			sockfile = g_string_append(sockfile, "/.gphpedit/ipc.sock");
			strncpy(socket_filename, sockfile->str, 1023);
			g_string_free(sockfile, TRUE);
			socket_available = can_open_socket();
			if (socket_available) {
				return TRUE;
			}
		}
		
	}
	return FALSE;
}

// DOWN TO HERE, STILL NEED TO CREATE PID/SOCKET AND PASS FILES/COMMANDS THROUGH TO IT

void pass_params_to_other_process(char **argv)
{	
	guint i;

	if (argv) {
		i = 1;
		while (argv[i] != NULL) {
			//tab_create_new(TAB_FILE, g_string_new(argv[i]));
			++i;
		}
	}
}

gboolean want_new_process()
{
	return TRUE;
}

void create_ipc_files()
{
	int sockfd;
	int len;
	struct sockaddr_un address;
	int result;
	pid_t pid;
	FILE *pidfd;
	GString *pidfile;
	//GString *sockfile;
	
	pidfile = g_string_new(homedir);
	pidfile = g_string_append(pidfile, "/.gphpedit/gphpedit.pid");
	pidfd = fopen(pidfile->str, "w");
	if (pidfd) {
		pid = getpid();
		fwrite(&pid, sizeof(pid), 1, pidfd);
		fclose(pidfd);
	}

	// create socket with callback....
	
	sockfd = socket(AF_UNIX, SOCK_STREAM, 0);
	address.sun_family = AF_UNIX;
	strcpy(address.sun_path, socket_filename);
	len = sizeof(address);
	result = connect(sockfd, (struct sockaddr *)&address, len);

}
